/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.chat.hook;

import java.util.ArrayList;
import java.util.Map;
import me.neznamy.tab.shared.chat.TabStyle;
import me.neznamy.tab.shared.chat.TabTextColor;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.chat.component.TabKeybindComponent;
import me.neznamy.tab.shared.chat.component.TabTextComponent;
import me.neznamy.tab.shared.chat.component.TabTranslatableComponent;
import me.neznamy.tab.shared.chat.component.object.TabObjectComponent;
import me.neznamy.tab.shared.chat.hook.AdventureObjectHook;
import me.neznamy.tab.shared.chat.hook.AdventureShadowHook;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdventureHook {
    private static final boolean SHADOW_COLOR_AVAILABLE;
    private static final boolean OBJECT_COMPONENTS_AVAILABLE;

    @NotNull
    public static Component convert(@NotNull TabComponent component) {
        Style.Builder style = Style.style().color(component.getModifier().getColor() == null ? null : TextColor.color((int)component.getModifier().getColor().getRgb())).decoration(TextDecoration.BOLD, AdventureHook.getDecoration(component.getModifier().getBold())).decoration(TextDecoration.ITALIC, AdventureHook.getDecoration(component.getModifier().getItalic())).decoration(TextDecoration.UNDERLINED, AdventureHook.getDecoration(component.getModifier().getUnderlined())).decoration(TextDecoration.STRIKETHROUGH, AdventureHook.getDecoration(component.getModifier().getStrikethrough())).decoration(TextDecoration.OBFUSCATED, AdventureHook.getDecoration(component.getModifier().getObfuscated())).font(component.getModifier().getFont() == null ? null : Key.key((String)component.getModifier().getFont()));
        if (SHADOW_COLOR_AVAILABLE) {
            AdventureShadowHook.setShadowColor(style, component.getModifier().getShadowColor());
        }
        ArrayList<Component> list = new ArrayList<Component>();
        for (TabComponent extra : component.getExtra()) {
            list.add(AdventureHook.convert(extra));
        }
        if (component instanceof TabTextComponent) {
            return Component.text((String)((TabTextComponent)component).getText(), (Style)style.build()).children(list);
        }
        if (component instanceof TabTranslatableComponent) {
            return Component.translatable((String)((TabTranslatableComponent)component).getKey(), (Style)style.build()).children(list);
        }
        if (component instanceof TabKeybindComponent) {
            return Component.keybind((String)((TabKeybindComponent)component).getKeybind(), (Style)style.build()).children(list);
        }
        if (component instanceof TabObjectComponent) {
            if (OBJECT_COMPONENTS_AVAILABLE) {
                AdventureObjectHook.convert((TabObjectComponent)component);
            } else {
                return Component.text((String)"<Object components are not supported in your version of Adventure library>");
            }
        }
        throw new UnsupportedOperationException(component.getClass().getName() + " component type is not supported");
    }

    @NotNull
    private static TextDecoration.State getDecoration(@Nullable Boolean state) {
        if (state == null) {
            return TextDecoration.State.NOT_SET;
        }
        return state != false ? TextDecoration.State.TRUE : TextDecoration.State.FALSE;
    }

    @NotNull
    public static TabComponent convert(@NotNull Component component) {
        TabComponent tabComponent;
        if (component instanceof TextComponent) {
            tabComponent = new TabTextComponent(((TextComponent)component).content());
        } else if (component instanceof TranslatableComponent) {
            tabComponent = TabComponent.translatable(((TranslatableComponent)component).key());
        } else if (component instanceof KeybindComponent) {
            tabComponent = TabComponent.keybind(((KeybindComponent)component).keybind());
        } else if (component instanceof ObjectComponent) {
            tabComponent = AdventureObjectHook.convert((ObjectComponent)component);
        } else {
            throw new UnsupportedOperationException(component.getClass().getName() + " component type is not supported");
        }
        Map decorations = component.style().decorations();
        TextColor color = component.color();
        Key font = component.font();
        tabComponent.setModifier(new TabStyle(color == null ? null : new TabTextColor(color.value()), SHADOW_COLOR_AVAILABLE ? AdventureShadowHook.getShadowColor(component) : null, AdventureHook.getDecoration((TextDecoration.State)decorations.get(TextDecoration.BOLD)), AdventureHook.getDecoration((TextDecoration.State)decorations.get(TextDecoration.ITALIC)), AdventureHook.getDecoration((TextDecoration.State)decorations.get(TextDecoration.UNDERLINED)), AdventureHook.getDecoration((TextDecoration.State)decorations.get(TextDecoration.STRIKETHROUGH)), AdventureHook.getDecoration((TextDecoration.State)decorations.get(TextDecoration.OBFUSCATED)), font == null ? null : font.asString()));
        for (Component extra : component.children()) {
            tabComponent.addExtra(AdventureHook.convert(extra));
        }
        tabComponent.setAdventureComponent(component);
        return tabComponent;
    }

    @Nullable
    private static Boolean getDecoration(@Nullable TextDecoration.State state) {
        if (state == null || state == TextDecoration.State.NOT_SET) {
            return null;
        }
        return state == TextDecoration.State.TRUE;
    }

    static {
        boolean value;
        OBJECT_COMPONENTS_AVAILABLE = ReflectionUtils.classExists("net.kyori.adventure.text.ObjectComponent");
        try {
            Component.class.getDeclaredMethod("shadowColor", new Class[0]);
            value = true;
        }
        catch (Throwable t) {
            value = false;
        }
        SHADOW_COLOR_AVAILABLE = value;
    }
}

