/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.chat.rgb.format;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.neznamy.tab.shared.chat.TabTextColor;
import me.neznamy.tab.shared.chat.rgb.format.RGBFormatter;
import org.jetbrains.annotations.NotNull;

public class BukkitFormat
implements RGBFormatter {
    private final Pattern pattern = Pattern.compile("\u00a7x[\u00a7\\p{XDigit}]{12}");

    @Override
    @NotNull
    public String reformat(@NotNull String text, @NotNull Function<TabTextColor, String> rgbFunction) {
        if (!text.contains("\u00a7x")) {
            return text;
        }
        String replaced = text;
        Matcher m = this.pattern.matcher(replaced);
        while (m.find()) {
            String group = m.group();
            String hexCode = new String(new char[]{group.charAt(3), group.charAt(5), group.charAt(7), group.charAt(9), group.charAt(11), group.charAt(13)});
            replaced = replaced.replace(group, rgbFunction.apply(new TabTextColor(hexCode)));
        }
        return replaced;
    }
}

