/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.com.saicone.delivery4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import me.neznamy.tab.libs.com.saicone.delivery4j.ChannelConsumer;
import me.neznamy.tab.libs.com.saicone.delivery4j.util.Encryptor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageChannel {
    private final String name;
    private ChannelConsumer<String[]> consumer;
    private Cache cache;
    private Encryptor encryptor;

    @NotNull
    public static MessageChannel of(@NotNull String name) {
        return new MessageChannel(name);
    }

    public MessageChannel(@NotNull String name) {
        this.name = name;
    }

    public MessageChannel(@NotNull String name, @Nullable ChannelConsumer<String[]> consumer) {
        this.name = name;
        this.consumer = consumer;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public ChannelConsumer<String[]> getConsumer() {
        return this.consumer;
    }

    @Nullable
    public Cache getCache() {
        return this.cache;
    }

    @Nullable
    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    @NotNull
    @Contract(value="_ -> this")
    public MessageChannel consume(@NotNull ChannelConsumer<String[]> consumer) {
        this.consumer = this.consumer == null ? consumer : this.consumer.andThen(consumer);
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public MessageChannel consumeBefore(@NotNull ChannelConsumer<String[]> consumer) {
        this.consumer = this.consumer == null ? consumer : consumer.andThen(this.consumer);
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public MessageChannel cache(boolean enable) {
        if (enable) {
            return this.cache(10L, TimeUnit.SECONDS);
        }
        return this.cache(null);
    }

    @NotNull
    @Contract(value="_, _ -> this")
    public MessageChannel cache(long duration, @NotNull TimeUnit unit) {
        return this.cache(Cache.of(duration, unit));
    }

    @NotNull
    @Contract(value="_ -> this")
    public MessageChannel cache(@Nullable Cache cache) {
        this.cache = cache;
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public MessageChannel encryptor(@Nullable Encryptor encryptor) {
        this.encryptor = encryptor;
        return this;
    }

    public byte[] encode(Object ... lines) throws IOException {
        try (ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(arrayOut);){
                if (this.cache != null) {
                    out.writeInt(this.cache.generate());
                }
                out.writeInt(lines.length);
                if (this.encryptor == null) {
                    for (Object message : lines) {
                        out.writeUTF(Objects.toString(message));
                    }
                } else {
                    try {
                        for (Object message : lines) {
                            byte[] bytes = this.encryptor.encrypt(Objects.toString(message));
                            out.writeInt(bytes.length);
                            out.write(bytes);
                        }
                    }
                    catch (Throwable throwable) {
                        throw new IOException("Cannot encrypt message into channel " + this.name, throwable);
                    }
                }
                byArray = arrayOut.toByteArray();
            }
            return byArray;
        }
    }

    @Nullable
    public String[] decode(byte[] src) throws IOException {
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(src));){
            String[] lines;
            block14: {
                if (this.cache != null && this.cache.contains(in.readInt())) {
                    String[] stringArray = null;
                    return stringArray;
                }
                lines = new String[in.readInt()];
                try {
                    int i;
                    if (this.encryptor == null) {
                        for (i = 0; i < lines.length; ++i) {
                            String message = in.readUTF();
                            lines[i] = message.equalsIgnoreCase("null") ? null : message;
                        }
                        break block14;
                    }
                    try {
                        for (i = 0; i < lines.length; ++i) {
                            String message = this.encryptor.decrypt(in.readNBytes(in.readInt()));
                            lines[i] = message.equalsIgnoreCase("null") ? null : message;
                        }
                    }
                    catch (Throwable t) {
                        throw new IOException("Cannot decrypt message from channel " + this.name, t);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            String[] stringArray = lines;
            return stringArray;
        }
    }

    public boolean accept(byte[] src) throws IOException {
        String[] lines = this.decode(src);
        if (lines == null) {
            return false;
        }
        if (this.consumer != null) {
            this.consumer.accept(this.getName(), lines);
        }
        return true;
    }

    public void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public static abstract class Cache {
        @NotNull
        public static Cache of(final long duration, final @NotNull TimeUnit unit) {
            try {
                Class.forName("com.github.benmanes.caffeine.cache.Caffeine");
                return Class.forName("me.neznamy.tab.libs.com.saicone.delivery4j.cache.CaffeineCache").asSubclass(Cache.class).getDeclaredConstructor(Long.TYPE, TimeUnit.class).newInstance(new Object[]{duration, unit});
            }
            catch (Throwable throwable) {
                try {
                    Class.forName("com.google.common.cache.CacheBuilder");
                    return Class.forName("me.neznamy.tab.libs.com.saicone.delivery4j.cache.GuavaCache").asSubclass(Cache.class).getDeclaredConstructor(Long.TYPE, TimeUnit.class).newInstance(new Object[]{duration, unit});
                }
                catch (Throwable throwable2) {
                    return new Cache(){
                        private final Map<Integer, Long> cache = new HashMap<Integer, Long>();
                        private final long millis = unit.toMillis(duration);

                        @Override
                        protected void save(int id) {
                            long currentTime = System.currentTimeMillis();
                            if (id < 1999) {
                                long time = currentTime - this.millis;
                                this.cache.entrySet().removeIf(entry -> (Long)entry.getValue() <= time);
                            }
                            this.cache.put(id, currentTime);
                        }

                        @Override
                        public boolean contains(int id) {
                            return this.cache.containsKey(id);
                        }

                        @Override
                        public void clear() {
                            this.cache.clear();
                        }
                    };
                }
            }
        }

        protected abstract void save(int var1);

        public abstract boolean contains(int var1);

        public int generate() {
            int id = ThreadLocalRandom.current().nextInt(0, 1000000);
            this.save(id);
            return id;
        }

        public abstract void clear();
    }
}

