/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.com.saicone.delivery4j.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.jetbrains.annotations.NotNull;

public interface Encryptor {
    @NotNull
    public static Encryptor of(@NotNull SecretKey key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return Encryptor.of("AES", key, StandardCharsets.UTF_8);
    }

    @NotNull
    public static Encryptor of(@NotNull SecretKey key, @NotNull Charset charset) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return Encryptor.of("AES", key, charset);
    }

    @NotNull
    public static Encryptor of(@NotNull String transformation, @NotNull SecretKey key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return Encryptor.of(transformation, key, StandardCharsets.UTF_8);
    }

    @NotNull
    public static Encryptor of(final @NotNull String transformation, final @NotNull SecretKey key, final @NotNull Charset charset) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        final Cipher encryptMode = Cipher.getInstance(transformation);
        encryptMode.init(1, key);
        final Cipher decryptMode = Cipher.getInstance(transformation);
        decryptMode.init(2, key);
        return new Encryptor(){
            private Cipher encrypt;
            private Cipher decrypt;
            {
                this.encrypt = encryptMode;
                this.decrypt = decryptMode;
            }

            @Override
            public byte[] encrypt(@NotNull String input) {
                try {
                    return this.encrypt.doFinal(input.getBytes(charset));
                }
                catch (Throwable t) {
                    try {
                        this.encrypt = Cipher.getInstance(transformation);
                        this.encrypt.init(1, key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new RuntimeException(t);
                }
            }

            @Override
            @NotNull
            public String decrypt(byte[] input) {
                try {
                    return new String(this.decrypt.doFinal(input), charset);
                }
                catch (Throwable t) {
                    try {
                        this.decrypt = Cipher.getInstance(transformation);
                        this.decrypt.init(2, key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new RuntimeException(t);
                }
            }
        };
    }

    public byte[] encrypt(@NotNull String var1);

    @NotNull
    public String decrypt(byte[] var1);
}

