/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.v1_19_R1;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.decorators.TrackedTabList;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.level.EnumGamemode;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NMSPacketTabList
extends TrackedTabList<BukkitTabPlayer> {
    private static final Field PLAYERS = ReflectionUtils.getOnlyField(PacketPlayOutPlayerInfo.class, List.class);
    private static final PacketPlayOutPlayerInfo.EnumPlayerInfoAction ADD_PLAYER = PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a;
    private static final PacketPlayOutPlayerInfo.EnumPlayerInfoAction UPDATE_GAME_MODE = PacketPlayOutPlayerInfo.EnumPlayerInfoAction.b;
    private static final PacketPlayOutPlayerInfo.EnumPlayerInfoAction UPDATE_LATENCY = PacketPlayOutPlayerInfo.EnumPlayerInfoAction.c;
    private static final PacketPlayOutPlayerInfo.EnumPlayerInfoAction UPDATE_DISPLAY_NAME = PacketPlayOutPlayerInfo.EnumPlayerInfoAction.d;

    public NMSPacketTabList(@NotNull BukkitTabPlayer player) {
        super(player);
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, entry, "", null, 0, 0, null);
    }

    @Override
    public void updateDisplayName0(@NonNull UUID entry, @Nullable TabComponent displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.d, entry, "", null, 0, 0, displayName);
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.c, entry, "", null, latency, 0, null);
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.b, entry, "", null, 0, gameMode, null);
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateListOrder(@NonNull UUID entry, int listOrder) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateHat(@NonNull UUID entry, boolean showHat) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void addEntry0(@NonNull TabList.Entry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, entry.getUniqueId(), entry.getName(), entry.getSkin(), entry.getLatency(), entry.getGameMode(), entry.getDisplayName());
    }

    @Override
    public void setPlayerListHeaderFooter0(@NonNull TabComponent header, @NonNull TabComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new PacketPlayOutPlayerListHeaderFooter((IChatBaseComponent)header.convert(), (IChatBaseComponent)footer.convert()));
    }

    @Override
    public boolean containsEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return true;
    }

    @Override
    @Nullable
    public TabList.Skin getSkin() {
        Collection properties = ((CraftPlayer)((BukkitTabPlayer)this.player).getPlayer()).getProfile().getProperties().get((Object)"textures");
        if (properties.isEmpty()) {
            return null;
        }
        Property property = (Property)properties.iterator().next();
        return new TabList.Skin(property.getValue(), property.getSignature());
    }

    @Override
    @NotNull
    public Object onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (!(packet instanceof PacketPlayOutPlayerInfo)) {
            return packet;
        }
        PacketPlayOutPlayerInfo info = (PacketPlayOutPlayerInfo)packet;
        PacketPlayOutPlayerInfo.EnumPlayerInfoAction action = info.c();
        ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> updatedList = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
        boolean rewritePacket = false;
        for (PacketPlayOutPlayerInfo.PlayerInfoData nmsData : info.b()) {
            Integer forcedGameMode;
            TabComponent forcedDisplayName;
            boolean rewriteEntry = false;
            GameProfile profile = nmsData.a();
            UUID id = profile.getId();
            IChatBaseComponent displayName = nmsData.d();
            int latency = nmsData.b();
            int gameMode = nmsData.c().a();
            ProfilePublicKey.a publicKey = nmsData.e();
            if ((action == UPDATE_DISPLAY_NAME || action == ADD_PLAYER) && (forcedDisplayName = this.getForcedDisplayNames().get(id)) != null && forcedDisplayName.convert() != displayName) {
                displayName = (IChatBaseComponent)forcedDisplayName.convert();
                rewritePacket = true;
                rewriteEntry = true;
            }
            if ((action == UPDATE_GAME_MODE || action == ADD_PLAYER) && (forcedGameMode = this.getForcedGameModes().get(id)) != null && forcedGameMode != gameMode) {
                gameMode = forcedGameMode;
                rewritePacket = true;
                rewriteEntry = true;
            }
            if ((action == UPDATE_LATENCY || action == ADD_PLAYER) && NMSPacketTabList.getForcedLatency() != null) {
                latency = NMSPacketTabList.getForcedLatency();
                rewritePacket = true;
                rewriteEntry = true;
            }
            if (action == ADD_PLAYER) {
                TAB.getInstance().getFeatureManager().onEntryAdd(this.player, id, profile.getName());
            }
            updatedList.add(rewriteEntry ? new PacketPlayOutPlayerInfo.PlayerInfoData(profile, latency, EnumGamemode.values()[gameMode], displayName, publicKey) : nmsData);
        }
        if (rewritePacket) {
            PacketPlayOutPlayerInfo newPacket = new PacketPlayOutPlayerInfo(action, Collections.emptyList());
            PLAYERS.set(newPacket, updatedList);
            return newPacket;
        }
        return packet;
    }

    private void sendPacket(@NonNull PacketPlayOutPlayerInfo.EnumPlayerInfoAction action, @NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, int latency, int gameMode, @Nullable TabComponent displayName) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        PacketPlayOutPlayerInfo packet = new PacketPlayOutPlayerInfo(action, new EntityPlayer[0]);
        PLAYERS.set(packet, Collections.singletonList(new PacketPlayOutPlayerInfo.PlayerInfoData(this.createProfile(id, name, skin), latency, EnumGamemode.values()[gameMode], displayName == null ? null : (IChatBaseComponent)displayName.convert(), null)));
        this.sendPacket((Packet<?>)packet);
    }

    @NotNull
    private GameProfile createProfile(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        GameProfile profile = new GameProfile(id, name);
        if (skin != null) {
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", skin.getValue(), skin.getSignature()));
        }
        return profile;
    }

    private void sendPacket(@NotNull Packet<?> packet) {
        ((CraftPlayer)((BukkitTabPlayer)this.player).getPlayer()).getHandle().b.a(packet);
    }
}

