/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.neoforge;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.neoforge.NeoForgeBossBar;
import me.neznamy.tab.platforms.neoforge.NeoForgeEventListener;
import me.neznamy.tab.platforms.neoforge.NeoForgePipelineInjector;
import me.neznamy.tab.platforms.neoforge.NeoForgeScoreboard;
import me.neznamy.tab.platforms.neoforge.NeoForgeTabList;
import me.neznamy.tab.platforms.neoforge.NeoForgeTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendPlatform;
import me.neznamy.tab.shared.chat.TabStyle;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.chat.component.TabKeybindComponent;
import me.neznamy.tab.shared.chat.component.TabTextComponent;
import me.neznamy.tab.shared.chat.component.TabTranslatableComponent;
import me.neznamy.tab.shared.chat.component.object.ObjectInfo;
import me.neznamy.tab.shared.chat.component.object.TabAtlasSprite;
import me.neznamy.tab.shared.chat.component.object.TabObjectComponent;
import me.neznamy.tab.shared.chat.component.object.TabPlayerSprite;
import me.neznamy.tab.shared.features.PerWorldPlayerListConfiguration;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.objects.AtlasSprite;
import net.minecraft.network.chat.contents.objects.PlayerSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.component.ResolvableProfile;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record NeoForgePlatform(MinecraftServer server) implements BackendPlatform
{
    private static final UUID NIL_UUID = new UUID(0L, 0L);

    @Override
    public void registerUnknownPlaceholder(@NotNull String identifier) {
        this.registerDummyPlaceholder(identifier);
    }

    @Override
    public void loadPlayers() {
        for (ServerPlayer player : this.getOnlinePlayers()) {
            TAB.getInstance().addPlayer(new NeoForgeTabPlayer(this, player));
        }
    }

    private Collection<ServerPlayer> getOnlinePlayers() {
        return this.server.getPlayerList() == null ? Collections.emptyList() : this.server.getPlayerList().getPlayers();
    }

    @Override
    @NotNull
    public PipelineInjector createPipelineInjector() {
        return new NeoForgePipelineInjector();
    }

    @Override
    @Nullable
    public TabFeature getPerWorldPlayerList(@NotNull PerWorldPlayerListConfiguration configuration) {
        return null;
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        LogUtils.getLogger().info("[TAB] {}", (Object)((Component)message.convert()).getString());
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        LogUtils.getLogger().warn("[TAB] {}", (Object)((Component)message.convert()).getString());
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[NeoForge] " + SharedConstants.getCurrentVersion().name();
    }

    @Override
    public void registerListener() {
        new NeoForgeEventListener().register();
    }

    @Override
    public void registerCommand() {
    }

    @Override
    public void startMetrics() {
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return FMLPaths.CONFIGDIR.get().resolve("tab").toFile();
    }

    @NotNull
    public Component convertComponent(@NotNull TabComponent component) {
        TabComponent tabComponent = component;
        Objects.requireNonNull(tabComponent);
        TabComponent tabComponent2 = tabComponent;
        int n = 0;
        MutableComponent nmsComponent = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TabTextComponent.class, TabTranslatableComponent.class, TabKeybindComponent.class, TabObjectComponent.class}, (Object)tabComponent2, n)) {
            case 0 -> {
                TabTextComponent text = (TabTextComponent)tabComponent2;
                yield Component.literal((String)text.getText());
            }
            case 1 -> {
                TabTranslatableComponent translatable = (TabTranslatableComponent)tabComponent2;
                yield Component.translatable((String)translatable.getKey());
            }
            case 2 -> {
                TabKeybindComponent keybind = (TabKeybindComponent)tabComponent2;
                yield Component.keybind((String)keybind.getKeybind());
            }
            case 3 -> {
                TabObjectComponent object = (TabObjectComponent)tabComponent2;
                ObjectInfo v2 = object.getContents();
                Objects.requireNonNull(v2);
                ObjectInfo var11_9 = v2;
                int var12_10 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TabAtlasSprite.class, TabPlayerSprite.class}, (Object)var11_9, var12_10)) {
                    case 0: {
                        TabAtlasSprite sprite = (TabAtlasSprite)var11_9;
                        yield Component.object((net.minecraft.network.chat.contents.objects.ObjectInfo)new AtlasSprite(ResourceLocation.parse((String)sprite.getAtlas()), ResourceLocation.parse((String)sprite.getSprite())));
                    }
                    case 1: {
                        TabPlayerSprite sprite = (TabPlayerSprite)var11_9;
                        yield Component.object((net.minecraft.network.chat.contents.objects.ObjectInfo)new PlayerSprite(this.spriteToProfile(sprite), sprite.isShowHat()));
                    }
                }
                throw new IllegalStateException("Unexpected object component type: " + object.getContents().getClass().getName());
            }
            default -> throw new IllegalStateException("Unexpected component type: " + component.getClass().getName());
        };
        TabStyle modifier = component.getModifier();
        Style style = Style.EMPTY.withColor(modifier.getColor() == null ? null : TextColor.fromRgb((int)modifier.getColor().getRgb())).withBold(modifier.getBold()).withItalic(modifier.getItalic()).withUnderlined(modifier.getUnderlined()).withStrikethrough(modifier.getStrikethrough()).withObfuscated(modifier.getObfuscated()).withFont((FontDescription)(modifier.getFont() == null ? null : new FontDescription.Resource(ResourceLocation.parse((String)modifier.getFont()))));
        if (modifier.getShadowColor() != null) {
            style = style.withShadowColor(modifier.getShadowColor().intValue());
        }
        nmsComponent.setStyle(style);
        for (TabComponent extra : component.getExtra()) {
            nmsComponent.getSiblings().add(this.convertComponent(extra));
        }
        return nmsComponent;
    }

    @NotNull
    private ResolvableProfile spriteToProfile(@NonNull TabPlayerSprite sprite) {
        if (sprite == null) {
            throw new NullPointerException("sprite is marked non-null but is null");
        }
        if (sprite.getId() != null) {
            return ResolvableProfile.createUnresolved((UUID)sprite.getId());
        }
        if (sprite.getName() != null) {
            return ResolvableProfile.createUnresolved((String)sprite.getName());
        }
        if (sprite.getSkin() != null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)"textures", (Object)new Property("textures", sprite.getSkin().getValue(), sprite.getSkin().getSignature()));
            return ResolvableProfile.createResolved((GameProfile)new GameProfile(NIL_UUID, "", new PropertyMap((Multimap)builder.build())));
        }
        throw new IllegalStateException("Player head component does not have id, name or skin set");
    }

    @Override
    @NotNull
    public Scoreboard createScoreboard(@NotNull TabPlayer player) {
        return new NeoForgeScoreboard((NeoForgeTabPlayer)player);
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NotNull TabPlayer player) {
        return new NeoForgeBossBar((NeoForgeTabPlayer)player);
    }

    @Override
    @NotNull
    public TabList createTabList(@NotNull TabPlayer player) {
        return new NeoForgeTabList((NeoForgeTabPlayer)player);
    }

    @Override
    public boolean supportsScoreboards() {
        return true;
    }

    @Override
    public double getTPS() {
        double mspt = this.getMSPT();
        if (mspt < 50.0) {
            return 20.0;
        }
        return Math.round(1000.0 / mspt);
    }

    @Override
    public double getMSPT() {
        return (float)this.server.getAverageTickTimeNanos() / 1000000.0f;
    }
}

