/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge;

import com.google.inject.Inject;
import java.nio.file.Path;
import lombok.Generated;
import me.neznamy.tab.libs.org.bstats.sponge.Metrics;
import me.neznamy.tab.platforms.sponge.SpongePlatform;
import me.neznamy.tab.platforms.sponge.SpongeTabCommand;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.event.lifecycle.StartingEngineEvent;
import org.spongepowered.api.event.lifecycle.StoppingEngineEvent;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;

@Plugin(value="tab")
public class SpongeTAB {
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDir;
    @Inject
    private PluginContainer container;
    @Inject
    private Metrics.Factory metricsFactory;
    @Inject
    private Logger logger;

    @Listener
    public void onServerStart(@Nullable StartingEngineEvent<Server> event) {
        ProtocolVersion serverVersion = ProtocolVersion.fromNetworkId(Sponge.platform().minecraftVersion().protocolVersion());
        if (serverVersion.getNetworkId() < ProtocolVersion.V1_20_6.getNetworkId()) {
            this.logger.warn("====================================================================================================");
            this.logger.warn("This plugin version was made for Minecraft version 1.20.6 and above.");
            this.logger.warn("====================================================================================================");
            return;
        }
        TAB.create(new SpongePlatform(this));
    }

    @Listener
    public void onRegisterCommands(@NotNull RegisterCommandEvent<Command.Raw> event) {
        event.register(this.container, (Object)new SpongeTabCommand(), "tab", new String[0]);
    }

    @Listener
    public void onServerStop(@Nullable StoppingEngineEvent<Server> event) {
        if (TAB.getInstance() != null) {
            TAB.getInstance().unload();
        }
    }

    @Generated
    public Path getConfigDir() {
        return this.configDir;
    }

    @Generated
    public PluginContainer getContainer() {
        return this.container;
    }

    @Generated
    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }
}

