/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.mysql;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.rowset.CachedRowSet;
import lombok.NonNull;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.PropertyConfiguration;
import me.neznamy.tab.shared.config.mysql.MySQL;
import me.neznamy.tab.shared.data.Server;
import me.neznamy.tab.shared.data.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MySQLGroupConfiguration
implements PropertyConfiguration {
    private final MySQL mysql;
    private final Map<String, Map<String, Object>> values = new HashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Map<String, Object>>> perWorld = new HashMap<String, Map<String, Map<String, Object>>>();
    private final Map<String, Map<String, Map<String, Object>>> perServer = new HashMap<String, Map<String, Map<String, Object>>>();

    public MySQLGroupConfiguration(@NonNull MySQL mysql) throws SQLException {
        if (mysql == null) {
            throw new NullPointerException("mysql is marked non-null but is null");
        }
        this.mysql = mysql;
        mysql.execute("create table if not exists tab_groups (`group` varchar(64), `property` varchar(16), `value` varchar(1024), world varchar(64), server varchar(64))", new Object[0]);
        CachedRowSet crs = mysql.getCRS("select * from tab_groups", new Object[0]);
        if (crs.size() == 0) {
            TAB.getInstance().getConfigHelper().startup().startupWarn("[MySQL] Using MySQL to store groups and users, however, the database is empty. You can get started by uploading existing data in files using \"/" + TAB.getInstance().getPlatform().getCommand() + " mysql upload\". Further modifications can be done using property commands (/" + TAB.getInstance().getPlatform().getCommand() + " <group / player> <name> <property> <value...>).");
            return;
        }
        while (crs.next()) {
            String group = crs.getString("group");
            if (!group.equals("_DEFAULT_")) {
                group = group.toLowerCase(Locale.US);
            }
            String property = crs.getString("property");
            String value = crs.getString("value");
            String world = crs.getString("world");
            String server = crs.getString("server");
            this.setProperty0(group, property, Server.byName(server), World.byName(world), value);
            this.checkProperty("MySQL", "group", group, property, server, world, true);
        }
    }

    @Override
    public void setProperty(@NonNull String group, @NonNull String property, @Nullable Server server, @Nullable World world, @Nullable String value) {
        String lowercaseGroup;
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        String string = lowercaseGroup = group.equals("_DEFAULT_") ? group : group.toLowerCase(Locale.US);
        if (this.getProperty(lowercaseGroup, property, server, world) != null) {
            this.mysql.execute("delete from `tab_groups` where `group` = ? and `property` = ? and world " + this.querySymbol(world == null) + " ? and server " + this.querySymbol(server == null) + " ?", lowercaseGroup, property, world == null ? null : world.getName(), server == null ? null : server.getName());
        }
        this.setProperty0(lowercaseGroup, property, server, world, value);
        if (value != null) {
            this.mysql.execute("insert into `tab_groups` (`group`, `property`, `value`, `world`, `server`) values (?, ?, ?, ?, ?)", lowercaseGroup, property, value, world == null ? null : world.getName(), server == null ? null : server.getName());
        }
    }

    private String querySymbol(boolean isNull) {
        return isNull ? "is" : "=";
    }

    private void setProperty0(@NonNull String group, @NonNull String property, @Nullable Server server, @Nullable World world, @Nullable String value) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (world != null) {
            this.perWorld.computeIfAbsent(world.getName(), w -> new HashMap()).computeIfAbsent(group, g -> new HashMap()).put(property, value);
        } else if (server != null) {
            this.perServer.computeIfAbsent(server.getName(), s -> new HashMap()).computeIfAbsent(group, g -> new HashMap()).put(property, value);
        } else {
            this.values.computeIfAbsent(group, g -> new HashMap()).put(property, value);
        }
    }

    @Override
    public String[] getProperty(@NonNull String group, @NonNull String property, @Nullable Server server, @Nullable World world) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        String lowercaseGroup = group.equals("_DEFAULT_") ? group : group.toLowerCase(Locale.US);
        String worldName = world == null ? null : world.getName();
        String serverName = server == null ? null : server.getName();
        Object value = ((Map)((Map)this.perWorld.getOrDefault(worldName, new HashMap())).getOrDefault(lowercaseGroup, new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s,world=%s", lowercaseGroup, worldName)};
        }
        value = ((Map)((Map)this.perWorld.getOrDefault(worldName, new HashMap())).getOrDefault("_DEFAULT_", new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s,world=%s", "_DEFAULT_", worldName)};
        }
        value = ((Map)((Map)this.perServer.getOrDefault(serverName, new HashMap())).getOrDefault(lowercaseGroup, new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s,server=%s", lowercaseGroup, serverName)};
        }
        value = ((Map)((Map)this.perServer.getOrDefault(serverName, new HashMap())).getOrDefault("_DEFAULT_", new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s,server=%s", "_DEFAULT_", serverName)};
        }
        value = ((Map)this.values.getOrDefault(lowercaseGroup, new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s", lowercaseGroup)};
        }
        value = ((Map)this.values.getOrDefault("_DEFAULT_", new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s", "_DEFAULT_")};
        }
        return new String[0];
    }

    @Override
    public void remove(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        ((Map)this.values.getOrDefault(group, new HashMap())).keySet().forEach(property -> this.setProperty(group, (String)property, null, null, null));
        this.perWorld.forEach((world, stringMapMap) -> ((Map)stringMapMap.getOrDefault(group, new HashMap())).keySet().forEach(property -> this.setProperty(group, (String)property, null, World.byName(world), null)));
        this.perServer.forEach((server, stringMapMap) -> ((Map)stringMapMap.getOrDefault(group, new HashMap())).keySet().forEach(property -> this.setProperty(group, (String)property, Server.byName(server), null, null)));
    }

    @Override
    @NotNull
    public Map<String, Object> getGlobalSettings(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.values.getOrDefault(name, Collections.emptyMap());
    }

    @Override
    @NotNull
    public Map<String, Map<String, Object>> getPerWorldSettings(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.convertMap(this.perWorld, name);
    }

    @Override
    @NotNull
    public Map<String, Map<String, Object>> getPerServerSettings(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.convertMap(this.perServer, name);
    }

    @Override
    @NotNull
    public Set<String> getAllEntries() {
        HashSet<String> set = new HashSet<String>(this.values.keySet());
        this.perWorld.values().forEach(map -> set.addAll(map.keySet()));
        this.perServer.values().forEach(map -> set.addAll(map.keySet()));
        return set;
    }
}

