/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.proxy;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import lombok.Generated;
import me.neznamy.tab.api.event.EventHandler;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.data.Server;
import me.neznamy.tab.shared.event.impl.TabPlaceholderRegisterEvent;
import me.neznamy.tab.shared.features.proxy.ProxyPlayer;
import me.neznamy.tab.shared.features.proxy.QueuedData;
import me.neznamy.tab.shared.features.proxy.message.Load;
import me.neznamy.tab.shared.features.proxy.message.LoadRequest;
import me.neznamy.tab.shared.features.proxy.message.PlayerJoin;
import me.neznamy.tab.shared.features.proxy.message.PlayerQuit;
import me.neznamy.tab.shared.features.proxy.message.ProxyMessage;
import me.neznamy.tab.shared.features.proxy.message.ServerSwitch;
import me.neznamy.tab.shared.features.proxy.message.UpdateVanishStatus;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.features.types.VanishListener;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.PerformanceUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ProxySupport
extends TabFeature
implements JoinListener,
QuitListener,
Loadable,
UnLoadable,
ServerSwitchListener,
VanishListener {
    @NotNull
    protected final Map<UUID, ProxyPlayer> proxyPlayers = new ConcurrentHashMap<UUID, ProxyPlayer>();
    @NotNull
    private final Map<UUID, QueuedData> queuedData = new ConcurrentHashMap<UUID, QueuedData>();
    @NotNull
    private final UUID proxy = UUID.randomUUID();
    private EventHandler<TabPlaceholderRegisterEvent> eventHandler;
    @NotNull
    private final Map<String, Function<ByteArrayDataInput, ProxyMessage>> stringToClass = new HashMap<String, Function<ByteArrayDataInput, ProxyMessage>>();
    @NotNull
    private final Map<Class<? extends ProxyMessage>, String> classToString = new HashMap<Class<? extends ProxyMessage>, String>();
    private final AtomicLong idCounter = new AtomicLong(0L);

    protected ProxySupport() {
        this.registerMessage(Load.class, Load::new);
        this.registerMessage(LoadRequest.class, in -> new LoadRequest());
        this.registerMessage(PlayerJoin.class, PlayerJoin::new);
        this.registerMessage(PlayerQuit.class, PlayerQuit::new);
        this.registerMessage(ServerSwitch.class, ServerSwitch::new);
        this.registerMessage(UpdateVanishStatus.class, UpdateVanishStatus::new);
        TAB.getInstance().debug("[Proxy Support] Using channel name: TAB-2");
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "ProxySupport";
    }

    public synchronized void processMessage(@NotNull String msg) {
        ProxyMessage proxyMessage;
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])Base64.getDecoder().decode(msg));
        String proxy = in.readUTF();
        if (proxy.equals(this.proxy.toString())) {
            return;
        }
        String action = in.readUTF();
        Function<ByteArrayDataInput, ProxyMessage> function = this.stringToClass.get(action);
        if (function == null) {
            TAB.getInstance().getErrorManager().unknownProxyMessage(action);
            return;
        }
        try {
            proxyMessage = function.apply(in);
            TAB.getInstance().debug("[Proxy Support] Decoded message " + proxyMessage);
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("Failed to decode proxy message \"" + new String(Base64.getDecoder().decode(msg)) + "\" ", e);
            return;
        }
        TAB.getInstance().getCpu().runMeasuredTask(this.getFeatureName(), "Proxy Message processing", () -> {
            if (proxyMessage.getCustomThread() != null) {
                proxyMessage.getCustomThread().execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> proxyMessage.process(this), this.getFeatureName(), "Proxy Message processing"));
            } else {
                proxyMessage.process(this);
            }
        });
    }

    public abstract void sendMessage(@NotNull String var1);

    public abstract void register();

    public abstract void unregister();

    @Override
    public void load() {
        this.register();
        this.overridePlaceholders();
        TAB.getInstance().getEventBus().register(TabPlaceholderRegisterEvent.class, this.eventHandler);
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
        this.sendMessage(new LoadRequest());
    }

    private void overridePlaceholders() {
        this.eventHandler = event -> {
            String identifier = event.getIdentifier();
            if (identifier.startsWith("%online_")) {
                String serverName = identifier.substring(8, identifier.length() - 1);
                Server server = Server.byName(serverName);
                event.setServerPlaceholder(() -> {
                    int count = 0;
                    for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                        if (player.server != server || player.isVanished()) continue;
                        ++count;
                    }
                    for (ProxyPlayer player : this.proxyPlayers.values()) {
                        if (player.server != server || player.isVanished()) continue;
                        ++count;
                    }
                    return PerformanceUtil.toString(count);
                });
            }
        };
        TAB.getInstance().getPlaceholderManager().registerInternalServerPlaceholder("%online%", 1000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (player.isVanished()) continue;
                ++count;
            }
            for (ProxyPlayer player : this.proxyPlayers.values()) {
                if (player.isVanished()) continue;
                ++count;
            }
            return PerformanceUtil.toString(count);
        });
        TAB.getInstance().getPlaceholderManager().registerInternalServerPlaceholder("%staffonline%", 1000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (player.isVanished() || !player.hasPermission("tab.staff")) continue;
                ++count;
            }
            for (ProxyPlayer player : this.proxyPlayers.values()) {
                if (player.isVanished() || !player.isStaff()) continue;
                ++count;
            }
            return PerformanceUtil.toString(count);
        });
        TAB.getInstance().getPlaceholderManager().registerInternalPlayerPlaceholder("%serveronline%", 1000, p -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (((TabPlayer)p).server != player.server || player.isVanished()) continue;
                ++count;
            }
            for (ProxyPlayer player : this.proxyPlayers.values()) {
                if (((TabPlayer)p).server != player.server || player.isVanished()) continue;
                ++count;
            }
            return PerformanceUtil.toString(count);
        });
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onQuit(p);
        }
        TAB.getInstance().getEventBus().unregister(this.eventHandler);
        this.unregister();
    }

    @Override
    public void onJoin(@NotNull TabPlayer p) {
        this.sendMessage(new PlayerJoin(p));
    }

    @Override
    public void onServerChange(@NotNull TabPlayer p, @NotNull Server from, @NotNull Server to) {
        this.sendMessage(new ServerSwitch(p.getUniqueId(), to));
    }

    @Override
    public void onQuit(@NotNull TabPlayer p) {
        this.sendMessage(new PlayerQuit(p.getUniqueId()));
    }

    public void sendMessage(@NotNull ProxyMessage message) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(this.proxy.toString());
        out.writeUTF(this.classToString.get(message.getClass()));
        TAB.getInstance().debug("[Proxy Support] Encoding message " + message);
        message.write(out);
        this.sendMessage(Base64.getEncoder().encodeToString(out.toByteArray()));
    }

    public void registerMessage(@NotNull Class<? extends ProxyMessage> clazz, @NotNull Function<ByteArrayDataInput, ProxyMessage> function) {
        this.stringToClass.put(clazz.getSimpleName(), function);
        this.classToString.put(clazz, clazz.getSimpleName());
    }

    @Override
    public void onVanishStatusChange(@NotNull TabPlayer player) {
        this.sendMessage(new UpdateVanishStatus(player.getUniqueId(), player.isVanished()));
    }

    @NotNull
    @Generated
    public Map<UUID, ProxyPlayer> getProxyPlayers() {
        return this.proxyPlayers;
    }

    @NotNull
    @Generated
    public Map<UUID, QueuedData> getQueuedData() {
        return this.queuedData;
    }

    @NotNull
    @Generated
    public UUID getProxy() {
        return this.proxy;
    }

    @Generated
    public EventHandler<TabPlaceholderRegisterEvent> getEventHandler() {
        return this.eventHandler;
    }

    @NotNull
    @Generated
    public Map<String, Function<ByteArrayDataInput, ProxyMessage>> getStringToClass() {
        return this.stringToClass;
    }

    @NotNull
    @Generated
    public Map<Class<? extends ProxyMessage>, String> getClassToString() {
        return this.classToString;
    }

    @Generated
    public AtomicLong getIdCounter() {
        return this.idCounter;
    }
}

