/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import org.jetbrains.annotations.NotNull;

public class PlaceholderReplacementPattern {
    public static final PlaceholderReplacementPattern EMPTY = new PlaceholderReplacementPattern("", Collections.emptyMap());
    private final Map<String, String> replacements = new HashMap<String, String>();
    private final Map<float[], String> numberIntervals = new HashMap<float[], String>();
    private final Set<String> nestedPlaceholders = new HashSet<String>();
    private final boolean empty;

    private PlaceholderReplacementPattern(@NotNull String identifier, @NotNull Map<Object, Object> map) {
        this.empty = map.isEmpty();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue()).replace(identifier, "%value%");
            this.replacements.put(EnumChatFormat.color(key), EnumChatFormat.color(value));
            this.replacements.put(key, value);
            this.nestedPlaceholders.addAll(PlaceholderManagerImpl.detectPlaceholders(value));
            this.nestedPlaceholders.remove("%value%");
            if ("true".equals(key)) {
                this.replacements.put("yes", value);
                this.replacements.put("Yes", value);
                continue;
            }
            if ("false".equals(key)) {
                this.replacements.put("no", value);
                this.replacements.put("No", value);
                continue;
            }
            if (!key.contains("-")) continue;
            try {
                this.numberIntervals.put(new float[]{Float.parseFloat(key.split("-")[0]), Float.parseFloat(key.split("-")[1])}, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.numberIntervals.put(new float[]{Float.parseFloat(key.split("~")[0]), Float.parseFloat(key.split("~")[1])}, value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @NotNull
    public String findReplacement(@NotNull String output) {
        if (this.empty) {
            return output;
        }
        String replacement = this.findReplacement0(output);
        if (replacement.contains("%value%")) {
            replacement = replacement.replace("%value%", output);
        }
        return replacement;
    }

    @NotNull
    private String findReplacement0(@NotNull String output) {
        if (this.replacements.containsKey(output)) {
            return this.replacements.get(output);
        }
        if (!this.numberIntervals.isEmpty()) {
            try {
                String cleanValue = output.contains(",") ? output.replace(",", "") : output;
                float value = Float.parseFloat(cleanValue);
                for (Map.Entry<float[], String> entry : this.numberIntervals.entrySet()) {
                    if (!(entry.getKey()[0] <= value) || !(value <= entry.getKey()[1])) continue;
                    return entry.getValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.replacements.containsKey("else")) {
            return this.replacements.get("else");
        }
        return output;
    }

    public static PlaceholderReplacementPattern create(@NotNull String identifier, @NotNull Map<Object, Object> map) {
        if (map.isEmpty()) {
            return EMPTY;
        }
        return new PlaceholderReplacementPattern(identifier, map);
    }

    @Generated
    public Set<String> getNestedPlaceholders() {
        return this.nestedPlaceholders;
    }
}

