#version 120

uniform float viewHeight;
uniform float viewWidth;
uniform mat4 gbufferModelView;
uniform mat4 gbufferProjectionInverse;
uniform vec3 fogColor;

varying vec4 starData; // rgb = star color, a = flag for stars

float fogify(float x, float w) {
    return w / (x * x + w);
}

// Solid blue color for sky
vec3 getSky(vec2 uv) {
    return vec3(0.1, 0.4, 0.8); // solid blue
}

vec3 calcSkyColor(vec3 pos) {
    vec2 screenPos = gl_FragCoord.xy / vec2(viewWidth, viewHeight);
    vec3 color = getSky(screenPos);
    float upDot = dot(pos, gbufferModelView[1].xyz);
    return mix(color, fogColor, fogify(max(upDot, 0.0), 0.25));
}

void main() {
    vec3 color;
    if (starData.a > 0.5) {
        color = starData.rgb; // stars remain unchanged
    } else {
        vec4 pos = vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight) * 2.0 - 1.0, 1.0, 1.0);
        pos = gbufferProjectionInverse * pos;
        color = calcSkyColor(normalize(pos.xyz));
    }

    gl_FragData[0] = vec4(color, 1.0);
}
