/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.foodtxf.event;

import com.jahirtrap.foodtxf.init.ModContent;
import com.jahirtrap.foodtxf.item.FluidContainerItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FillFluidEvent {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean execute(Level level, Player player, ItemStack stack, LivingEntity target, BlockHitResult hitResult, InteractionHand hand, int type) {
        if (!(stack.getItem() instanceof FluidContainerItem)) {
            return false;
        }
        ItemStack mainHandIst = player.getMainHandItem();
        ItemStack offHandIst = player.getOffhandItem();
        HashMap<ItemStack, Integer> addition = new HashMap<ItemStack, Integer>();
        ItemStack result = ItemStack.EMPTY;
        SoundEvent sound = null;
        if (target != null && !target.isBaby()) {
            if (!(target instanceof Cow) && !(target instanceof Goat)) return false;
            if (mainHandIst.is(Items.COCOA_BEANS) || offHandIst.is(Items.COCOA_BEANS)) {
                if (type == 0) {
                    result = new ItemStack((ItemLike)ModContent.CHOCOMILK_THERMOS.get());
                } else if (type == 1) {
                    result = new ItemStack((ItemLike)ModContent.GLASS_OF_CHOCOMILK.get());
                }
                addition.put(mainHandIst.is(Items.COCOA_BEANS) ? mainHandIst : offHandIst, type == 0 ? 2 : (type == 1 ? 1 : 0));
            } else if (type == 0) {
                result = new ItemStack((ItemLike)ModContent.MILK_THERMOS.get());
            } else if (type == 1) {
                result = new ItemStack((ItemLike)ModContent.GLASS_OF_MILK.get());
            }
            if (target instanceof Cow) {
                sound = SoundEvents.COW_MILK;
                return FillFluidEvent.fillItem(player, result, stack, hand, addition, sound);
            } else {
                if (!(target instanceof Goat)) return FillFluidEvent.fillItem(player, result, stack, hand, addition, sound);
                sound = SoundEvents.GOAT_MILK;
            }
            return FillFluidEvent.fillItem(player, result, stack, hand, addition, sound);
        } else {
            if (hitResult == null || hitResult.getType() != HitResult.Type.BLOCK) return false;
            Block block = level.getBlockState(hitResult.getBlockPos()).getBlock();
            if (block == Blocks.WATER) {
                if (type == 0) {
                    result = new ItemStack((ItemLike)ModContent.WATER_THERMOS.get());
                } else if (type == 1) {
                    result = new ItemStack((ItemLike)ModContent.GLASS_OF_WATER.get());
                }
                sound = SoundEvents.BUCKET_FILL;
                return FillFluidEvent.fillItem(player, result, stack, hand, addition, sound);
            } else {
                if (block != Blocks.LAVA) return false;
                if (type == 0) {
                    result = new ItemStack((ItemLike)ModContent.LAVA_THERMOS.get());
                } else if (type == 1) {
                    result = new ItemStack((ItemLike)ModContent.GLASS_OF_LAVA.get());
                }
                sound = SoundEvents.BUCKET_FILL_LAVA;
            }
        }
        return FillFluidEvent.fillItem(player, result, stack, hand, addition, sound);
    }

    private static boolean fillItem(Player player, ItemStack result, ItemStack stack, InteractionHand hand, Map<ItemStack, Integer> addition, SoundEvent sound) {
        if (!player.hasInfiniteMaterials()) {
            if (!addition.isEmpty()) {
                ItemStack key = addition.keySet().iterator().next();
                if (key.getCount() < addition.get(key)) {
                    return false;
                }
                key.consume(addition.get(key).intValue(), (LivingEntity)player);
            }
            if (stack.getCount() == 1) {
                player.setItemInHand(hand, result);
            } else {
                stack.consume(1, (LivingEntity)player);
                if (!player.getInventory().add(result)) {
                    player.drop(result, false);
                }
            }
        } else if (!player.getInventory().add(result)) {
            player.drop(result, false);
        }
        player.playSound(sound);
        return true;
    }
}

