/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.foodtxf.event;

import com.jahirtrap.foodtxf.init.ModDamageSources;
import com.jahirtrap.foodtxf.item.BaseKnifeItem;
import com.jahirtrap.foodtxf.util.CommonUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class PlayerDropsFleshKnifeEvent {
    public static boolean execute(Level level, Player player, InteractionHand hand) {
        if (!player.isSecondaryUseActive()) {
            return false;
        }
        ItemStack mainHandIst = player.getMainHandItem();
        ItemStack offHandIst = player.getOffhandItem();
        ItemStack stack = ItemStack.EMPTY;
        if (PlayerDropsFleshKnifeEvent.isKnife(mainHandIst)) {
            stack = mainHandIst;
        } else if (PlayerDropsFleshKnifeEvent.isKnife(offHandIst)) {
            stack = offHandIst;
        }
        Holder.Reference faHolder = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FIRE_ASPECT);
        int faLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)faHolder, (ItemStack)stack);
        if (faLevel != 0) {
            player.setRemainingFireTicks(80 * faLevel);
        }
        if (player.hurtOrSimulate(new DamageSource((Holder)level.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(ModDamageSources.SUICIDE)), 6.0f)) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.addFreshEntity((Entity)CommonUtils.dropFlesh(player, level, 1));
            return true;
        }
        if (CommonUtils.checkCreativeMode(player)) {
            level.playSound(null, player.blockPosition(), SoundEvents.PLAYER_HURT, SoundSource.PLAYERS);
            level.addFreshEntity((Entity)CommonUtils.dropFlesh(player, level, 1));
            return true;
        }
        return false;
    }

    private static boolean isKnife(ItemStack stack) {
        return stack.getItem() instanceof BaseKnifeItem;
    }
}

