/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.foodtxf.init;

import com.jahirtrap.foodtxf.block.BaseKitchenBlock;
import com.jahirtrap.foodtxf.block.RiceCropBlock;
import com.jahirtrap.foodtxf.init.ModMaterials;
import com.jahirtrap.foodtxf.item.BaseFoodItem;
import com.jahirtrap.foodtxf.item.BaseKnifeItem;
import com.jahirtrap.foodtxf.item.BaseReusableItem;
import com.jahirtrap.foodtxf.item.BaseSkilletItem;
import com.jahirtrap.foodtxf.item.ContainerFoodItem;
import com.jahirtrap.foodtxf.item.FluidContainerItem;
import com.jahirtrap.foodtxf.item.JuicerItem;
import com.jahirtrap.foodtxf.item.RecipeBookItem;
import com.jahirtrap.foodtxf.item.RollingPinItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModContent {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"foodtxf");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"foodtxf");
    public static final List<RegistryObject<Item>> EXCLUDED_ITEMS = new ArrayList<RegistryObject<Item>>();
    public static final HashMap<RegistryObject<? extends ItemLike>, Float> COMPOSTABLE_ITEMS = new HashMap();
    public static final HashMap<RegistryObject<? extends ItemLike>, Integer> FUEL_ITEMS = new HashMap();
    public static final RegistryObject<Item> PLAYER_FLESH = ModContent.registerItem("player_flesh", p -> new BaseFoodItem(4, 0.375f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> COOKED_PLAYER_FLESH = ModContent.registerItem("cooked_player_flesh", p -> new BaseFoodItem(8, 0.8f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> CLEAN_PUFFERFISH = ModContent.registerItem("clean_pufferfish", p -> new BaseFoodItem(2, 0.1f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> COOKED_PUFFERFISH = ModContent.registerItem("cooked_pufferfish", p -> new BaseFoodItem(6, 0.85f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> COOKED_TROPICAL_FISH = ModContent.registerItem("cooked_tropical_fish", p -> new BaseFoodItem(6, 0.85f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Block> RICE_CROP = ModContent.registerBlock("rice", RiceCropBlock::new, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.WHEAT), new Item.Properties());
    public static final RegistryObject<Item> RICE_BALL = ModContent.registerItem("rice_ball", p -> new BaseFoodItem(6, 0.5f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> DOUGH_BALL = ModContent.registerItem("dough_ball", p -> new BaseFoodItem(2, 0.2f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> TOASTED_BREAD = ModContent.registerItem("toasted_bread", p -> new BaseFoodItem(8, 0.75f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> BREAD_SLICE = ModContent.registerItem("bread_slice", p -> new BaseFoodItem(4, 0.5f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> TOASTED_BREAD_SLICE = ModContent.registerItem("toasted_bread_slice", p -> new BaseFoodItem(6, 0.65f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> BAGUETTE = ModContent.registerItem("baguette", p -> new BaseFoodItem(15, 0.6f, 64, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> BAGUETTE_SWORD = ModContent.registerItem("baguette_sword", p -> new SwordItem(ModMaterials.Tool.BREAD, 3.0f, -2.4f, p), new Item.Properties().food(new FoodProperties.Builder().nutrition(15).saturationModifier(0.6f).build(), Consumables.defaultFood().consumeSeconds(3.2f).build()));
    public static final RegistryObject<Item> COOKED_CARROT = ModContent.registerItem("cooked_carrot", p -> new BaseFoodItem(5, 0.7f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> COOKED_BEETROOT = ModContent.registerItem("cooked_beetroot", p -> new BaseFoodItem(5, 0.6f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> PUMPKIN_SLICE = ModContent.registerItem("pumpkin_slice", p -> new BaseFoodItem(4, 0.35f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_PLAYER_FLESH = ModContent.registerItem("golden_player_flesh", p -> new BaseFoodItem(10, 0.8f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_BEEF = ModContent.registerItem("golden_beef", p -> new BaseFoodItem(10, 0.8f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_PORKCHOP = ModContent.registerItem("golden_porkchop", p -> new BaseFoodItem(10, 0.8f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_MUTTON = ModContent.registerItem("golden_mutton", p -> new BaseFoodItem(8, 0.875f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_CHICKEN = ModContent.registerItem("golden_chicken", p -> new BaseFoodItem(8, 0.75f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_RABBIT = ModContent.registerItem("golden_rabbit", p -> new BaseFoodItem(7, 0.7f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_FISH = ModContent.registerItem("golden_fish", p -> new BaseFoodItem(8, 0.8f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_BREAD = ModContent.registerItem("golden_bread", p -> new BaseFoodItem(10, 0.76f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_BREAD_SLICE = ModContent.registerItem("golden_bread_slice", p -> new BaseFoodItem(8, 0.625f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_POTATO = ModContent.registerItem("golden_potato", p -> new BaseFoodItem(7, 0.7f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_BEETROOT = ModContent.registerItem("golden_beetroot", p -> new BaseFoodItem(7, 0.7f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_SWEET_BERRIES = ModContent.registerItem("golden_sweet_berries", p -> new BaseFoodItem(5, 0.5f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_GLOW_BERRIES = ModContent.registerItem("golden_glow_berries", p -> new BaseFoodItem(5, 0.5f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLISTERING_PUMPKIN_SLICE = ModContent.registerItem("glistering_pumpkin_slice", p -> new BaseFoodItem(7, 0.6f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> CHEESE = ModContent.registerItem("cheese", p -> new BaseFoodItem(4, 0.75f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> CHEESE_SLICE = ModContent.registerItem("cheese_slice", p -> new BaseFoodItem(2, 0.75f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> RAW_CHEESE_EMPANADA = ModContent.registerItem("raw_cheese_empanada", p -> new BaseFoodItem(5, 0.6f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> RAW_MEAT_EMPANADA = ModContent.registerItem("raw_meat_empanada", p -> new BaseFoodItem(5, 0.6f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> CHEESE_EMPANADA = ModContent.registerItem("cheese_empanada", p -> new BaseFoodItem(9, 0.6f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> MEAT_EMPANADA = ModContent.registerItem("meat_empanada", p -> new BaseFoodItem(9, 0.6f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> CHEESE_SANDWICH = ModContent.registerItem("cheese_sandwich", p -> new BaseFoodItem(10, 0.7f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> THERMOS = ModContent.registerItem("thermos", p -> new FluidContainerItem(0, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS = ModContent.registerItem("glass", p -> new FluidContainerItem(1, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> BOX = ModContent.registerItem("box", Item::new, new Item.Properties());
    public static final RegistryObject<Item> FRUIT_SALAD = ModContent.registerItem("fruit_salad", p -> new ContainerFoodItem(1, 6, 0.65f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> VEGETABLE_SALAD = ModContent.registerItem("vegetable_salad", p -> new ContainerFoodItem(1, 6, 0.65f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> MIXED_SALAD = ModContent.registerItem("mixed_salad", p -> new ContainerFoodItem(1, 6, 0.65f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> RICE_BOWL = ModContent.registerItem("rice_bowl", p -> new ContainerFoodItem(1, 6, 0.5f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> FISH_ON_STICK = ModContent.registerItem("fish_on_stick", p -> new ContainerFoodItem(3, 4, 0.25f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> COOKED_FISH_ON_STICK = ModContent.registerItem("cooked_fish_on_stick", p -> new ContainerFoodItem(3, 10, 0.7f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> WATER_THERMOS = ModContent.registerItem("water_thermos", p -> new ContainerFoodItem(1, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> LAVA_THERMOS = ModContent.registerItem("lava_thermos", p -> new ContainerFoodItem(2, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> MILK_THERMOS = ModContent.registerItem("milk_thermos", p -> new ContainerFoodItem(3, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> CHOCOMILK_THERMOS = ModContent.registerItem("chocomilk_thermos", p -> new ContainerFoodItem(0, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_FRUIT_JUICE = ModContent.registerItem("glass_of_fruit_juice", p -> new ContainerFoodItem(2, 4, 0.75f, true, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_VEGETABLE_JUICE = ModContent.registerItem("glass_of_vegetable_juice", p -> new ContainerFoodItem(2, 4, 0.75f, true, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_MIXED_JUICE = ModContent.registerItem("glass_of_mixed_juice", p -> new ContainerFoodItem(2, 4, 0.75f, true, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_WATER = ModContent.registerItem("glass_of_water", p -> new ContainerFoodItem(2, 1, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_WATER_AND_BREAD = ModContent.registerItem("glass_of_water_and_bread", p -> new ContainerFoodItem(2, 6, 0.5f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_LAVA = ModContent.registerItem("glass_of_lava", p -> new ContainerFoodItem(2, 2, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_MILK = ModContent.registerItem("glass_of_milk", p -> new ContainerFoodItem(2, 1, 0.5f, 3, true, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_MILK_AND_COOKIES = ModContent.registerItem("glass_of_milk_and_cookies", p -> new ContainerFoodItem(2, 5, 0.2f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_MILK_AND_TOASTED_BREAD = ModContent.registerItem("glass_of_milk_and_toasted_bread", p -> new ContainerFoodItem(2, 10, 0.65f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_CHOCOMILK = ModContent.registerItem("glass_of_chocomilk", p -> new ContainerFoodItem(2, 1, 1.0f, true, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_CHOCOMILK_AND_COOKIES = ModContent.registerItem("glass_of_chocomilk_and_cookies", p -> new ContainerFoodItem(2, 5, 0.3f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GLASS_OF_CHOCOMILK_AND_TOASTED_BREAD = ModContent.registerItem("glass_of_chocomilk_and_toasted_bread", p -> new ContainerFoodItem(2, 10, 0.7f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> BOX_OF_CEREAL = ModContent.registerItem("box_of_cereal", p -> new ContainerFoodItem(0, 4, 0.5f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> BOX_OF_COOKIES = ModContent.registerItem("box_of_cookies", p -> new ContainerFoodItem(0, 12, 0.325f, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> WOODEN_KNIFE = ModContent.registerItem("wooden_knife", p -> new BaseKnifeItem(ToolMaterial.WOOD, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> STONE_KNIFE = ModContent.registerItem("stone_knife", p -> new BaseKnifeItem(ToolMaterial.STONE, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> IRON_KNIFE = ModContent.registerItem("iron_knife", p -> new BaseKnifeItem(ToolMaterial.IRON, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_KNIFE = ModContent.registerItem("golden_knife", p -> new BaseKnifeItem(ToolMaterial.GOLD, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> DIAMOND_KNIFE = ModContent.registerItem("diamond_knife", p -> new BaseKnifeItem(ToolMaterial.DIAMOND, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> NETHERITE_KNIFE = ModContent.registerItem("netherite_knife", p -> new BaseKnifeItem(ToolMaterial.NETHERITE, (Item.Properties)p), new Item.Properties().fireResistant());
    public static final RegistryObject<Item> ENDERITE_KNIFE = ModContent.registerItem("enderite_knife", p -> new BaseKnifeItem(ModMaterials.Tool.ENDERITE, (Item.Properties)p), new Item.Properties().fireResistant());
    public static final RegistryObject<Item> STEEL_KNIFE = ModContent.registerItem("steel_knife", p -> new BaseKnifeItem(ModMaterials.Tool.STEEL, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> BRONZE_KNIFE = ModContent.registerItem("bronze_knife", p -> new BaseKnifeItem(ModMaterials.Tool.BRONZE, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> ZURITE_KNIFE = ModContent.registerItem("zurite_knife", p -> new BaseKnifeItem(ModMaterials.Tool.ZURITE, (Item.Properties)p), new Item.Properties().fireResistant());
    public static final RegistryObject<Item> IRON_SKILLET = ModContent.registerItem("iron_skillet", p -> new BaseSkilletItem(ToolMaterial.IRON, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> GOLDEN_SKILLET = ModContent.registerItem("golden_skillet", p -> new BaseSkilletItem(ToolMaterial.GOLD, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> DIAMOND_SKILLET = ModContent.registerItem("diamond_skillet", p -> new BaseSkilletItem(ToolMaterial.DIAMOND, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> NETHERITE_SKILLET = ModContent.registerItem("netherite_skillet", p -> new BaseSkilletItem(ToolMaterial.NETHERITE, (Item.Properties)p), new Item.Properties().fireResistant());
    public static final RegistryObject<Item> ENDERITE_SKILLET = ModContent.registerItem("enderite_skillet", p -> new BaseSkilletItem(ModMaterials.Tool.ENDERITE, (Item.Properties)p), new Item.Properties().fireResistant());
    public static final RegistryObject<Item> STEEL_SKILLET = ModContent.registerItem("steel_skillet", p -> new BaseSkilletItem(ModMaterials.Tool.STEEL, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> BRONZE_SKILLET = ModContent.registerItem("bronze_skillet", p -> new BaseSkilletItem(ModMaterials.Tool.BRONZE, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> ZURITE_SKILLET = ModContent.registerItem("zurite_skillet", p -> new BaseSkilletItem(ModMaterials.Tool.ZURITE, (Item.Properties)p), new Item.Properties().fireResistant());
    public static final RegistryObject<Item> CUTTING_BOARD = ModContent.registerItem("cutting_board", BaseReusableItem::new, new Item.Properties());
    public static final RegistryObject<Item> MIXING_BOWL = ModContent.registerItem("mixing_bowl", BaseReusableItem::new, new Item.Properties());
    public static final RegistryObject<Item> ROLLING_PIN = ModContent.registerItem("rolling_pin", RollingPinItem::new, new Item.Properties());
    public static final RegistryObject<Item> JUICER = ModContent.registerItem("juicer", JuicerItem::new, new Item.Properties());
    public static final RegistryObject<Item> BLENDER = ModContent.registerItem("blender", BaseReusableItem::new, new Item.Properties());
    public static final RegistryObject<Block> BLACK_KITCHEN_BLOCK = ModContent.registerBlock("black_kitchen_block", BaseKitchenBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(0.8f, 3.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static final RegistryObject<Block> WHITE_KITCHEN_BLOCK = ModContent.registerBlock("white_kitchen_block", BaseKitchenBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).strength(0.8f, 3.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static final RegistryObject<Item> RECIPE_BOOK = ModContent.registerItem("recipe_book", RecipeBookItem::new, new Item.Properties());

    private static RegistryObject<Block> registerBlock(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockProp, Item.Properties itemProp) {
        RegistryObject<Block> blockReg = ModContent.registerBlock(name, function, blockProp);
        ModContent.registerItem(name, p -> new BlockItem((Block)blockReg.get(), p), itemProp.useBlockDescriptionPrefix());
        return blockReg;
    }

    private static RegistryObject<Block> registerBlock(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockProp) {
        return BLOCKS.register(name, () -> (Block)function.apply(blockProp.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"foodtxf", (String)name)))));
    }

    private static RegistryObject<Item> registerItem(String name, Function<Item.Properties, Item> function, Item.Properties itemProp) {
        return ITEMS.register(name, () -> (Item)function.apply(itemProp.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"foodtxf", (String)name)))));
    }

    public static void init(IEventBus bus) {
        EXCLUDED_ITEMS.add(BAGUETTE_SWORD);
        BLOCKS.register(bus);
        ITEMS.register(bus);
        COMPOSTABLE_ITEMS.put(RICE_CROP, Float.valueOf(0.3f));
        COMPOSTABLE_ITEMS.put(RICE_BALL, Float.valueOf(0.85f));
        COMPOSTABLE_ITEMS.put(DOUGH_BALL, Float.valueOf(0.65f));
        COMPOSTABLE_ITEMS.put(TOASTED_BREAD, Float.valueOf(1.0f));
        COMPOSTABLE_ITEMS.put(BREAD_SLICE, Float.valueOf(0.4f));
        COMPOSTABLE_ITEMS.put(TOASTED_BREAD_SLICE, Float.valueOf(0.75f));
        COMPOSTABLE_ITEMS.put(BAGUETTE, Float.valueOf(1.0f));
        COMPOSTABLE_ITEMS.put(BAGUETTE_SWORD, Float.valueOf(1.0f));
        COMPOSTABLE_ITEMS.put(COOKED_CARROT, Float.valueOf(0.85f));
        COMPOSTABLE_ITEMS.put(COOKED_BEETROOT, Float.valueOf(0.85f));
        COMPOSTABLE_ITEMS.put(PUMPKIN_SLICE, Float.valueOf(0.5f));
        COMPOSTABLE_ITEMS.put(CHEESE, Float.valueOf(0.65f));
        COMPOSTABLE_ITEMS.put(CHEESE_SLICE, Float.valueOf(0.3f));
        FUEL_ITEMS.put(BOX, 200);
        FUEL_ITEMS.put(WOODEN_KNIFE, 200);
        FUEL_ITEMS.put(CUTTING_BOARD, 200);
        FUEL_ITEMS.put(ROLLING_PIN, 300);
        bus.addListener(event -> COMPOSTABLE_ITEMS.forEach((item, chance) -> ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)item.get()).asItem(), chance)));
        MinecraftForge.EVENT_BUS.addListener(event -> FUEL_ITEMS.forEach((item, burnTime) -> {
            if (item.get() == event.getItemStack().getItem()) {
                event.setBurnTime(burnTime.intValue());
            }
        }));
    }
}

