/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.foodtxf.util;

import com.jahirtrap.foodtxf.init.ModContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CommonUtils {
    public static final List<Item> container = new ArrayList<Item>(Arrays.asList((Item)ModContent.BOX.get(), Items.BOWL, (Item)ModContent.GLASS.get(), Items.STICK, (Item)ModContent.THERMOS.get()));

    public static ItemEntity dropFlesh(Player player, Level level, int num) {
        ItemStack stack = player.isOnFire() ? new ItemStack((ItemLike)ModContent.COOKED_PLAYER_FLESH.get(), num) : new ItemStack((ItemLike)ModContent.PLAYER_FLESH.get(), num);
        stack.set(DataComponents.LORE, (Object)new ItemLore(Collections.singletonList(Component.literal((String)player.getName().getString()).withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withItalic(Boolean.valueOf(false))))));
        ItemEntity itemEntity = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), stack);
        itemEntity.setDefaultPickUpDelay();
        return itemEntity;
    }

    public static boolean checkCreativeMode(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.gameMode.getGameModeForPlayer() == GameType.CREATIVE;
        }
        if (player.level().isClientSide()) {
            return Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().id()).getGameMode() == GameType.CREATIVE;
        }
        return false;
    }

    public static Component coloredTextComponent(String i18n, ChatFormatting color) {
        MutableComponent textComponent = Component.translatable((String)i18n);
        textComponent.withStyle(color);
        return textComponent;
    }

    public static ItemStack hurt(int amount, ItemStack stack) {
        if (!(stack = stack.copy()).isDamageableItem()) {
            return stack;
        }
        stack.setDamageValue(stack.getDamageValue() + amount);
        if (stack.getDamageValue() >= stack.getMaxDamage()) {
            stack.shrink(1);
        }
        return stack;
    }
}

