/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyBiomeOverride;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.FlatWorldLayerSelector;
import wily.legacy.client.screen.LegacyFlatPresetsScreen;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.TabList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.WorldMoreOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyFlatWorldScreen
extends PanelVListScreen
implements ControlTooltip.Event {
    public final int maxOverworldHeight;
    protected List<FormattedCharSequence> tooltipBoxLabel;
    private final Consumer<FlatLevelGeneratorSettings> applySettings;
    protected final WorldCreationUiState uiState;
    FlatLevelGeneratorSettings generator;
    protected final TabList tabList;
    protected final RenderableVList displayLayers;
    protected final RenderableVList displayBiomes;
    protected final RenderableVList displayProperties;
    protected final List<Holder<StructureSet>> structuresOverrides;
    protected LayerButton movingLayer;

    public LegacyFlatWorldScreen(Screen screen, WorldCreationUiState uiState, HolderLookup.RegistryLookup<Biome> biomeGetter, HolderLookup.RegistryLookup<StructureSet> structureGetter, Consumer<FlatLevelGeneratorSettings> consumer, FlatLevelGeneratorSettings flatLevelGeneratorSettings) {
        super((Screen s) -> Panel.createPanel(s, p -> p.appearance(282, Math.min(s.height - 48, 248)), p -> p.pos((s.width - (p.width + (ScreenUtil.hasTooltipBoxes(UIAccessor.of((Screen)s)) ? 194 : 0))) / 2, p.centeredTopPos((Screen)s))), (Component)Component.translatable((String)"createWorld.customize.flat.title"));
        Screen screen2;
        this.tabList = new TabList(this.accessor).add(30, LegacyTabButton.Type.LEFT, (Component)Component.translatable((String)"legacy.menu.create_flat_world.layers"), b -> this.rebuildWidgets()).add(30, LegacyTabButton.Type.MIDDLE, (Component)Component.translatable((String)"legacy.menu.create_flat_world.biomes"), b -> this.rebuildWidgets()).add(30, LegacyTabButton.Type.RIGHT, (Component)Component.translatable((String)"legacy.menu.create_flat_world.properties"), b -> this.rebuildWidgets());
        this.displayLayers = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
        this.displayBiomes = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
        this.displayProperties = new RenderableVList(this.accessor);
        Screen screen3 = Minecraft.getInstance().screen;
        if (screen3 instanceof WorldMoreOptionsScreen) {
            WorldMoreOptionsScreen s2 = (WorldMoreOptionsScreen)screen3;
            screen2 = s2;
        } else {
            screen2 = screen;
        }
        this.parent = screen2;
        this.uiState = uiState;
        this.applySettings = consumer;
        this.generator = flatLevelGeneratorSettings;
        this.maxOverworldHeight = uiState.getSettings().worldgenLoadContext().lookupOrThrow(Registries.DIMENSION_TYPE).get(BuiltinDimensionTypes.OVERWORLD).map(l -> ((DimensionType)l.value()).height()).orElse(384);
        this.structuresOverrides = new ArrayList(((HolderSet)this.generator.structureOverrides().orElse(HolderSet.direct((Holder[])new Holder[0]))).stream().toList());
        this.generator.getLayersInfo().forEach(this::addLayer);
        biomeGetter.listElements().forEach(this::addBiome);
        structureGetter.listElements().forEach(this::addStructure);
        this.renderableVLists.clear();
        this.renderableVLists.add(this.displayLayers);
        this.renderableVLists.add(this.displayBiomes);
        this.renderableVLists.add(this.displayProperties);
        this.displayProperties.addRenderable((Renderable)new TickBox(0, 0, 260, 12, this.generator.decoration, b -> LegacyComponents.DECORATIONS, b -> null, b -> {
            this.generator.decoration = b.selected;
        }));
        this.displayProperties.addRenderable((Renderable)new TickBox(0, 0, 260, 12, this.generator.addLakes, b -> LegacyComponents.LAVA_LAKES, b -> null, b -> {
            this.generator.addLakes = b.selected;
        }));
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> this.movingLayer != null || this.tabList.selectedTab != 0 || this.getFocused() == null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon()), () -> LegacyComponents.MOVE_LAYER).add(() -> this.movingLayer != null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon()), () -> LegacyComponents.PRESETS).addCompound(() -> new ControlTooltip.Icon[]{ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon(), ControlTooltip.SPACE_ICON, ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon()}, () -> this.movingLayer != null ? null : LegacyComponents.SELECT_TAB).add(() -> this.movingLayer == null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(266) : ControllerBinding.LEFT_TRIGGER.getIcon()), () -> LegacyComponents.PAGE_UP).add(() -> this.movingLayer == null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(267) : ControllerBinding.RIGHT_TRIGGER.getIcon()), () -> LegacyComponents.PAGE_DOWN).addCompound(() -> {
            ControlTooltip.Icon[] iconArray;
            if (ControlType.getActiveType().isKbm()) {
                ControlTooltip.Icon[] iconArray2 = new ControlTooltip.Icon[3];
                iconArray2[0] = ControlTooltip.getKeyIcon(265);
                iconArray2[1] = ControlTooltip.SPACE_ICON;
                iconArray = iconArray2;
                iconArray2[2] = ControlTooltip.getKeyIcon(264);
            } else {
                ControlTooltip.Icon[] iconArray3 = new ControlTooltip.Icon[1];
                iconArray = iconArray3;
                iconArray3[0] = ControllerBinding.LEFT_STICK.getIcon();
            }
            return iconArray;
        }, () -> this.movingLayer == null ? null : LegacyComponents.MOVE_UP_DOWN);
    }

    public void addStructure(Holder.Reference<StructureSet> structure) {
        ArrayList<Component> descr = new ArrayList<Component>();
        String nameKey = "structure." + structure.key().location().toLanguageKey();
        String descriptionKey = nameKey + ".description";
        if (LegacyTipManager.hasTip(nameKey)) {
            descr.add((Component)Component.translatable((String)nameKey));
        }
        if (LegacyTipManager.hasTip(descriptionKey)) {
            descr.add(ControlTooltip.SPACE);
            descr.add((Component)Component.translatable((String)descriptionKey));
        }
        MultilineTooltip t = descr.isEmpty() ? null : new MultilineTooltip(descr, 182);
        this.displayProperties.addRenderable((Renderable)new TickBox(0, 0, 260, 12, this.structuresOverrides.contains(structure), b -> descr.isEmpty() ? Component.translatable((String)nameKey) : (Component)descr.get(0), b -> t, b -> {
            if (b.selected) {
                this.structuresOverrides.add((Holder<StructureSet>)structure);
            } else {
                this.structuresOverrides.remove(structure);
            }
        }));
    }

    public void addBiome(final Holder.Reference<Biome> biome) {
        AbstractButton b = new AbstractButton(0, 0, 260, 30, (Component)Component.translatable((String)("biome." + biome.key().location().toLanguageKey()))){

            public void onPress() {
                LegacyFlatWorldScreen.this.generator.biome = biome;
            }

            protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
                super.renderWidget(guiGraphics, i, j, f);
                ItemStack s = LegacyBiomeOverride.getOrDefault(biome.unwrapKey()).icon();
                if (!s.isEmpty()) {
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate((float)(this.getX() + 26), (float)(this.getY() + 5), 0.0f);
                    guiGraphics.pose().scale(1.25f, 1.25f, 1.25f);
                    guiGraphics.renderItem(s, 0, 0);
                    guiGraphics.pose().popPose();
                }
                FactoryScreenUtil.enableBlend();
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(TickBox.SPRITES[this.isHoveredOrFocused() ? 1 : 0], this.getX() + 6, this.getY() + (this.height - 12) / 2, 12, 12);
                if (LegacyFlatWorldScreen.this.generator.biome == biome) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(TickBox.TICK, this.getX() + 6, this.getY() + (this.height - 12) / 2, 14, 12);
                }
                FactoryScreenUtil.disableBlend();
            }

            protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
                int k = this.getX() + 54;
                int l = this.getX() + this.getWidth();
                ScreenUtil.renderScrollingString(guiGraphics, font, this.getMessage(), k, this.getY(), l, this.getY() + this.getHeight(), j, true);
            }

            protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                this.defaultButtonNarrationText(narrationElementOutput);
            }
        };
        this.displayBiomes.addRenderable((Renderable)b);
        ArrayList<Component> descr = new ArrayList<Component>();
        descr.add(b.getMessage());
        String descriptionKey = "biome." + biome.key().location().toLanguageKey() + ".description";
        if (LegacyTipManager.hasTip(descriptionKey)) {
            descr.add(ControlTooltip.SPACE);
            descr.add((Component)Component.translatable((String)descriptionKey));
        }
        b.setTooltip((Tooltip)new MultilineTooltip(descr, 182));
    }

    public void addLayer(FlatLayerInfo flatLayerInfo) {
        this.addLayer(flatLayerInfo, 0);
    }

    public void addLayer(FlatLayerInfo flatLayerInfo, int index) {
        this.displayLayers.renderables.add(index, (Renderable)new LayerButton(0, 0, 270, 30, flatLayerInfo));
    }

    public int getAllLayersHeight() {
        int height = 0;
        for (Renderable renderable : this.displayLayers.renderables) {
            if (!(renderable instanceof LayerButton)) continue;
            LayerButton layerButton = (LayerButton)renderable;
            height += layerButton.flatLayerInfo.getHeight();
        }
        return height;
    }

    public void removeLayer(int index) {
        this.displayLayers.renderables.remove(index);
    }

    public void switchLayers(AbstractButton selected, AbstractButton aimPlace) {
        int selectedIndex = this.displayLayers.renderables.indexOf(selected);
        int aimIndex = this.displayLayers.renderables.indexOf(aimPlace);
        this.displayLayers.renderables.set(aimIndex, (Renderable)selected);
        this.displayLayers.renderables.set(selectedIndex, (Renderable)aimPlace);
        this.repositionElements();
        ScreenUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
    }

    public void setTooltipForNextRenderPass(Tooltip tooltip, ClientTooltipPositioner clientTooltipPositioner, boolean bl) {
        if (ScreenUtil.hasTooltipBoxes(this.accessor)) {
            this.tooltipBoxLabel = tooltip.toCharSequence(this.minecraft);
        } else {
            super.setTooltipForNextRenderPass(tooltip, clientTooltipPositioner, bl);
        }
    }

    public FlatLevelGeneratorSettings settings() {
        return this.generator;
    }

    public void setPreset(FlatLevelGeneratorSettings flatLevelGeneratorSettings) {
        this.generator = flatLevelGeneratorSettings;
        this.displayLayers.renderables.clear();
        this.generator.getLayersInfo().forEach(this::addLayer);
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    @Override
    protected void init() {
        if (this.movingLayer != null && this.tabList.selectedTab != 0) {
            this.tabList.selectedTab = 0;
        }
        this.addRenderableOnly((guiGraphics, i, j, f) -> {
            if (ScreenUtil.hasTooltipBoxes(this.accessor)) {
                AbstractWidget w;
                GuiEventListener patt0$temp;
                if (this.tooltipBoxLabel != null && this.getChildAt(i, j).map(g -> {
                    Tooltip tooltip;
                    if (g instanceof AbstractWidget) {
                        AbstractWidget w = (AbstractWidget)g;
                        tooltip = w.getTooltip();
                    } else {
                        tooltip = null;
                    }
                    return tooltip;
                }).isEmpty() && (!((patt0$temp = this.getFocused()) instanceof AbstractWidget) || (w = (AbstractWidget)patt0$temp).getTooltip() == null)) {
                    this.tooltipBoxLabel = null;
                }
                ScreenUtil.renderPointerPanel(guiGraphics, this.panel.x + this.panel.width - 2, this.panel.y + 5, 194, this.panel.height - 10);
                if (this.tooltipBoxLabel != null) {
                    this.tooltipBoxLabel.forEach(c -> guiGraphics.drawString(this.font, c, this.panel.x + this.panel.width + 3, this.panel.y + 13 + 12 * this.tooltipBoxLabel.indexOf(c), 0xFFFFFF));
                }
            }
        });
        this.addRenderableWidget(this.tabList);
        super.init();
        this.tabList.init(this.panel.x, this.panel.y - 24, this.panel.width);
        this.generator.updateLayers();
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.addRenderableOnly((guiGraphics, i, j, f) -> FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 7, this.panel.y + 7, this.panel.width - 14, this.panel.height - 14));
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 11, this.panel.y + 11, 260, this.panel.height - 22);
    }

    @Override
    public RenderableVList getRenderableVList() {
        return this.getRenderableVLists().get(this.tabList.selectedTab);
    }

    @Override
    public boolean mouseScrolled(double d, double e, double f, double g) {
        this.getRenderableVList().mouseScrolled(g);
        return super.mouseScrolled(d, e, f, g);
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        AbstractButton b2;
        GuiEventListener guiEventListener2;
        super.setFocused(guiEventListener);
        if (this.movingLayer != null && (guiEventListener2 = this.getFocused()) instanceof AbstractButton && this.displayLayers.renderables.contains(b2 = (AbstractButton)guiEventListener2) && this.getFocused() != this.movingLayer) {
            super.setFocused((GuiEventListener)this.movingLayer);
            this.switchLayers(this.movingLayer, b2);
        }
    }

    @Override
    public boolean keyPressed(int i, int j, int k) {
        if (this.movingLayer == null) {
            if (this.tabList.controlTab(i)) {
                return true;
            }
            if (i == 79) {
                this.minecraft.setScreen((Screen)new LegacyFlatPresetsScreen((Screen)this, (HolderLookup.RegistryLookup<FlatLevelGeneratorPreset>)this.uiState.getSettings().worldgenLoadContext().lookupOrThrow(Registries.FLAT_LEVEL_GENERATOR_PRESET), this.uiState.getSettings().dataConfiguration().enabledFeatures(), f -> this.setPreset(((FlatLevelGeneratorPreset)f.value()).settings())));
            }
        }
        return super.keyPressed(i, j, k);
    }

    @Override
    public void onClose() {
        super.onClose();
        this.generator.getLayersInfo().clear();
        this.displayLayers.renderables.forEach(r -> {
            if (r instanceof LayerButton) {
                LayerButton l = (LayerButton)r;
                this.generator.getLayersInfo().add(0, l.flatLayerInfo);
            }
        });
        this.generator.updateLayers();
        this.applySettings.accept(this.generator);
        this.generator.structureOverrides = Optional.of(HolderSet.direct(this.structuresOverrides));
    }

    public class LayerButton
    extends AbstractButton
    implements ControlTooltip.ActionHolder {
        public final FlatLayerInfo flatLayerInfo;

        public LayerButton(int i, int j, int k, int l, FlatLayerInfo flatLayerInfo) {
            super(i, j, k, l, (Component)flatLayerInfo.getBlockState().getBlock().getName());
            this.flatLayerInfo = flatLayerInfo;
            ItemStack s = flatLayerInfo.getBlockState().getBlock().asItem().getDefaultInstance();
            ArrayList<Component> descr = new ArrayList<Component>();
            descr.add(this.getMessage());
            if (LegacyTipManager.hasTip(s)) {
                descr.add(ControlTooltip.SPACE);
                descr.add(LegacyTipManager.getTipComponent(s));
            }
            this.setTooltip(new MultilineTooltip(descr, 182));
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            super.renderWidget(guiGraphics, i, j, f);
            Font font = LegacyFlatWorldScreen.this.font;
            MutableComponent mutableComponent = Component.translatable((String)"legacy.menu.create_flat_world.layer_count", (Object[])new Object[]{this.flatLayerInfo.getHeight()});
            int n = this.getX() + 12;
            int n2 = this.getY() + 1;
            Objects.requireNonNull(LegacyFlatWorldScreen.this.font);
            guiGraphics.drawString(font, (Component)mutableComponent, n, n2 + (this.height - 9) / 2, 0xFFFFFF);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + 39), (float)(this.getY() + 5), 0.0f);
            guiGraphics.pose().scale(1.25f, 1.25f, 1.25f);
            guiGraphics.renderItem(this.flatLayerInfo.getBlockState().getBlock().asItem().getDefaultInstance(), 0, 0);
            guiGraphics.pose().popPose();
        }

        protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
            int k = this.getX() + 67;
            int l = this.getX() + this.getWidth();
            ScreenUtil.renderScrollingString(guiGraphics, font, this.getMessage(), k, this.getY(), l, this.getY() + this.getHeight(), j, true);
        }

        public void setFocused(boolean bl) {
            if (bl && LegacyFlatWorldScreen.this.movingLayer != null && LegacyFlatWorldScreen.this.movingLayer != this) {
                return;
            }
            super.setFocused(bl);
        }

        public boolean keyPressed(int i, int j, int k) {
            if (i == 88) {
                LegacyFlatWorldScreen.this.movingLayer = this;
                return true;
            }
            return super.keyPressed(i, j, k);
        }

        public void onPress() {
            if (LegacyFlatWorldScreen.this.movingLayer != null) {
                if (this.isFocused()) {
                    LegacyFlatWorldScreen.this.movingLayer = null;
                }
                return;
            }
            final int allHeight = LegacyFlatWorldScreen.this.getAllLayersHeight();
            Legacy4J.LOGGER.warn((Object)allHeight);
            final int layerIndex = LegacyFlatWorldScreen.this.displayLayers.renderables.indexOf(this);
            LegacyFlatWorldScreen.this.minecraft.setScreen((Screen)new ConfirmationScreen(LegacyFlatWorldScreen.this, 230, 120, LegacyComponents.LAYER_OPTIONS, LegacyComponents.LAYER_MESSAGE, b -> {}){

                @Override
                protected void addButtons() {
                    this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.create_flat_world.edit_layer"), b -> this.minecraft.setScreen((Screen)new FlatWorldLayerSelector(LegacyFlatWorldScreen.this, LayerButton.this.flatLayerInfo, f -> {
                        LegacyFlatWorldScreen.this.removeLayer(layerIndex);
                        LegacyFlatWorldScreen.this.addLayer(f.getFlatLayerInfo(), layerIndex);
                    }, LegacyFlatWorldScreen.this.maxOverworldHeight - allHeight + LayerButton.this.flatLayerInfo.getHeight(), (Component)Component.translatable((String)"legacy.menu.create_flat_world.edit_layer")))).bounds(this.panel.x + 15, this.panel.y + this.panel.height - 74, 200, 20).build());
                    Button addButton = Button.builder((Component)Component.translatable((String)"legacy.menu.create_flat_world.add_layer"), b -> this.minecraft.setScreen((Screen)new FlatWorldLayerSelector((Screen)LegacyFlatWorldScreen.this, f -> LegacyFlatWorldScreen.this.addLayer(f.getFlatLayerInfo(), layerIndex), LegacyFlatWorldScreen.this.maxOverworldHeight - allHeight, (Component)Component.translatable((String)"legacy.menu.create_flat_world.add_layer")))).bounds(this.panel.x + 15, this.panel.y + this.panel.height - 52, 200, 20).build();
                    if (allHeight >= LegacyFlatWorldScreen.this.maxOverworldHeight) {
                        addButton.active = false;
                    }
                    this.renderableVList.addRenderable((Renderable)addButton);
                    this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.create_flat_world.delete_layer"), b -> {
                        LegacyFlatWorldScreen.this.removeLayer(layerIndex);
                        this.onClose();
                    }).bounds(this.panel.x + 15, this.panel.y + this.panel.height - 30, 200, 20).build());
                }
            });
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 ? (LegacyFlatWorldScreen.this.movingLayer != null ? LegacyComponents.PLACE : LegacyComponents.LAYER_OPTIONS) : null);
        }
    }
}

