/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.network.chat.Component;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.LegacyConfigWidgets;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.util.LegacySprites;

public class LegacyLanguageScreen
extends PanelVListScreen {
    public static final Component WARNING_LABEL = Component.translatable((String)"options.languageAccuracyWarning");
    protected String selectedLang;

    public LegacyLanguageScreen(Screen parent, final LanguageManager manager) {
        super(parent, s -> Panel.centered(s, 255, 240, 0, 24), (Component)Component.translatable((String)"controls.keybinds.title"));
        final String autoCode = LegacyLanguageScreen.getSystemLanguageCode();
        this.renderableVList.addRenderable((Renderable)new AbstractButton(0, 0, 260, 20, (Component)Component.translatable((String)"legacy.menu.system_language")){

            protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
                super.renderWidget(guiGraphics, i, j, f);
                if (manager.getSelected().equals(autoCode)) {
                    this.setFocused(true);
                }
            }

            public void onPress() {
                LegacyLanguageScreen.this.selectedLang = autoCode;
            }

            protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                this.defaultButtonNarrationText(narrationElementOutput);
            }
        });
        manager.getLanguages().forEach((s, languageInfo) -> this.renderableVList.addRenderable((Renderable)new AbstractButton(0, 0, 260, 20, languageInfo.toComponent(), (String)s){
            final /* synthetic */ String val$s;
            {
                this.val$s = string;
                super(i, j, k, l, arg);
            }

            protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
                super.renderWidget(guiGraphics, i, j, f);
                if (manager.getSelected().equals(this.val$s)) {
                    this.setFocused(true);
                }
            }

            public void onPress() {
                LegacyLanguageScreen.this.selectedLang = this.val$s;
            }

            protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                this.defaultButtonNarrationText(narrationElementOutput);
            }
        }));
    }

    public static String getSystemLanguageCode() {
        String auto = Locale.getDefault().toString().toLowerCase(Locale.ENGLISH);
        return Minecraft.getInstance().getLanguageManager().getLanguage(auto) != null ? auto : "en_us";
    }

    @Override
    public void onClose() {
        if (this.selectedLang != null && !this.minecraft.getLanguageManager().getSelected().equals(this.selectedLang)) {
            this.minecraft.getLanguageManager().setSelected(this.selectedLang);
            this.minecraft.options.languageCode = this.selectedLang;
            this.minecraft.reloadResourcePacks();
            this.minecraft.options.save();
        }
        super.onClose();
    }

    @Override
    protected void init() {
        this.panel.init();
        this.addRenderableOnly((Renderable)this.panel);
        this.addRenderableOnly((guiGraphics, i, j, f) -> FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 6, this.panel.y + 24, this.panel.width - 12, this.panel.height - 34));
        this.getRenderableVList().init(this.panel.x + 10, this.panel.y + 30, this.panel.width - 20, this.panel.height - 46);
        this.addRenderableWidget((GuiEventListener)LegacyConfigWidgets.createWidget(LegacyOptions.of(this.minecraft.options.forceUnicodeFont()), this.panel.x + 10, this.panel.y + 10, this.panel.width - 20, v -> {}));
    }
}

