/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.client.CommonColor;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyMerchantMenu;
import wily.legacy.inventory.LegacyMerchantOffer;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyMerchantScreen
extends AbstractContainerScreen<LegacyMerchantMenu>
implements Controller.Event,
ControlTooltip.Event {
    protected final boolean[] displaySlotsWarning = new boolean[3];
    protected final List<LegacyIconHolder> merchantTradeButtons = new ArrayList<LegacyIconHolder>();
    protected final ContainerListener listener;
    protected final Stocker.Sizeable tradingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    boolean initOffers = false;

    public LegacyMerchantScreen(LegacyMerchantMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.listener = new ContainerListener(){

            public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
                LegacyMerchantScreen.this.updateSlotsDisplay();
            }

            public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int j) {
            }
        };
        for (int index = 0; index < 10; ++index) {
            this.addTradeButton(index);
        }
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        super.setFocused(guiEventListener);
        if (guiEventListener instanceof LegacyIconHolder) {
            this.updateSlotsDisplay();
        }
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings() {
        return false;
    }

    private void updateSlotsDisplay() {
        this.tradingButtonsOffset.max = Math.max(0, ((LegacyMerchantMenu)this.menu).merchant.getOffers().size() - 10);
        ArrayList<ItemStack> compactList = new ArrayList<ItemStack>();
        RecipeMenu.handleCompactInventoryList(compactList, Minecraft.getInstance().player.getInventory(), ((LegacyMerchantMenu)this.menu).getCarried());
        this.merchantTradeButtons.forEach(b -> {
            b.allowFocusedItemTooltip = true;
            int i = (Integer)this.tradingButtonsOffset.get() + this.merchantTradeButtons.indexOf(b);
            boolean warning = false;
            if (i < ((LegacyMerchantMenu)this.menu).merchant.getOffers().size()) {
                MerchantOffer offer = (MerchantOffer)((LegacyMerchantMenu)this.menu).merchant.getOffers().get(i);
                boolean matchesCostA = compactList.stream().anyMatch(item -> offer.satisfiedBy(item, offer.getCostB()) && item.getCount() >= offer.getCostA().getCount());
                boolean matchesCostB = offer.getCostB().isEmpty() || compactList.stream().anyMatch(item -> offer.satisfiedBy(offer.getCostA(), item) && item.getCount() >= offer.getCostB().getCount());
                boolean bl = warning = !matchesCostA || !matchesCostB;
                if (offer == this.getSelectedMerchantOffer()) {
                    this.displaySlotsWarning[0] = !matchesCostA;
                    this.displaySlotsWarning[1] = !matchesCostB;
                    this.displaySlotsWarning[2] = warning;
                }
            }
            b.setWarning(warning);
        });
    }

    protected void addTradeButton(final int index) {
        LegacyIconHolder h = new LegacyIconHolder(27, 27){

            @Override
            @Nullable
            public Component getAction(ControlTooltip.ActionHolder.Context context) {
                return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 && !LegacyMerchantScreen.this.displaySlotsWarning[2] && this.isValidIndex() && this.isFocused() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).getRequiredLevel() <= ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchantLevel && !((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).isOutOfStock() ? LegacyComponents.TRADE : null);
            }

            @Override
            public void render(GuiGraphics graphics, int i, int j, float f) {
                this.itemIcon = this.isValidIndex() ? ((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).getResult() : ItemStack.EMPTY;
                super.render(graphics, i, j, f);
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 432.0f);
                if (this.isValidIndex() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).getRequiredLevel() > ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchantLevel) {
                    this.renderIcon(LegacySprites.PADLOCK, graphics, false, 16, 16);
                } else if (this.isValidIndex() && ((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).isOutOfStock()) {
                    this.renderIcon(LegacySprites.ERROR_CROSS, graphics, false, 15, 15);
                }
                graphics.pose().popPose();
            }

            @Override
            public void renderItem(GuiGraphics graphics, int i, int j, float f) {
                if (this.itemIcon.isEmpty()) {
                    return;
                }
                ScreenUtil.secureTranslucentRender(graphics, this.isValidIndex() && ((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).isOutOfStock(), 0.5f, u -> super.renderItem(graphics, i, j, f));
            }

            @Override
            public void renderSelection(GuiGraphics graphics, int i, int j, float f) {
                for (int index2 = 0; index2 < 3; ++index2) {
                    MerchantOffer offer = LegacyMerchantScreen.this.getSelectedMerchantOffer();
                    if (index2 == 1 && (offer == null || offer.getCostB().isEmpty())) continue;
                    LegacyIconHolder iconHolder = ScreenUtil.iconHolderRenderer.itemHolder(LegacyMerchantScreen.this.leftPos + (index2 == 2 ? 86 : 17), LegacyMerchantScreen.this.topPos + (index2 == 0 ? 114 + (offer == null || offer.getCostB().isEmpty() ? 16 : 0) : (index2 == 1 ? 144 : 130)), 27, 27, offer == null || index2 == 0 ? ItemStack.EMPTY : (index2 == 1 ? offer.getCostB() : offer.getResult()), offer != null && LegacyMerchantScreen.this.displaySlotsWarning[index2], Vec3.ZERO);
                    iconHolder.render(graphics, i, j, f);
                    if (offer == null || index2 != 0) continue;
                    iconHolder.renderItem(graphics, () -> {
                        ItemStack costA = offer.getCostA();
                        ItemStack baseCostA = offer.getBaseCostA();
                        graphics.renderFakeItem(costA, 0, 0);
                        if (baseCostA.getCount() == costA.getCount()) {
                            graphics.renderItemDecorations(LegacyMerchantScreen.this.font, costA, 0, 0);
                        } else {
                            graphics.renderItemDecorations(LegacyMerchantScreen.this.font, baseCostA, -12, 0, baseCostA.getCount() == 1 ? "1" : null);
                            graphics.renderItemDecorations(LegacyMerchantScreen.this.font, costA, 0, 0, costA.getCount() == 1 ? "1" : null);
                            graphics.pose().pushPose();
                            graphics.pose().translate(0.0f, 0.0f, 300.0f);
                            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.DISCOUNT_STRIKETHRUOGH_SPRITE, -5, 12, 0, 9, 2);
                            graphics.pose().popPose();
                        }
                    }, iconHolder.getX(), iconHolder.getY(), iconHolder.isWarning());
                }
                super.renderSelection(graphics, i, j, f);
            }

            private int getIndex() {
                return (Integer)LegacyMerchantScreen.this.tradingButtonsOffset.get() + index;
            }

            @Override
            public void renderTooltip(Minecraft minecraft, GuiGraphics graphics, int i, int j) {
                super.renderTooltip(minecraft, graphics, i, j);
                if (!this.isFocused()) {
                    return;
                }
                MerchantOffer offer = LegacyMerchantScreen.this.getSelectedMerchantOffer();
                if (offer != null) {
                    for (int index2 = 0; index2 < 3; ++index2) {
                        ItemStack s;
                        ItemStack itemStack = index2 == 0 ? offer.getCostA() : (s = index2 == 1 ? offer.getCostB() : offer.getResult());
                        if (s.isEmpty() || !ScreenUtil.isMouseOver(i, j, LegacyMerchantScreen.this.leftPos + (index2 == 2 ? 86 : 17), LegacyMerchantScreen.this.topPos + (index2 == 0 ? 114 + (offer.getCostB().isEmpty() ? 16 : 0) : (index2 == 1 ? 144 : 130)), 27, 27)) continue;
                        this.renderTooltip(minecraft, graphics, s, i, j);
                    }
                }
            }

            @Override
            public boolean keyPressed(int i, int j, int k) {
                if (i == 263 && index == 0 || i == 262 && index == LegacyMerchantScreen.this.merchantTradeButtons.size() - 1) {
                    int oldOffset = (Integer)LegacyMerchantScreen.this.tradingButtonsOffset.get();
                    LegacyMerchantScreen.this.tradingButtonsOffset.add(i == 263 ? -1 : 1, true);
                    if (oldOffset == LegacyMerchantScreen.this.tradingButtonsOffset.max && i == 262 || oldOffset == 0 && i == 263) {
                        LegacyMerchantScreen.this.setFocused(LegacyMerchantScreen.this.merchantTradeButtons.get(i == 263 ? LegacyMerchantScreen.this.merchantTradeButtons.size() - 1 : 0));
                    } else {
                        LegacyMerchantScreen.this.scrollRenderer.updateScroll(i == 263 ? ScreenDirection.LEFT : ScreenDirection.RIGHT);
                        LegacyMerchantScreen.this.updateSlotsDisplay();
                    }
                    ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
                    return true;
                }
                return super.keyPressed(i, j, k);
            }

            @Override
            public ResourceLocation getIconHolderSprite() {
                return this.isValidIndex() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).getRequiredLevel() > ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchantLevel ? LegacyIconHolder.GRAY_ICON_HOLDER : super.getIconHolderSprite();
            }

            @Override
            public boolean isWarning() {
                return super.isWarning() && this.isValidIndex() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).getRequiredLevel() <= ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchantLevel && !((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).isOutOfStock();
            }

            private boolean isValidIndex() {
                return this.getIndex() < ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().size();
            }

            @Override
            public void onPress() {
                if (this.isValidIndex() && this.isFocused()) {
                    MerchantOffer offer = (MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex());
                    if (((LegacyMerchantOffer)offer).getRequiredLevel() <= ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchantLevel && !offer.isOutOfStock() && !LegacyMerchantScreen.this.displaySlotsWarning[2]) {
                        CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload(Collections.emptyList(), this.getIndex(), Screen.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed));
                    } else {
                        ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.CRAFT_FAIL.get(), 1.0f);
                    }
                }
            }
        };
        h.offset = new Vec3(0.5, 0.0, 0.0);
        this.merchantTradeButtons.add(h);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    public void init() {
        this.imageWidth = 294;
        this.imageHeight = 181;
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY = 12;
        this.inventoryLabelX = 128 + (153 - this.font.width((FormattedText)this.playerInventoryTitle)) / 2;
        this.inventoryLabelY = 87;
        super.init();
        this.updateSlotsDisplay();
        if (!(this.getFocused() instanceof LegacyIconHolder)) {
            this.setFocused(this.merchantTradeButtons.get(0));
        }
        this.merchantTradeButtons.forEach(holder -> {
            int i = this.merchantTradeButtons.indexOf(holder);
            holder.setX(this.leftPos + 13 + 27 * i);
            holder.setY(this.topPos + 44);
            this.addRenderableWidget((GuiEventListener)holder);
        });
        ((LegacyMerchantMenu)this.menu).addSlotListener(this.listener);
    }

    public void removed() {
        super.removed();
        ((LegacyMerchantMenu)this.menu).removeSlotListener(this.listener);
    }

    public MerchantOffer getSelectedMerchantOffer() {
        return this.getSelectedOfferIndex() < ((LegacyMerchantMenu)this.menu).merchant.getOffers().size() ? (MerchantOffer)((LegacyMerchantMenu)this.menu).merchant.getOffers().get(this.getSelectedOfferIndex()) : null;
    }

    public int getSelectedOfferIndex() {
        int n;
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof LegacyIconHolder) {
            LegacyIconHolder h = (LegacyIconHolder)guiEventListener;
            n = this.merchantTradeButtons.indexOf(h);
        } else {
            n = 0;
        }
        return n + (Integer)this.tradingButtonsOffset.get();
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        if (!((LegacyMerchantMenu)this.menu).merchant.getOffers().isEmpty() && !this.initOffers) {
            this.initOffers = true;
            this.updateSlotsDisplay();
        }
        super.render(guiGraphics, i, j, f);
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof LegacyIconHolder) {
            LegacyIconHolder h = (LegacyIconHolder)guiEventListener;
            h.renderSelection(guiGraphics, i, j, f);
        }
        this.merchantTradeButtons.forEach(b -> b.renderTooltip(this.minecraft, guiGraphics, i, j));
        this.renderTooltip(guiGraphics, i, j);
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.tradingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.tradingButtonsOffset.max > 0) && this.tradingButtonsOffset.add(scroll, false) != 0) {
            this.updateSlotsDisplay();
            return true;
        }
        return false;
    }

    protected void renderProgressBar(GuiGraphics guiGraphics) {
        int p;
        int k = ((LegacyMerchantMenu)this.menu).merchantLevel;
        int l = ((LegacyMerchantMenu)this.menu).merchant.getVillagerXp();
        if (k >= 5) {
            return;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.leftPos + ((float)this.imageWidth - 241.5f) / 2.0f, (float)(this.topPos + 28), 0.0f);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_BACKGROUND, 0, 0, 0, 161, 4);
        int m = VillagerData.getMinXpPerLevel((int)k);
        if (l < m || !VillagerData.canLevelUp((int)k)) {
            guiGraphics.pose().popPose();
            return;
        }
        float f = 161.0f / (float)(VillagerData.getMaxXpPerLevel((int)k) - m);
        int o = Math.min(Mth.floor((float)(f * (float)(l - m))), 161);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_CURRENT, 161, 4, 0, 0, 0, 0, 0, o, 4);
        int n = p = this.getSelectedMerchantOffer() != null ? this.getSelectedMerchantOffer().getXp() : 0;
        if (p > 0) {
            int q = Math.min(Mth.floor((float)((float)p * f)), 161 - o);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_RESULT, 161, 4, o, 0, o, 0, 0, q, 4);
        }
        guiGraphics.pose().popPose();
    }

    public static MutableComponent getMerchantTile(Component title, int i) {
        return Component.translatable((String)"merchant.title", (Object[])new Object[]{title, Component.translatable((String)("merchant.level." + i))});
    }

    public void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        int level;
        int k = ((LegacyMerchantMenu)this.menu).merchantLevel;
        if (k > 0 && k <= 5 && ((LegacyMerchantMenu)this.menu).showProgressBar) {
            MutableComponent component = LegacyMerchantScreen.getMerchantTile(this.title, k);
            guiGraphics.drawString(this.font, (Component)component, (this.imageWidth - this.font.width((FormattedText)component)) / 2, this.titleLabelY, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        } else {
            guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        if (this.getSelectedMerchantOffer() != null && ((LegacyMerchantMenu)this.menu).showProgressBar && (level = ((LegacyMerchantOffer)this.getSelectedMerchantOffer()).getRequiredLevel()) > 0) {
            MutableComponent c = Component.translatable((String)("merchant.level." + level));
            guiGraphics.drawString(this.font, (Component)c, 15 + (105 - this.font.width((FormattedText)c)) / 2, 100, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
    }

    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        LegacyMerchantOffer o;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 12, this.topPos + 79, 110, 93);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 126, this.topPos + 79, 157, 93);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 47), (float)(this.topPos + 131), 0.0f);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, 0, 0, 22, 15);
        if (this.getSelectedMerchantOffer() != null && this.getSelectedMerchantOffer().isOutOfStock()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ERROR_CROSS, 4, 0, 15, 15);
        }
        guiGraphics.pose().popPose();
        MerchantOffer merchantOffer = this.getSelectedMerchantOffer();
        if (merchantOffer instanceof LegacyMerchantOffer && (o = (LegacyMerchantOffer)merchantOffer).getRequiredLevel() > ((LegacyMerchantMenu)this.menu).merchantLevel) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PADLOCK, this.leftPos + 56, this.topPos + 134, 16, 16);
        }
        if (UIAccessor.of((Screen)this).getBoolean("showProgressBar", Boolean.valueOf(((LegacyMerchantMenu)this.menu).showProgressBar)).booleanValue()) {
            this.renderProgressBar(guiGraphics);
        }
        if ((Integer)this.tradingButtonsOffset.get() > 0) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.leftPos + 5, this.topPos + 52);
        }
        if (this.tradingButtonsOffset.max > 0 && (Integer)this.tradingButtonsOffset.get() < this.tradingButtonsOffset.max) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.leftPos + 283, this.topPos + 52);
        }
    }
}

