/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.util.DynamicUtil;

public class JsonUtil {
    public static <T> Predicate<T> registryMatches(Registry<T> registry, JsonObject o) {
        JsonPrimitive j;
        JsonElement jsonElement;
        String name = registry.key().location().getPath();
        if (!o.has(name) && !o.has(name + "s")) {
            return t -> false;
        }
        ArrayList<Object> tip = new ArrayList<Object>();
        ArrayList tipExclusions = new ArrayList();
        ArrayList<TagKey> tipTags = new ArrayList<TagKey>();
        if (o.has(name) && (jsonElement = o.get(name)) instanceof JsonPrimitive && (j = (JsonPrimitive)jsonElement).isString()) {
            String s = j.getAsString();
            if (s.startsWith("#")) {
                tipTags.add(TagKey.create((ResourceKey)registry.key(), (ResourceLocation)FactoryAPI.createLocation((String)s.replaceFirst("#", ""))));
            } else {
                tip.add(FactoryAPIPlatform.getRegistryValue((ResourceLocation)FactoryAPI.createLocation((String)s), registry));
            }
        }
        if (o.has(name + "s") && (jsonElement = o.get(name + "s")) instanceof JsonArray) {
            JsonArray a = (JsonArray)jsonElement;
            a.forEach(ie -> {
                JsonPrimitive p;
                if (ie instanceof JsonPrimitive && (p = (JsonPrimitive)ie).isString()) {
                    String s = p.getAsString();
                    if (s.startsWith("#")) {
                        tipTags.add(TagKey.create((ResourceKey)registry.key(), (ResourceLocation)FactoryAPI.createLocation((String)s.replaceFirst("#", ""))));
                    } else if (s.startsWith("!")) {
                        ResourceLocation l = FactoryAPI.createLocation((String)s.replaceFirst("!", ""));
                        registry.getOptional(l).ifPresent(tipExclusions::add);
                    } else {
                        tip.add(FactoryAPIPlatform.getRegistryValue((ResourceLocation)FactoryAPI.createLocation((String)s), (Registry)registry));
                    }
                }
            });
        }
        return t -> {
            if (tipExclusions.contains(t)) return false;
            if (tip.contains(t)) return true;
            if (!tipTags.stream().anyMatch(arg_0 -> ((Holder.Reference)registry.getOrThrow((ResourceKey)registry.getResourceKey(t).orElseThrow())).is(arg_0))) return false;
            return true;
        };
    }

    public static BiPredicate<Item, DataComponentPatch> registryMatchesItem(JsonObject o) {
        DataComponentPatch data = o.has("components") ? (DataComponentPatch)DataComponentPatch.CODEC.parse(DynamicUtil.getActualRegistryOps((DynamicOps)JsonOps.INSTANCE), (Object)o.getAsJsonObject("components")).getOrThrow() : null;
        Predicate p = JsonUtil.registryMatches(BuiltInRegistries.ITEM, o);
        return (item, d) -> p.test(item) && (data == null || Objects.equals(d, data));
    }

    public static ArbitrarySupplier<ItemStack> getItemFromJson(JsonElement element, boolean allowData) {
        return DynamicUtil.getItemFromDynamic((Dynamic)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)element), (boolean)allowData);
    }

    public static <K, V> void addMapListEntry(Map<K, List<V>> map, K key, V entry) {
        map.computeIfAbsent(key, k -> new ArrayList()).add(entry);
    }

    public static <T> T getJsonStringOrNull(JsonObject object, String element, Function<String, T> constructor) {
        String s = GsonHelper.getAsString((JsonObject)object, (String)element, null);
        return s == null ? null : (T)constructor.apply(s);
    }

    public static <T> void ifJsonStringNotNull(JsonObject object, String element, Function<String, T> constructor, Consumer<T> consumer) {
        T obj = JsonUtil.getJsonStringOrNull(object, element, constructor);
        if (obj != null) {
            consumer.accept(obj);
        }
    }

    public static Stream<String> getOrderedNamespaces(ResourceManager manager) {
        return manager.getNamespaces().stream().sorted(Comparator.comparingInt(s -> s.equals("legacy") ? 0 : 1));
    }

    public static Integer optionalJsonColor(JsonObject object, String element, Integer fallback) {
        return JsonUtil.optionalJsonColor(object.get(element), fallback);
    }

    public static Integer optionalJsonColor(JsonElement element, Integer fallback) {
        if (element instanceof JsonPrimitive) {
            JsonPrimitive p = (JsonPrimitive)element;
            if (p.isString() && p.getAsString().startsWith("#")) {
                return (int)Long.parseLong(p.getAsString().substring(1), 16);
            }
            return p.getAsInt();
        }
        return fallback;
    }
}

