/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.RegisterListing;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.IdValueInfo;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.SizeableAsset;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.util.IOUtil;

public record ControlType(ResourceLocation id, Optional<Component> name, boolean isKbm, Optional<SizeableAsset<FontDescription>> font, Optional<ResourceLocation> minecraftLogo, Optional<SizeableAsset<Style>> style, Map<String, ControlTooltip.LegacyIcon> icons) implements IdValueInfo<ControlType>
{
    public static final SizeableAsset<Style> EMPTY_STYLE_ASSET = new SizeableAsset<Style>(Style.EMPTY);
    public static final Codec<ControlType> EXTENDED_CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ControlType::id), (App)DynamicUtil.getComponentCodec().optionalFieldOf("name").forGetter(ControlType::name), (App)Codec.BOOL.fieldOf("isKbm").orElse((Object)false).forGetter(ControlType::isKbm), (App)SizeableAsset.createWithFallback(FontDescription.CODEC).optionalFieldOf("font").forGetter(ControlType::font), (App)ResourceLocation.CODEC.optionalFieldOf("minecraftLogo").forGetter(ControlType::minecraftLogo)).apply((Applicative)i, ControlType::new));
    public static final Codec<ControlType> CODEC = IOUtil.createFallbackCodec(EXTENDED_CODEC, ResourceLocation.CODEC.xmap(ControlType::new, ControlType::id));
    public static final ResourceLocation KBM = Legacy4J.createModLocation("java");
    public static final ResourceLocation x360 = Legacy4J.createModLocation("xbox_360");
    public static final ResourceLocation xONE = Legacy4J.createModLocation("xbox_one");
    public static final ResourceLocation PS3 = Legacy4J.createModLocation("playstation_3");
    public static final ResourceLocation PS4 = Legacy4J.createModLocation("playstation_4");
    public static final ResourceLocation WII_U = Legacy4J.createModLocation("wii_u");
    public static final ResourceLocation SWITCH = Legacy4J.createModLocation("switch");
    public static final ResourceLocation STEAM = Legacy4J.createModLocation("steam");
    public static final ResourceLocation STADIA = Legacy4J.createModLocation("stadia");
    public static final ResourceLocation PSVITA = Legacy4J.createModLocation("playstation_vita");
    public static final ResourceLocation PS5 = Legacy4J.createModLocation("playstation_5");

    public ControlType(ResourceLocation id, Optional<Component> name, boolean isKbm, Optional<SizeableAsset<FontDescription>> font, Optional<ResourceLocation> minecraftLogo) {
        this(id, name, isKbm, font, minecraftLogo, font.map(asset -> asset.map(arg_0 -> ((Style)Style.EMPTY).withFont(arg_0))), new HashMap<String, ControlTooltip.LegacyIcon>());
    }

    public ControlType(ResourceLocation id) {
        this(id, Optional.of(Component.translatable((String)("legacy.options.controlType." + id.getPath()))), false, Optional.of(new SizeableAsset<FontDescription.Resource>(new FontDescription.Resource(id))), Optional.of(id.withPath("textures/gui/title/minecraft/%s.png".formatted(id.getPath()))));
    }

    public static ControlType getActiveControllerType() {
        if (((Holder)LegacyOptions.selectedControlType.get()).isAuto()) {
            if (Legacy4JClient.controllerManager.connectedController != null) {
                return Legacy4JClient.controllerManager.connectedController.getType();
            }
            return ControlType.get(x360);
        }
        ControlType type = ((Holder)LegacyOptions.selectedControlType.get()).get();
        return type.isKbm() ? ControlType.get(x360) : type;
    }

    public static ControlType getActiveType() {
        return (Boolean)LegacyOptions.lockControlTypeChange.get() == false && Legacy4JClient.controllerManager.isControllerTheLastInput() || (Boolean)LegacyOptions.lockControlTypeChange.get() != false && (Legacy4JClient.controllerManager.connectedController != null && ((Holder)LegacyOptions.selectedControlType.get()).isAuto() || !((Holder)LegacyOptions.selectedControlType.get()).orElse(ControlType.get(KBM)).isKbm()) ? ControlType.getActiveControllerType() : ControlType.getKbmActiveType();
    }

    public static ControlType getKbmActiveType() {
        if (((Holder)LegacyOptions.selectedControlType.get()).isAuto()) {
            return ControlType.get(KBM);
        }
        ControlType type = ((Holder)LegacyOptions.selectedControlType.get()).get();
        return !type.isKbm() ? ControlType.get(KBM) : type;
    }

    public static ControlType get(ResourceLocation id) {
        return (ControlType)Legacy4JClient.controlTypesManager.map().get((Object)id);
    }

    public Style styleOrEmpty() {
        return this.style.orElse(EMPTY_STYLE_ASSET).get();
    }

    @Override
    public ControlType copyFrom(ControlType other) {
        return new ControlType(this.id, other.name.or(this::name), this.isKbm, other.font.or(this::font), other.minecraftLogo.or(this::minecraftLogo), other.style.or(this::style), this.icons);
    }

    @Override
    public boolean isValid() {
        return this.name.isPresent() && this.font.isPresent() && this.style.isPresent();
    }

    public static class Holder
    implements RegisterListing.Holder<ControlType> {
        public static final Holder AUTO = new Holder(null){

            @Override
            public ControlType get() {
                return null;
            }

            @Override
            public String toString() {
                return "auto";
            }
        };
        public static final Codec<Holder> CODEC = Codec.STRING.xmap(Holder::parse, Holder::toString);
        private final ResourceLocation id;
        private ControlType controlType;

        public Holder(ResourceLocation id) {
            this.id = id;
        }

        public static Holder parse(String stringId) {
            if (stringId.equals("auto")) {
                return AUTO;
            }
            ResourceLocation id = FactoryAPI.createLocation((String)stringId);
            return id == null ? AUTO : new Holder(id);
        }

        public static Holder of(final ControlType controlType) {
            return new Holder(controlType.id()){

                @Override
                public ControlType get() {
                    return controlType;
                }
            };
        }

        public boolean isAuto() {
            return this.get() == null;
        }

        public ControlType orElse(ControlType alternative) {
            ControlType controlType = this.get();
            return controlType == null ? alternative : controlType;
        }

        public boolean equals(Object obj) {
            Holder h;
            return obj instanceof Holder && (h = (Holder)obj).get() == this.get();
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public String toString() {
            return this.id.toString();
        }

        public ControlType get() {
            return this.controlType == null ? (this.controlType = ControlType.get(this.id)) : this.controlType;
        }
    }

    public static interface UpdateEvent {
        public static final FactoryEvent<UpdateEvent> EVENT = new FactoryEvent(e -> (last, actual) -> e.invokeAll(l -> l.change(last, actual)));

        public void change(ControlType var1, ControlType var2);
    }
}

