/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyTabInfo;
import wily.legacy.client.screen.LegacyTabButton;

public record LegacyCreativeTabListing(ResourceLocation id, Optional<Component> name, Optional<LegacyTabButton.IconHolder<?>> iconHolder, List<ArbitrarySupplier<ItemStack>> displayItems) implements LegacyTabInfo<LegacyCreativeTabListing>
{
    public static final Codec<LegacyCreativeTabListing> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(LegacyCreativeTabListing::id), (App)DynamicUtil.getComponentCodec().optionalFieldOf("name").forGetter(LegacyCreativeTabListing::name), (App)LegacyTabButton.ICON_HOLDER_CODEC.optionalFieldOf("icon").forGetter(LegacyCreativeTabListing::iconHolder), (App)DynamicUtil.ITEM_SUPPLIER_CODEC.listOf().fieldOf("listing").orElseGet(ArrayList::new).forGetter(LegacyCreativeTabListing::displayItems)).apply((Applicative)i, LegacyCreativeTabListing::new));
    public static final ResourceLocation SEARCH = Legacy4J.createModLocation("search");

    public static void rebuildVanillaCreativeTabsItems(Minecraft minecraft) {
        if (minecraft.getConnection() != null && CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)minecraft.getConnection().enabledFeatures(), (boolean)((Boolean)minecraft.options.operatorItemsTab().get()), (HolderLookup.Provider)minecraft.getConnection().registryAccess())) {
            List list = List.copyOf(CreativeModeTabs.searchTab().getDisplayItems());
            minecraft.getConnection().searchTrees().updateCreativeTooltips((HolderLookup.Provider)minecraft.getConnection().registryAccess(), list);
            minecraft.getConnection().searchTrees().updateCreativeTags(list);
        }
    }

    @Override
    public boolean isValid() {
        return LegacyTabInfo.super.isValid() && !this.is(SEARCH);
    }

    @Override
    public LegacyCreativeTabListing copyFrom(LegacyCreativeTabListing otherListing) {
        this.displayItems.addAll(otherListing.displayItems);
        return new LegacyCreativeTabListing(this.id, otherListing.name.or(this::name), otherListing.iconHolder.or(this::iconHolder), this.displayItems);
    }
}

