/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MappableRingBuffer;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyRenderPipelines;

public class LegacyGamma
implements AutoCloseable {
    public static final LegacyGamma INSTANCE = new LegacyGamma();
    private final MappableRingBuffer ubo = new MappableRingBuffer(() -> "gamma SamplerInfo", 130, 4);

    public void render() {
        Double value = (Double)LegacyOptions.legacyGamma.get();
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        try (GpuBuffer.MappedView mappedView = commandEncoder.mapBuffer(this.ubo.currentBuffer(), false, true);){
            Std140Builder.intoBuffer((ByteBuffer)mappedView.data()).putFloat(value.floatValue() >= 0.5f ? (value.floatValue() - 0.5f) * 1.12f + 1.08f : value.floatValue() * 0.96f + 0.6f);
        }
        RenderTarget target = Minecraft.getInstance().getMainRenderTarget();
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("legacyGamma");
        try (RenderPass renderPass = commandEncoder.createRenderPass(() -> "Display Legacy Gamma", target.getColorTextureView(), OptionalInt.empty(), target.useDepth ? target.getDepthTextureView() : null, OptionalDouble.empty());){
            renderPass.setPipeline(LegacyRenderPipelines.GAMMA);
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.setUniform("GammaInfo", this.ubo.currentBuffer());
            renderPass.bindSampler("InSampler", target.getColorTextureView());
            renderPass.draw(0, 3);
        }
        this.ubo.rotate();
        profilerFiller.pop();
    }

    @Override
    public void close() {
        this.ubo.close();
    }
}

