/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyIntro;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.ControllerManager;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.KeyboardScreen;
import wily.legacy.util.IOUtil;

public class LegacyResourceManager
implements ResourceManagerReloadListener {
    public static final ResourceLocation GAMEPAD_MAPPINGS = Legacy4J.createModLocation("gamepad_mappings.txt");
    public static final ResourceLocation INTRO_LOCATION = Legacy4J.createModLocation("intro.json");
    public static final ResourceLocation GAMMA_LOCATION = Legacy4J.createModLocation("gamma");
    public static final ResourceLocation DEFAULT_KEYBOARD_LAYOUT_LOCATION = Legacy4J.createModLocation("keyboard_layout/en_us.json");
    public static final ResourceLocation PLAYER_IDENTIFIERS_LOCATION = Legacy4J.createModLocation("player_identifiers.json");
    public static final String COMMON_COLORS = "common_colors.json";
    public static final String COMMON_VALUES = "common_values.json";
    public static final String DEFAULT_KBM_ICONS = "control_tooltips/icons/kbm.json";
    public static final String DEFAULT_CONTROLLER_ICONS = "control_tooltips/icons/controller.json";
    public static final List<KeyboardScreen.CharButtonBuilder> keyboardButtonBuilders = new ArrayList<KeyboardScreen.CharButtonBuilder>();
    public static LegacyIntro intro = LegacyIntro.EMPTY;
    public static ControllerBinding<?> shiftBinding;

    public static void setKeyboardLayout(Resource resource) {
        try {
            JsonObject obj = GsonHelper.parse((Reader)resource.openAsReader());
            keyboardButtonBuilders.clear();
            shiftBinding = obj.has("shiftBinding") ? ControllerBinding.map.get(obj.get("shiftBinding").getAsString()) : ControllerBinding.LEFT_STICK_BUTTON;
            obj.getAsJsonArray("layout").forEach(e -> {
                if (e instanceof JsonObject) {
                    JsonObject o = (JsonObject)e;
                    keyboardButtonBuilders.add(new KeyboardScreen.CharButtonBuilder(GsonHelper.getAsInt((JsonObject)o, (String)"width", (int)25), GsonHelper.getAsString((JsonObject)o, (String)"chars"), GsonHelper.getAsString((JsonObject)o, (String)"shiftChars", null), IOUtil.getJsonStringOrNull(o, "binding", ControllerBinding.map::get), IOUtil.getJsonStringOrNull(o, "icon", FactoryAPI::createLocation), IOUtil.getJsonStringOrNull(o, "soundEvent", s -> (SoundEvent)FactoryAPIPlatform.getRegistryValue((ResourceLocation)FactoryAPI.createLocation((String)s), (Registry)BuiltInRegistries.SOUND_EVENT))));
                } else if (e instanceof JsonPrimitive) {
                    JsonPrimitive p = (JsonPrimitive)e;
                    keyboardButtonBuilders.add(new KeyboardScreen.CharButtonBuilder(25, p.getAsString(), null, null, null, null));
                }
            });
        }
        catch (IOException e2) {
            Legacy4J.LOGGER.warn(e2.getMessage());
        }
    }

    public static void addIcons(ResourceManager resourceManager, ResourceLocation location, BiConsumer<String, JsonObject> addIcon) {
        resourceManager.getResource(location).ifPresent(r -> {
            try {
                GsonHelper.parse((Reader)r.openAsReader()).asMap().forEach((s, o) -> addIcon.accept((String)s, o.getAsJsonObject()));
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn(e.getMessage());
            }
        });
    }

    public static void addControllerIcons(ResourceManager resourceManager, ResourceLocation location, BiConsumer<String, ControlTooltip.LegacyIcon> addIcon) {
        LegacyResourceManager.addIcons(resourceManager, location, (s, o) -> {
            ControllerBinding<?> binding = ControllerBinding.map.get(s);
            if (binding != null) {
                addIcon.accept((String)s, ControlTooltip.LegacyIcon.create(() -> binding.getMapped().state(), IOUtil.getJsonStringOrNull(o, "icon", String::toCharArray), IOUtil.getJsonStringOrNull(o, "iconOverlay", String::toCharArray), IOUtil.getJsonStringOrNull(o, "tipIcon", v -> Character.valueOf(v.charAt(0)))));
            }
        });
    }

    public static void addKbmIcons(ResourceManager resourceManager, ResourceLocation location, BiConsumer<String, ControlTooltip.LegacyIcon> addIcon) {
        LegacyResourceManager.addIcons(resourceManager, location, (s, o) -> {
            InputConstants.Key key = InputConstants.getKey((String)s);
            ControlTooltip.KeyIcon icon = ControlTooltip.KeyIcon.create(key, IOUtil.getJsonStringOrNull(o, "icon", String::toCharArray), IOUtil.getJsonStringOrNull(o, "iconOverlay", String::toCharArray), IOUtil.getJsonStringOrNull(o, "tipIcon", v -> Character.valueOf(v.charAt(0))));
            addIcon.accept(key.getName(), icon);
        });
    }

    public static void loadIntroLocations(ResourceManager resourceManager) {
        try {
            LegacyIntro.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resourceManager.openAsReader(INTRO_LOCATION))).result().ifPresent(i -> {
                intro = i;
            });
        }
        catch (IOException e) {
            Legacy4J.LOGGER.error(e.getMessage());
        }
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        Minecraft minecraft = Minecraft.getInstance();
        resourceManager.getResource(GAMEPAD_MAPPINGS).ifPresent(r -> {
            try {
                ControllerManager.getHandler().applyGamePadMappingsFromBuffer(r.openAsReader());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        PlayerIdentifier.list.clear();
        resourceManager.getResourceStack(PLAYER_IDENTIFIERS_LOCATION).forEach(r -> {
            try {
                GsonHelper.parseArray((Reader)r.openAsReader()).forEach(e -> PlayerIdentifier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, e).result().ifPresent(p -> PlayerIdentifier.list.put(p.index(), p)));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        });
        CommonValue.COMMON_VALUES.forEach((s, c) -> c.reset());
        CommonColor.COMMON_COLORS.forEach((s, c) -> c.reset());
        resourceManager.getResource(DEFAULT_KEYBOARD_LAYOUT_LOCATION).ifPresent(LegacyResourceManager::setKeyboardLayout);
        IOUtil.getOrderedNamespaces(resourceManager).forEach(name -> {
            resourceManager.getResource(FactoryAPI.createLocation((String)name, (String)COMMON_COLORS)).ifPresent(r -> {
                try {
                    JsonObject obj = GsonHelper.parse((Reader)r.openAsReader());
                    obj.asMap().forEach((s, e) -> {
                        ResourceLocation id = FactoryAPI.createLocation((String)s);
                        if (CommonColor.COMMON_COLORS.containsKey((Object)id)) {
                            ((CommonColor)((Object)((Object)((Object)((Object)CommonColor.COMMON_COLORS.get((Object)id)))))).parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                        }
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            resourceManager.getResource(FactoryAPI.createLocation((String)name, (String)COMMON_VALUES)).ifPresent(r -> {
                try {
                    JsonObject obj = GsonHelper.parse((Reader)r.openAsReader());
                    obj.asMap().forEach((s, e) -> {
                        ResourceLocation id = FactoryAPI.createLocation((String)s);
                        if (CommonColor.COMMON_VALUES.containsKey((Object)id)) {
                            ((CommonValue)((Object)((Object)((Object)((Object)CommonColor.COMMON_VALUES.get((Object)id)))))).parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                        }
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            LegacyResourceManager.addKbmIcons(resourceManager, FactoryAPI.createLocation((String)name, (String)DEFAULT_KBM_ICONS), (s, b) -> {
                for (ControlType value : Legacy4JClient.controlTypesManager.map().values()) {
                    if (!value.isKbm()) continue;
                    value.icons().put((String)s, (ControlTooltip.LegacyIcon)b);
                }
            });
            LegacyResourceManager.addControllerIcons(resourceManager, FactoryAPI.createLocation((String)name, (String)DEFAULT_CONTROLLER_ICONS), (s, b) -> {
                for (ControlType value : Legacy4JClient.controlTypesManager.map().values()) {
                    if (value.isKbm()) continue;
                    value.icons().put((String)s, (ControlTooltip.LegacyIcon)b);
                }
            });
            for (ControlType value : Legacy4JClient.controlTypesManager.map().values()) {
                ResourceLocation location = FactoryAPI.createLocation((String)value.id().getNamespace(), (String)"control_tooltips/icons/%s.json".formatted(value.id().getPath()));
                if (value.isKbm()) {
                    LegacyResourceManager.addKbmIcons(resourceManager, location, value.icons()::put);
                    continue;
                }
                LegacyResourceManager.addControllerIcons(resourceManager, location, value.icons()::put);
            }
            String langKey = minecraft.getLanguageManager().getLanguage(minecraft.getLanguageManager().getSelected()) != null ? minecraft.getLanguageManager().getSelected() : "en_us";
            resourceManager.getResource(FactoryAPI.createLocation((String)name, (String)"keyboard_layout/%s.json".formatted(langKey))).ifPresent(LegacyResourceManager::setKeyboardLayout);
        });
    }

    public String getName() {
        return "legacy:resource_manager";
    }
}

