/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.commons.io.FileUtils;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;

public class LegacySaveCache {
    public static LevelStorageSource currentWorldSource;
    public static boolean manualSave;
    public static boolean saveExit;
    public static boolean retakeWorldIcon;

    public static void setup(Minecraft m) {
        currentWorldSource = LevelStorageSource.createDefault((Path)m.gameDirectory.toPath().resolve("current-world"));
    }

    public static LevelStorageSource getLevelStorageSource() {
        return (Boolean)LegacyOptions.saveCache.get() != false ? currentWorldSource : Minecraft.getInstance().getLevelSource();
    }

    public static boolean hasSaveSystem(Minecraft minecraft) {
        return minecraft.hasSingleplayerServer() && !minecraft.isDemo() && !minecraft.getSingleplayerServer().isHardcore() && LegacySaveCache.isCurrentWorldSource(minecraft.getSingleplayerServer().storageSource);
    }

    public static boolean isCurrentWorldSource(LevelStorageSource.LevelStorageAccess storageSource) {
        return storageSource.getDimensionPath(Level.OVERWORLD).getParent().equals(currentWorldSource.getBaseDir());
    }

    public static void saveLevel(LevelStorageSource.LevelStorageAccess storageSource) {
        if (LegacySaveCache.isCurrentWorldSource(storageSource)) {
            LegacySaveCache.copySaveBtwSources(storageSource, Minecraft.getInstance().getLevelSource(), false);
        }
    }

    public static String importSaveFile(InputStream saveInputStream, Predicate<String> exists, LevelStorageSource source, String saveDirName) {
        return Legacy4JClient.manageAvailableSaveDirName(f -> Legacy4J.copySaveToDirectory(saveInputStream, f), exists, source, saveDirName);
    }

    public static String importSaveFile(InputStream saveInputStream, LevelStorageSource source, String saveDirName) {
        return LegacySaveCache.importSaveFile(saveInputStream, arg_0 -> ((LevelStorageSource)source).levelExists(arg_0), source, saveDirName);
    }

    public static String copySaveFile(Path savePath, LevelStorageSource source, String saveDirName) {
        return Legacy4JClient.manageAvailableSaveDirName(f -> {
            try {
                FileUtils.copyDirectory((File)savePath.toFile(), (File)f);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, arg_0 -> ((LevelStorageSource)source).levelExists(arg_0), source, saveDirName);
    }

    public static void copySaveBtwSources(LevelStorageSource.LevelStorageAccess sendSource, LevelStorageSource destSource) {
        LegacySaveCache.copySaveBtwSources(sendSource, destSource, true);
    }

    public static void copySaveBtwSources(LevelStorageSource.LevelStorageAccess sendSource, LevelStorageSource destSource, boolean deleteOldDest) {
        try {
            File destLevelDirectory = destSource.getBaseDir().resolve(sendSource.getLevelId()).toFile();
            if (deleteOldDest && destLevelDirectory.exists()) {
                FileUtils.deleteQuietly((File)destLevelDirectory);
            }
            FileUtils.copyDirectory((File)sendSource.getDimensionPath(Level.OVERWORLD).toFile(), (File)destLevelDirectory, p -> {
                if (p.getName().equals("session.lock")) {
                    return false;
                }
                if (deleteOldDest) {
                    return true;
                }
                File destFile = p.toPath().relativize(destLevelDirectory.toPath()).toFile();
                return !destFile.exists() || FileUtils.isFileNewer((File)p, (File)destFile);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        manualSave = false;
        saveExit = false;
        retakeWorldIcon = false;
    }
}

