/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.RegisterListing;
import wily.factoryapi.base.StackIngredient;
import wily.factoryapi.util.ListMap;
import wily.legacy.util.IOUtil;
import wily.legacy.util.LegacyItemUtil;

public interface RecipeInfo<T>
extends RegisterListing.Holder<T> {
    public static <T> RecipeInfo<T> create(ResourceKey<Recipe<?>> id, T value, List<Optional<Ingredient>> ings, ItemStack result) {
        return RecipeInfo.create(id.location(), value, ings, result, () -> null);
    }

    public static <T> RecipeInfo<T> create(ResourceLocation id, T value, List<Optional<Ingredient>> ings, ItemStack result) {
        return RecipeInfo.create(id, value, ings, result, () -> null);
    }

    public static <T> RecipeInfo<T> create(ResourceLocation id, T value, List<Optional<Ingredient>> ings, ItemStack result, Supplier<Component> description) {
        return RecipeInfo.create(id, value, ings, result, result.getHoverName(), description);
    }

    public static <T> RecipeInfo<T> create(final ResourceLocation id, final T value, final List<Optional<Ingredient>> ings, final ItemStack result, final Component name, final Supplier<Component> description) {
        return new RecipeInfo<T>(){

            public T get() {
                return value;
            }

            public ResourceLocation getId() {
                return id;
            }

            @Override
            public List<Optional<Ingredient>> getOptionalIngredients() {
                return ings;
            }

            @Override
            public ItemStack getResultItem() {
                return result;
            }

            @Override
            public Component getName() {
                return name;
            }

            @Override
            public Component getDescription() {
                return (Component)description.get();
            }

            public boolean equals(Object obj) {
                RecipeInfo h1;
                RecipeHolder h;
                return super.equals(obj) || obj instanceof RecipeHolder && (h = (RecipeHolder)obj).id().equals(this.getId()) || obj instanceof RecipeInfo && (h1 = (RecipeInfo)obj).getId().equals((Object)this.getId());
            }
        };
    }

    default public boolean isInvalid() {
        Recipe r;
        Object object = this.get();
        return object instanceof Recipe && (r = (Recipe)object).isSpecial() || this.getOptionalIngredients().isEmpty() || this.getResultItem().isEmpty();
    }

    default public boolean isOverride() {
        return this.get() == null;
    }

    public List<Optional<Ingredient>> getOptionalIngredients();

    public ItemStack getResultItem();

    public Component getName();

    public Component getDescription();

    public static interface Filter
    extends Predicate<RecipeInfo<?>> {
        public static final ListMap<ResourceLocation, Codec<? extends Filter>> map = ListMap.builder().put((Object)"id", Id.CODEC).put((Object)"item_tag", Id.CODEC).put((Object)"block_tag", BlockTag.CODEC).put((Object)"item_id", ItemId.CODEC).mapKeys(FactoryAPI::createVanillaLocation).build();
        public static final Codec<Filter> BY_TYPE_CODEC = new Codec<Filter>(){

            public <T> DataResult<T> encode(Filter input, DynamicOps<T> ops, T prefix) {
                return ResourceLocation.CODEC.fieldOf("type").codec().encode((Object)((ResourceLocation)map.getKey(input.codec())), ops, prefix).flatMap(r -> input.codec().fieldOf("value").codec().encode((Object)input, ops, r));
            }

            public <T> DataResult<Pair<Filter, T>> decode(DynamicOps<T> ops, T input) {
                Dynamic dynamic = new Dynamic(ops, input);
                return dynamic.get("type").flatMap(arg_0 -> ((Codec)ResourceLocation.CODEC).parse(arg_0)).flatMap(r -> dynamic.get("value").flatMap(d -> ((Codec)map.get(r)).parse(d)).map(f -> Pair.of((Object)f, (Object)input)));
            }
        };
        public static final Codec<Filter> CODEC = IOUtil.createFallbackCodec(BY_TYPE_CODEC, Codec.STRING.xmap(Filter::parse, (Function<Filter, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lwily/legacy/client/RecipeInfo$Filter;)Ljava/lang/String;)()));
        public static final Codec<List<Filter>> LIST_CODEC = CODEC.listOf().xmap(ArrayList::new, Function.identity());
        public static final Codec<Map<String, List<Filter>>> LISTING_CODEC = IOUtil.createListingCodec(IOUtil.createFallbackCodec(LIST_CODEC, CODEC.xmap(f -> new ArrayList<Filter>(Collections.singleton(f)), list -> (Filter)list.get(0))), "group", "recipes", l -> ((Filter)l.get(0)).toString());
        public static final ResourceLocation TIPPED_ARROW = FactoryAPI.createVanillaLocation((String)"tipped_arrow");
        public static final Map<ResourceLocation, IdOverride> ID_RECIPE_INFO_OVERRIDES = new HashMap(Map.of(TIPPED_ARROW, (validRecipes, recipeAdder) -> BuiltInRegistries.POTION.asHolderIdMap().forEach(p -> {
            if (((Potion)p.value()).getEffects().isEmpty() && !p.equals((Object)Potions.WATER)) {
                return;
            }
            ItemStack potion = LegacyItemUtil.setItemStackPotion(Items.LINGERING_POTION.getDefaultInstance(), (Holder<Potion>)p);
            ItemStack result = LegacyItemUtil.setItemStackPotion(new ItemStack((ItemLike)Items.TIPPED_ARROW, 8), (Holder<Potion>)p);
            ArrayList<Optional<Ingredient>> ings = new ArrayList<Optional<Ingredient>>();
            Optional<Ingredient> arrowOptional = Optional.of(Ingredient.of((ItemLike)Items.ARROW));
            for (int i = 0; i < 8; ++i) {
                ings.add(arrowOptional);
            }
            ings.add(4, Optional.of(StackIngredient.of((boolean)true, (ItemStack)potion)));
            ArrayList description = new ArrayList();
            recipeAdder.accept(RecipeInfo.create(TIPPED_ARROW, null, ings, result, () -> {
                description.clear();
                LegacyItemUtil.addPotionTooltip((Holder<Potion>)p, description, 0.125f, Minecraft.getInstance().level.tickRateManager().tickrate());
                return (Component)description.get(0);
            }));
        })));

        public static Filter parse(String s) {
            if (s.startsWith("#")) {
                return new ItemTag((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FactoryAPI.createLocation((String)s.replaceFirst("#", ""))));
            }
            if (s.startsWith("result_item/")) {
                return new ItemId(FactoryAPI.createLocation((String)s.replaceFirst("result_item/", "")));
            }
            return new Id(FactoryAPI.createLocation((String)s));
        }

        default public <T> void addRecipes(Iterable<RecipeInfo<T>> validRecipes, Consumer<RecipeInfo<T>> recipeAdder) {
            for (RecipeInfo<T> validRecipe : validRecipes) {
                if (!this.test(validRecipe)) continue;
                recipeAdder.accept(validRecipe);
                if (!this.onlyFirstMatch()) continue;
                return;
            }
        }

        default public boolean onlyFirstMatch() {
            return false;
        }

        public Codec<? extends Filter> codec();

        public record ItemTag(TagKey<Item> tag) implements Filter
        {
            public static final Codec<ItemTag> CODEC = TagKey.codec((ResourceKey)Registries.ITEM).xmap(ItemTag::new, ItemTag::tag);

            @Override
            public boolean test(RecipeInfo<?> h) {
                return h.getResultItem().is(this.tag);
            }

            @Override
            public Codec<? extends Filter> codec() {
                return CODEC;
            }

            @Override
            public String toString() {
                return "#" + String.valueOf(this.tag.location());
            }
        }

        public record ItemId(ResourceLocation id, boolean onlyFirstMatch) implements Filter
        {
            public static final Codec<ItemId> EXTENDED_CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ItemId::id), (App)Codec.BOOL.fieldOf("onlyFirstMatch").forGetter(ItemId::onlyFirstMatch)).apply((Applicative)i, ItemId::new));
            public static final Codec<ItemId> CODEC = IOUtil.createFallbackCodec(EXTENDED_CODEC, ResourceLocation.CODEC.xmap(ItemId::new, ItemId::id));

            public ItemId(ResourceLocation id) {
                this(id, true);
            }

            @Override
            public boolean test(RecipeInfo<?> h) {
                return BuiltInRegistries.ITEM.getKey((Object)h.getResultItem().getItem()).equals((Object)this.id);
            }

            @Override
            public Codec<? extends Filter> codec() {
                return CODEC;
            }

            @Override
            public String toString() {
                return "result_item/" + String.valueOf(this.id);
            }
        }

        public record Id(ResourceLocation id) implements Filter
        {
            public static final Codec<Id> CODEC = ResourceLocation.CODEC.xmap(Id::new, Id::id);

            @Override
            public <T> void addRecipes(Iterable<RecipeInfo<T>> validRecipes, Consumer<RecipeInfo<T>> recipeAdder) {
                Filter.super.addRecipes(validRecipes, recipeAdder);
                IdOverride value = (IdOverride)ID_RECIPE_INFO_OVERRIDES.get(this.id);
                if (value != null) {
                    value.addRecipes(validRecipes, recipeAdder);
                }
            }

            @Override
            public boolean onlyFirstMatch() {
                return true;
            }

            @Override
            public Codec<? extends Filter> codec() {
                return CODEC;
            }

            @Override
            public boolean test(RecipeInfo<?> h) {
                return h.getId().equals((Object)this.id);
            }

            @Override
            public String toString() {
                return this.id.toString();
            }
        }

        public record BlockTag(TagKey<Block> tag) implements Filter
        {
            public static final Codec<BlockTag> CODEC = TagKey.codec((ResourceKey)Registries.BLOCK).xmap(BlockTag::new, BlockTag::tag);

            @Override
            public boolean test(RecipeInfo<?> h) {
                BlockItem i;
                Item item = h.getResultItem().getItem();
                return item instanceof BlockItem && (i = (BlockItem)item).getBlock().builtInRegistryHolder().is(this.tag);
            }

            public Codec<BlockTag> codec() {
                return CODEC;
            }

            @Override
            public String toString() {
                return "#block_tag/" + String.valueOf(this.tag.location());
            }
        }

        public static interface IdOverride<T> {
            public void addRecipes(Iterable<RecipeInfo<T>> var1, Consumer<RecipeInfo<T>> var2);
        }
    }
}

