/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.controller;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.InputType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.lwjgl.glfw.GLFW;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.GLFWControllerHandler;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.controller.SDLControllerHandler;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.mixin.base.client.KeyboardHandlerAccessor;
import wily.legacy.mixin.base.client.MouseHandlerAccessor;
import wily.legacy.util.client.LegacySoundUtil;

public class ControllerManager {
    public static final ListMap<String, Controller.Handler> handlers = ListMap.builder().put((Object)"none", (Object)Controller.Handler.EMPTY).put((Object)"glfw", (Object)GLFWControllerHandler.getInstance()).put((Object)"sdl3", (Object)SDLControllerHandler.getInstance()).build();
    public static final Component CONTROLLER_DETECTED = Component.translatable((String)"legacy.controller.detected");
    public static final Component CONTROLLER_DISCONNECTED = Component.translatable((String)"legacy.controller.disconnected");
    private static final float FAST_MOVE_SPEED = 0.09f;
    private static final float MINIMUM_SPEED = 0.04f;
    private static final float DIAGONAL_SPEED = 0.4f;
    private static final float ANGLE8 = 0.7853982f;
    private static final float ANGLE16 = 0.3926991f;
    public Controller connectedController = null;
    public boolean isCursorDisabled = false;
    public boolean resetCursor = false;
    public boolean simulateShift = false;
    public boolean canChangeSlidersValue = true;
    public boolean isControllerSimulatingInput = false;
    protected Minecraft minecraft;
    protected boolean isControllerTheLastInput = false;
    private KeyMapping[] orderedKeyMappings;

    public static Controller.Handler getHandler() {
        return (Controller.Handler)LegacyOptions.selectedControllerHandler.get();
    }

    public static void updatePlayerCamera(BindingState.Axis stick, Controller controller) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!(minecraft.mouseHandler.isMouseGrabbed() && minecraft.isWindowActive() && stick.pressed && minecraft.player != null)) {
            return;
        }
        double f = Math.pow((Double)LegacyOptions.controllerSensitivity.get() * 0.6 + 0.2, 3.0) * 7.5 * (minecraft.player.isScoping() ? 0.125 : 1.0);
        minecraft.player.turn((double)ControllerManager.getCameraCurve(stick.getSmoothX()) * f, (double)ControllerManager.getCameraCurve(stick.getSmoothY()) * f * (double)((Boolean)LegacyOptions.invertYController.get() != false ? -1 : 1));
    }

    public static float getCameraCurve(float f) {
        if (((Boolean)LegacyOptions.linearCameraMovement.get()).booleanValue()) {
            return f;
        }
        return f * f * Math.signum(f);
    }

    public void setup(final Minecraft minecraft) {
        this.minecraft = minecraft;
        this.orderedKeyMappings = (KeyMapping[])minecraft.options.keyMappings.clone();
        this.updateCursorInputMode();
        CompletableFuture.runAsync(() -> new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                minecraft.execute(ControllerManager.getHandler()::init);
                if (minecraft.isRunning() && ControllerManager.getHandler().update()) {
                    ((Setup)Setup.EVENT.invoker).accept(ControllerManager.this);
                    if (!ControllerManager.getHandler().isValidController((Integer)LegacyOptions.selectedController.get())) {
                        if (ControllerManager.this.connectedController != null) {
                            ControllerManager.this.connectedController.disconnect(ControllerManager.this);
                            ControllerManager.this.safeDisconnect();
                        }
                        return;
                    }
                    if (ControllerManager.this.connectedController == null && (ControllerManager.this.connectedController = ControllerManager.getHandler().getController((Integer)LegacyOptions.selectedController.get())) != null) {
                        ControllerManager.this.connectedController.connect(ControllerManager.this);
                    }
                    minecraft.execute(() -> {
                        if (ControllerManager.this.connectedController != null) {
                            ControllerManager.getHandler().setup(ControllerManager.this);
                        }
                    });
                }
            }
        }, 0L, 1L)).exceptionally(t -> {
            Legacy4J.LOGGER.warn(t.getMessage());
            return null;
        });
    }

    public void setPointerPos(double x, double y) {
        this.setRawPointerPos(x * this.getGuiScaleX(), y * this.getGuiScaleY());
    }

    public void setRawPointerPos(double x, double y) {
        this.setRawPointerPos(x, y, this.isControllerTheLastInput() && (Boolean)LegacyOptions.controllerVirtualCursor.get() != false);
    }

    /*
     * Unable to fully structure code
     */
    public void setRawPointerPos(double x, double y, boolean onlyVirtual) {
        window = this.minecraft.getWindow();
        var8_5 = this.minecraft.screen;
        if (!(var8_5 instanceof LegacyMenuAccess)) ** GOTO lbl-1000
        a = (LegacyMenuAccess)var8_5;
        if (((Boolean)LegacyOptions.limitCursor.get()).booleanValue()) {
            rect = a.getMenuRectangleLimit();
            scaleX = this.getGuiScaleX();
            scaleY = this.getGuiScaleY();
            this.minecraft.mouseHandler.xpos = Mth.clamp((double)x, (double)((double)rect.left() * scaleX), (double)((double)rect.right() * scaleX));
            this.minecraft.mouseHandler.ypos = Mth.clamp((double)y, (double)((double)rect.top() * scaleY), (double)((double)rect.bottom() * scaleY));
        } else lbl-1000:
        // 2 sources

        {
            this.minecraft.mouseHandler.xpos = Mth.clamp((double)x, (double)0.0, (double)window.getScreenWidth());
            this.minecraft.mouseHandler.ypos = Mth.clamp((double)y, (double)0.0, (double)window.getScreenHeight());
        }
        if (!onlyVirtual) {
            GLFW.glfwSetCursorPos((long)window.handle(), (double)this.minecraft.mouseHandler.xpos, (double)this.minecraft.mouseHandler.ypos);
        }
    }

    public void safeDisconnect() {
        if (this.connectedController == null) {
            return;
        }
        this.setControllerTheLastInput(false);
        if (this.isCursorDisabled && !this.getCursorMode().isNever()) {
            this.enableCursor();
        }
        this.updateBindings(Controller.EMPTY);
        this.connectedController = null;
    }

    public void connectTo(int jid) {
        if (this.connectedController != null) {
            this.connectedController.disconnect(this);
        }
        if (ControllerManager.getHandler().isValidController(jid)) {
            Controller controller = ControllerManager.getHandler().getController(jid);
            if (controller != null) {
                this.connectedController = controller;
                controller.connect(this);
            }
        } else {
            this.safeDisconnect();
        }
    }

    public void updateHandler(Controller.Handler handler) {
        if (this.connectedController != null && this.connectedController.getHandler() != handler) {
            this.connectTo((Integer)LegacyOptions.selectedController.get());
        }
    }

    public synchronized void updateBindings() {
        this.updateBindings(this.minecraft.isWindowActive() ? this.connectedController : Controller.EMPTY);
    }

    public synchronized void updateBindings(Controller controller) {
        Arrays.sort(this.orderedKeyMappings, Comparator.comparingInt(mapping -> LegacyKeyMapping.of(mapping).getBinding() == null ? 2 : (LegacyKeyMapping.of(mapping).getBinding().isSpecial() ? 0 : 1)));
        for (ControllerBinding<?> binding : ControllerBinding.map.values()) {
            Predicate<Predicate> isStickAnd;
            ControllerBinding cursorBinding;
            PlayerInfo playerInfo;
            Object state = binding.state();
            ((BindingState)state).update(controller);
            if (LegacyTipManager.getActualTip() != null) {
                LegacyTipManager.getActualTip().bindingStateTick((BindingState)state);
            }
            if (((BindingState)state).pressed) {
                this.setControllerTheLastInput(true);
                this.minecraft.getFramerateLimitTracker().onInputReceived();
            }
            if (this.getCursorMode().isAuto() && ((BindingState)state).pressed && !this.isCursorDisabled) {
                this.tryDisableCursor();
            }
            if (this.minecraft.player != null && this.minecraft.getConnection() != null && controller.hasLED() && (playerInfo = this.minecraft.getConnection().getPlayerInfo(this.minecraft.player.getUUID())) instanceof LegacyPlayerInfo) {
                LegacyPlayerInfo i = (LegacyPlayerInfo)playerInfo;
                float[] color = Legacy4JClient.getVisualPlayerColor(i);
                controller.setLED((byte)(color[0] * 255.0f), (byte)(color[1] * 255.0f), (byte)(color[2] * 255.0f));
            }
            if (((BindingState)state).is(ControllerBinding.START) && ((BindingState)state).justPressed) {
                if (this.minecraft.screen == null) {
                    this.minecraft.pauseGame(false);
                } else if (this.minecraft.screen instanceof AbstractContainerScreen || this.minecraft.screen instanceof PauseScreen) {
                    this.minecraft.screen.onClose();
                }
            }
            if (this.minecraft.screen == null) continue;
            if (((BindingState)state).pressed && ((BindingState)state).canClick()) {
                this.minecraft.setLastInputType(InputType.KEYBOARD_ARROW);
                this.minecraft.screen.afterKeyboardAction();
            }
            Controller.Event.of(this.minecraft.screen).bindingStateTick((BindingState)state);
            if (this.minecraft.screen == null) continue;
            if (!this.isCursorDisabled) {
                LegacyMenuAccess a;
                Screen screen;
                int mouseClick;
                LegacyMenuAccess a2;
                LegacyMenuAccess m;
                Screen moveX2;
                double sensitivity = (Double)LegacyOptions.interfaceSensitivity.get() * 2.0;
                double affectY = Mth.clamp((double)((sensitivity - 0.4) * 1.67), (double)0.0, (double)1.0);
                if (((BindingState)state).is(ControllerBinding.LEFT_STICK) && state instanceof BindingState.Axis) {
                    BindingState.Axis stick = (BindingState.Axis)state;
                    if (((BindingState)state).pressed) {
                        double moveY;
                        double moveX2;
                        double moveSensitivity = (Double)LegacyOptions.interfaceSensitivity.get() * 0.5;
                        if (((Boolean)LegacyOptions.legacyCursor.get()).booleanValue()) {
                            double deadzone = stick.getDeadZone();
                            double deadzoneY = Math.max(deadzone, Mth.lerp((double)affectY, (double)1.0, (double)0.35));
                            double absX = Math.abs(stick.x);
                            double absY = Math.abs(stick.y);
                            double deltaLength = (double)Mth.length((float)stick.x, (float)stick.y) * sensitivity;
                            double angle = Math.atan2(stick.y, stick.x);
                            float snapAngle = deltaLength > (double)0.09f ? (float)Math.round(angle / (double)0.3926991f) * 0.3926991f : (float)Math.round(angle / 0.7853981852531433) * 0.7853982f;
                            double snapX = Math.cos(snapAngle) * absX;
                            double snapY = Math.sin(snapAngle) * absY;
                            double speed = Mth.lerp((double)(Math.max(Math.abs(snapX) + Math.abs(snapY) - 1.0, 0.0) * 1.41), (double)1.0, (double)0.4f);
                            double speedY = Mth.lerp((double)(affectY * absY), (double)0.5, (double)1.0);
                            double x = snapX * speed * moveSensitivity;
                            double y = snapY * speed * moveSensitivity;
                            double d = Math.min(absX, 1.0) > deadzone ? (absX < (double)0.04f ? (double)0.04f * Math.signum(x) : x) : (moveX2 = 0.0);
                            moveY = Math.min(absY, 1.0) > deadzoneY ? (absY < (double)0.04f ? (double)0.04f * Math.signum(y) : y * speedY) : 0.0;
                        } else {
                            moveX2 = (double)stick.x * moveSensitivity;
                            moveY = (double)stick.y * moveSensitivity;
                        }
                        this.setRawPointerPos(this.minecraft.mouseHandler.xpos() + moveX2 * this.getGuiScaleX(), this.minecraft.mouseHandler.ypos() + moveY * this.getGuiScaleY());
                    }
                }
                if ((moveX2 = this.minecraft.screen) instanceof LegacyMenuAccess) {
                    LegacyMenuAccess menu = (LegacyMenuAccess)moveX2;
                    if (((BindingState)state).is(ControllerBinding.LEFT_STICK) && ((BindingState)state).released) {
                        this.centerPointerOnHovered(menu);
                    }
                }
                if (((BindingState)state).is(ControllerBinding.LEFT_TRIGGER) && ((BindingState)state).justPressed && (moveX2 = this.minecraft.screen) instanceof LegacyMenuAccess && (m = (LegacyMenuAccess)moveX2).getMenu().getCarried().getCount() > 1) {
                    if (this.minecraft.screen.isDragging()) {
                        this.minecraft.screen.mouseReleased(new MouseButtonEvent(this.getPointerX(), this.getPointerY(), new MouseButtonInfo(0, 0)));
                        this.minecraft.screen.setDragging(false);
                    } else {
                        this.minecraft.screen.mouseClicked(this.getMouseEvent(0), false);
                        this.minecraft.screen.mouseDragged(this.getMouseEvent(0), 0.0, 0.0);
                        this.minecraft.screen.setDragging(true);
                    }
                }
                if (this.minecraft.screen.isDragging() && (((BindingState)state).is(ControllerBinding.LEFT_STICK) || ((BindingState)state).is(ControllerBinding.DPAD_DOWN) || ((BindingState)state).is(ControllerBinding.DPAD_LEFT) || ((BindingState)state).is(ControllerBinding.DPAD_RIGHT) || ((BindingState)state).is(ControllerBinding.DPAD_UP)) && ((BindingState)state).pressed) {
                    this.minecraft.screen.mouseDragged(this.getMouseEvent(0), 0.0, 0.0);
                }
                if (((BindingState)state).is(ControllerBinding.UP_BUTTON) && ((BindingState)state).justPressed && (moveX2 = this.minecraft.screen) instanceof LegacyMenuAccess && (a2 = (LegacyMenuAccess)moveX2).isMouseDragging()) {
                    this.minecraft.gameMode.handleInventoryMouseClick(a2.getMenu().containerId, a2.getHoveredSlot().index, 0, ClickType.QUICK_MOVE, (Player)this.minecraft.player);
                    this.minecraft.screen.mouseDragged(this.getMouseEvent(0), 0.0, 0.0);
                    LegacySoundUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
                }
                if ((mouseClick = Controller.Event.of(this.minecraft.screen).getBindingMouseClick((BindingState)state)) != -1 && (!((BindingState)state).is(ControllerBinding.LEFT_TRIGGER) || (screen = this.minecraft.screen) instanceof LegacyMenuAccess && (a = (LegacyMenuAccess)screen).isOutsideClick(mouseClick))) {
                    this.isControllerSimulatingInput = true;
                    if (((BindingState)state).pressed && ((BindingState)state).onceClick(true)) {
                        ((MouseHandlerAccessor)this.minecraft.mouseHandler).pressMouse(this.minecraft.getWindow().handle(), new MouseButtonInfo(mouseClick, 0), 1);
                    } else if (((BindingState)state).released) {
                        ((MouseHandlerAccessor)this.minecraft.mouseHandler).pressMouse(this.minecraft.getWindow().handle(), new MouseButtonInfo(mouseClick, 0), 0);
                    }
                    this.isControllerSimulatingInput = false;
                }
            }
            if ((cursorBinding = LegacyKeyMapping.of(Legacy4JClient.keyToggleCursor).getBinding()) != null && ((BindingState)state).is(cursorBinding) && ((BindingState)state).canClick()) {
                this.toggleCursor();
            }
            Controller.Event.of(this.minecraft.screen).simulateKeyAction(this, (BindingState)state);
            if (((BindingState)state).is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
                BindingState.Axis stick = (BindingState.Axis)state;
                if (Math.abs(stick.y) > Math.abs(stick.x) && ((BindingState)state).pressed && ((BindingState)state).canClick()) {
                    this.minecraft.screen.mouseScrolled(this.getPointerX(), this.getPointerY(), 0.0, (double)Math.signum(-stick.y));
                }
            }
            if ((isStickAnd = s -> {
                BindingState.Axis stick;
                return state.is(ControllerBinding.LEFT_STICK) && state instanceof BindingState.Axis && s.test(stick = (BindingState.Axis)state) && (this.isCursorDisabled && (state.pressed && state.canClick() || state.released) || (Boolean)LegacyOptions.legacyCursor.get() != false && !this.isCursorDisabled && !stick.isBlocked() && stick.getSmoothMagnitude() < 0.2f && state.timePressed == state.getDefaultDelay() / 2 && this.isHoveringWidget());
            }).test(s -> s.y < 0.0f && -s.y > Math.abs(s.x))) {
                this.simulateKeyAction(265, (BindingState)state, !((BindingState)state).released, false);
            } else if (isStickAnd.test(s -> s.y > 0.0f && s.y > Math.abs(s.x))) {
                this.simulateKeyAction(264, (BindingState)state, !((BindingState)state).released, false);
            } else if (isStickAnd.test(s -> s.x > 0.0f && s.x > Math.abs(s.y))) {
                this.simulateKeyAction(262, (BindingState)state, !((BindingState)state).released, false);
            } else if (isStickAnd.test(s -> s.x < 0.0f && -s.x > Math.abs(s.y))) {
                this.simulateKeyAction(263, (BindingState)state, !((BindingState)state).released, false);
            }
            if (((BindingState)state).is(ControllerBinding.DPAD_UP)) {
                this.simulateKeyAction(265, (BindingState)state);
                continue;
            }
            if (((BindingState)state).is(ControllerBinding.DPAD_DOWN)) {
                this.simulateKeyAction(264, (BindingState)state);
                continue;
            }
            if (((BindingState)state).is(ControllerBinding.DPAD_RIGHT)) {
                this.simulateKeyAction(262, (BindingState)state);
                continue;
            }
            if (!((BindingState)state).is(ControllerBinding.DPAD_LEFT)) continue;
            this.simulateKeyAction(263, (BindingState)state);
        }
        for (KeyMapping keyMapping : this.orderedKeyMappings) {
            Screen screen;
            if (LegacyKeyMapping.of(keyMapping).getBinding() == null) break;
            Object state = LegacyKeyMapping.of(keyMapping).getBinding().state();
            if (this.minecraft.screen != null && (!((screen = this.minecraft.screen) instanceof PauseScreen) || ((PauseScreen)screen).showsPauseMenu())) continue;
            if (((BindingState)state).is(ControllerBinding.START) && ((BindingState)state).pressed) {
                keyMapping.setDown(false);
                continue;
            }
            if (((BindingState)state).canClick()) {
                ++keyMapping.clickCount;
            }
            if (((BindingState)state).pressed && ((BindingState)state).canDownKeyMapping(keyMapping)) {
                keyMapping.setDown(true);
            } else if (((BindingState)state).canReleaseKeyMapping(keyMapping)) {
                keyMapping.setDown(false);
            }
            if (!((BindingState)state).pressed) continue;
            if (((BindingState)state).canBlock(keyMapping)) {
                ((BindingState)state).block();
                continue;
            }
            if (keyMapping != this.minecraft.options.keyAttack) continue;
            ((BindingState)state).onceClick(-((BindingState)state).getDefaultDelay() * (this.minecraft.player.getAbilities().invulnerable ? 3 : 5));
        }
        ControllerBinding binding = LegacyKeyMapping.of(this.minecraft.options.keyScreenshot).getBinding();
        if (binding != null && ((BindingState)binding.state()).justPressed) {
            Screenshot.grab((File)this.minecraft.gameDirectory, (RenderTarget)this.minecraft.getMainRenderTarget(), component -> this.minecraft.execute(() -> this.minecraft.gui.getChat().addMessage(component)));
        }
        if (this.minecraft.screen != null) {
            Controller.Event.of(this.minecraft.screen).controllerTick(controller);
        }
        if (LegacyTipManager.getActualTip() != null) {
            LegacyTipManager.getActualTip().controllerTick(controller);
        }
    }

    public boolean isHoveringWidget() {
        LegacyMenuAccess menu;
        Screen screen = this.minecraft.screen;
        return screen instanceof LegacyMenuAccess && (menu = (LegacyMenuAccess)screen).findHoveredSlot() != null || this.minecraft.screen.getChildAt(this.getPointerX(), this.getPointerY()).isPresent();
    }

    public void centerPointerOnHovered(LegacyMenuAccess<?> menu) {
        if (!menu.movePointerToSlot(menu.findHoveredSlot())) {
            this.minecraft.screen.getChildAt(this.getPointerX(), this.getPointerY()).ifPresent(listener -> ComponentPath.path((GuiEventListener)listener, (ContainerEventHandler[])new ContainerEventHandler[]{this.minecraft.screen}).applyFocus(true));
        }
    }

    public void simulateKeyAction(Predicate<BindingState> canSimulate, int key, BindingState state) {
        this.simulateKeyAction(canSimulate, key, state, false);
    }

    public void simulateKeyAction(Predicate<BindingState> canSimulate, int key, BindingState state, boolean onlyScreen) {
        boolean clicked;
        boolean bl = clicked = state.pressed && state.canClick();
        if (canSimulate.test(state) && (!Controller.Event.of(this.minecraft.screen).onceClickBindings(state) || state.onceClick(true))) {
            this.simulateKeyAction(key, state, clicked, onlyScreen);
        }
    }

    public void simulateKeyAction(int key, BindingState state) {
        this.simulateKeyAction(key, state, false);
    }

    public void simulateKeyAction(int key, BindingState state, boolean onlyScreen) {
        this.simulateKeyAction(key, state, state.pressed && state.canClick(), onlyScreen);
    }

    public void simulateKeyAction(int key, BindingState state, boolean canPress, boolean onlyScreen) {
        if (canPress) {
            this.simulateKeyAction(key, true, onlyScreen);
        } else if (state.released) {
            this.simulateKeyAction(key, false, onlyScreen);
        }
    }

    public void simulateKeyAction(int key, boolean press, boolean onlyScreen) {
        this.isControllerSimulatingInput = true;
        if (onlyScreen) {
            this.simulateScreenKeyAction(key, press);
        } else {
            ((KeyboardHandlerAccessor)this.minecraft.keyboardHandler).invokeKeyPress(this.minecraft.getWindow().handle(), press ? 1 : 0, new KeyEvent(key, 0, 0));
        }
        this.isControllerSimulatingInput = false;
    }

    public void simulateScreenKeyAction(int key, boolean press) {
        if (press) {
            this.minecraft.screen.keyPressed(new KeyEvent(key, 0, 0));
        } else {
            this.minecraft.screen.keyReleased(new KeyEvent(key, 0, 0));
        }
    }

    public double getGuiScaleX() {
        return (double)this.minecraft.getWindow().getScreenWidth() / (double)this.minecraft.getWindow().getGuiScaledWidth();
    }

    public double getGuiScaleY() {
        return (double)this.minecraft.getWindow().getScreenHeight() / (double)this.minecraft.getWindow().getGuiScaledHeight();
    }

    public double getPointerX() {
        return this.minecraft.mouseHandler.xpos() / this.getGuiScaleX();
    }

    public double getPointerY() {
        return this.minecraft.mouseHandler.ypos() / this.getGuiScaleY();
    }

    protected MouseButtonEvent getMouseEvent(int button) {
        return new MouseButtonEvent(this.getPointerX(), this.getPointerY(), new MouseButtonInfo(button, 0));
    }

    public ScreenRectangle getPointerRectangle() {
        return new ScreenRectangle(Math.round(this.getVisualPointerX() - 4.0f), Math.round(this.getVisualPointerY() - 4.0f), 8, 8);
    }

    public float getVisualPointerX() {
        return (float)Math.round(this.minecraft.mouseHandler.xpos()) / (float)Math.round((float)this.minecraft.getWindow().getScreenWidth() / (float)this.minecraft.getWindow().getGuiScaledWidth());
    }

    public float getVisualPointerY() {
        return (float)Math.round(this.minecraft.mouseHandler.ypos()) / (float)Math.round((float)this.minecraft.getWindow().getScreenHeight() / (float)this.minecraft.getWindow().getGuiScaledHeight());
    }

    public <T extends BindingState> T getButtonState(ControllerBinding<T> button) {
        return button.state();
    }

    public boolean allowCursorAtFirstInventorySlot() {
        return this.isControllerTheLastInput() && (Boolean)LegacyOptions.controllerCursorAtFirstInventorySlot.get() != false || !this.isControllerTheLastInput() && (Boolean)LegacyOptions.cursorAtFirstInventorySlot.get() != false;
    }

    public void tryDisableCursor() {
        Controller.Event e;
        Screen screen;
        if (this.getCursorMode().isAlways() || this.minecraft.screen == null || (screen = this.minecraft.screen) instanceof Controller.Event && !(e = (Controller.Event)screen).disableCursorOnInit()) {
            return;
        }
        this.disableCursor();
    }

    public void disableCursor() {
        this.setCursorInputMode(true);
        this.isCursorDisabled = true;
    }

    public void resetCursor() {
        Object object;
        if (!this.resetCursor || this.isCursorDisabled) {
            return;
        }
        if (this.allowCursorAtFirstInventorySlot() && (object = this.minecraft.screen) instanceof LegacyMenuAccess) {
            LegacyMenuAccess a = (LegacyMenuAccess)object;
            for (Slot slot : a.getMenu().slots) {
                if (slot.getContainerSlot() != 0 || this.minecraft.player != null && slot.container != this.minecraft.player.getInventory()) continue;
                a.movePointerToSlot(slot);
                break;
            }
        }
        this.resetCursor = false;
    }

    public void enableCursorAndScheduleReset() {
        this.enableCursor();
        this.resetCursor = true;
    }

    public void enableCursor() {
        this.isCursorDisabled = false;
        this.updateCursorInputMode();
    }

    public void toggleCursor() {
        this.setCursorMode(LegacyOptions.CursorMode.values()[Stocker.cyclic((int)0, (int)(this.getCursorMode().ordinal() + 1), (int)LegacyOptions.CursorMode.values().length)]);
        this.updateCursorMode();
    }

    public void updateCursorMode() {
        switch (this.getCursorMode()) {
            case ALWAYS: {
                this.enableCursor();
                break;
            }
            case NEVER: {
                this.tryDisableCursor();
                if (this.minecraft.screen == null) break;
                this.minecraft.screen.repositionElements();
            }
        }
    }

    public LegacyOptions.CursorMode getCursorMode() {
        return (LegacyOptions.CursorMode)((Object)LegacyOptions.cursorMode.get());
    }

    public void setCursorMode(LegacyOptions.CursorMode cursorMode) {
        LegacyOptions.cursorMode.set((Object)cursorMode);
        LegacyOptions.cursorMode.save();
    }

    public boolean isControllerTheLastInput() {
        return this.isControllerTheLastInput;
    }

    public void setControllerTheLastInput(boolean controllerTheLastInput) {
        if (this.isControllerTheLastInput != controllerTheLastInput) {
            this.isControllerTheLastInput = controllerTheLastInput;
            this.updateCursorInputMode();
        }
    }

    public void setCursorInputMode(boolean hidden) {
        GLFW.glfwSetInputMode((long)Minecraft.getInstance().getWindow().handle(), (int)208897, (int)(hidden ? 212994 : 212993));
    }

    public void updateCursorInputMode() {
        if (!this.minecraft.mouseHandler.isMouseGrabbed()) {
            this.setCursorInputMode(!LegacyOptions.hasSystemCursor());
        }
    }

    static interface Setup
    extends Consumer<ControllerManager> {
        public static final FactoryEvent<Setup> EVENT = new FactoryEvent(e -> m -> e.invokeAll(l -> l.accept(m)));
    }
}

