/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.realmsclient.RealmsMainScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.LegacyLoadingScreen;

public class ExitConfirmationScreen
extends ConfirmationScreen {
    public ExitConfirmationScreen(Screen parent) {
        super(parent, ConfirmationScreen::getPanelWidth, () -> ExitConfirmationScreen.getBaseHeight() + (LegacySaveCache.hasSaveSystem(Minecraft.getInstance()) ? (LegacyOptions.getUIMode().isSD() ? 19 : 33) : 0), (Component)Component.translatable((String)"menu.quit"), (Component)(Minecraft.getInstance().hasSingleplayerServer() && (Integer)LegacyOptions.autoSaveInterval.get() == 0 ? Component.translatable((String)"legacy.menu.exit_message") : (Minecraft.getInstance().screen instanceof TitleScreen ? Component.translatable((String)"legacy.menu.gameExitMessage") : Component.translatable((String)"legacy.menu.server_exit_message"))), b -> {});
    }

    public static void exit(Minecraft minecraft, boolean save) {
        if (minecraft.getConnection() == null) {
            minecraft.stop();
            return;
        }
        if (save) {
            LegacySaveCache.retakeWorldIcon = true;
            LegacySaveCache.saveExit = true;
        }
        if (minecraft.level != null) {
            minecraft.level.disconnect(ClientLevel.DEFAULT_QUIT_MESSAGE);
        }
        minecraft.disconnect((Screen)new LegacyLoadingScreen((Component)Component.translatable((String)(save ? "menu.savingLevel" : "disconnect.quitting")), (Component)Component.empty()), false);
        ServerData serverData = minecraft.getCurrentServer();
        TitleScreen mainMenuScreen = new TitleScreen();
        if (serverData != null && serverData.isRealm()) {
            minecraft.setScreen((Screen)new RealmsMainScreen((Screen)mainMenuScreen));
        } else {
            minecraft.setScreen((Screen)mainMenuScreen);
        }
    }

    @Override
    protected void addButtons() {
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).build());
        if (LegacySaveCache.hasSaveSystem(this.minecraft)) {
            this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.exit_and_save"), b -> ExitConfirmationScreen.exit(this.minecraft, true)).build());
            this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.exit_without_save"), b -> this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)this, (Component)Component.translatable((String)"legacy.menu.exit_without_save_title"), (Component)Component.translatable((String)"legacy.menu.exit_without_save_message"), b1 -> ExitConfirmationScreen.exit(this.minecraft, false)))).build());
        } else {
            this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"menu.quit"), b -> ExitConfirmationScreen.exit(this.minecraft, this.minecraft.hasSingleplayerServer() && (this.minecraft.getSingleplayerServer().isHardcore() || !LegacySaveCache.isCurrentWorldSource(this.minecraft.getSingleplayerServer().storageSource)))).build());
        }
    }
}

