/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.material.Fluids;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.client.CommonColor;
import wily.legacy.client.screen.ItemViewerScreen;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.Panel;
import wily.legacy.util.LegacySprites;

public class FlatWorldLayerSelector
extends ItemViewerScreen {
    protected final LegacySliderButton<Integer> layerSlider;
    private final Consumer<FlatWorldLayerSelector> applyLayer;
    protected Block selectedLayer = Blocks.AIR;
    protected ItemStack displayLayer = ItemStack.EMPTY;

    public FlatWorldLayerSelector(Screen parent, Consumer<FlatWorldLayerSelector> applyLayer, int maxLayerHeight, Component component) {
        super(parent, s -> Panel.centered(s, 325, 245), component);
        this.applyLayer = applyLayer;
        this.layerSlider = LegacySliderButton.createFromIntRange(this.panel.x + 21, this.panel.y + 167, 271, 16, b -> Component.translatable((String)"legacy.menu.create_flat_world.layer_height"), b -> null, (Integer)1, 1, maxLayerHeight, b -> {});
    }

    public FlatWorldLayerSelector(Screen parent, FlatLayerInfo editLayer, Consumer<FlatWorldLayerSelector> applyLayer, int maxLayerHeight, Component component) {
        this(parent, applyLayer, maxLayerHeight, component);
        this.selectedLayer = editLayer.getBlockState().getBlock();
        this.displayLayer = editLayer.getBlockState().getBlock().asItem().getDefaultInstance();
        this.layerSlider.setObjectValue(editLayer.getHeight());
    }

    @Override
    protected void addLayerItems() {
        BuiltInRegistries.FLUID.stream().filter(f -> f.getBucket() != null && (f == Fluids.EMPTY || f.isSource(f.defaultFluidState()))).forEach(f -> {
            Item i = f.defaultFluidState().createLegacyBlock().getBlock().asItem();
            if (i instanceof BlockItem) {
                this.layerItems.add(i.getDefaultInstance());
            } else {
                this.layerItems.add(f.getBucket().getDefaultInstance());
            }
        });
        BuiltInRegistries.BLOCK.forEach(b -> {
            if (b instanceof LiquidBlock) {
                return;
            }
            Item i = Item.BY_BLOCK.getOrDefault(b, null);
            if (i != null) {
                this.layerItems.add(i.getDefaultInstance());
            }
        });
    }

    public FlatLayerInfo getFlatLayerInfo() {
        return new FlatLayerInfo(this.layerSlider.getObjectValue().intValue(), this.selectedLayer);
    }

    @Override
    protected void init() {
        super.init();
        this.layerSlider.setPosition(this.panel.x + 21, this.panel.y + 167);
        this.addRenderableWidget((GuiEventListener)this.layerSlider);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.ok"), b -> {
            this.applyLayer.accept(this);
            this.onClose();
        }).bounds(this.panel.x + 57, this.panel.y + 216, 200, 20).build());
    }

    @Override
    protected void slotClicked(Slot slot) {
        Block block;
        this.displayLayer = slot.getItem();
        Item item = slot.getItem().getItem();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            block = item2.getBlock();
        } else {
            item = slot.getItem().getItem();
            if (item instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item;
                block = ItemContainerPlatform.getBucketFluid((BucketItem)bucket).defaultFluidState().createLegacyBlock().getBlock();
            } else {
                block = Blocks.AIR;
            }
        }
        this.selectedLayer = block;
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderDefaultBackground(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 20, this.panel.y + 187, 275, 27);
        guiGraphics.drawString(this.font, this.title, this.panel.x + (this.panel.width - this.font.width((FormattedText)this.title)) / 2, this.panel.y + 8, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        MutableComponent layerCount = Component.translatable((String)"legacy.menu.create_flat_world.layer_count", (Object[])new Object[]{this.layerSlider.getObjectValue()});
        guiGraphics.drawString(this.font, (Component)layerCount, this.panel.x + 49 - this.font.width((FormattedText)layerCount), this.panel.y + 197, -1, true);
        guiGraphics.drawString(this.font, (Component)this.selectedLayer.getName(), this.panel.x + 70, this.panel.y + 197, -1, true);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)(this.panel.x + 50), (float)(this.panel.y + 190));
        guiGraphics.pose().scale(1.25f, 1.25f);
        guiGraphics.renderItem(this.displayLayer, 0, 0);
        guiGraphics.pose().popMatrix();
    }
}

