/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyResourceManager;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.OverlayPanelScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public class KeyboardScreen
extends OverlayPanelScreen {
    public static final Component KEYBOARD = Component.translatable((String)"legacy.menu.keyboard");
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    protected final KeyButton shiftButton;
    protected final KeyButton upButton;
    protected final KeyButton downButton;
    protected final KeyButton rightButton;
    protected final KeyButton leftButton;
    protected final KeyButton backspaceButton;
    protected final KeyButton confirmButton;
    private final Supplier<GuiEventListener> listenerSupplier;
    public boolean shift = false;
    protected RenderableVList renderableVList = new RenderableVList(this.accessor).layoutSpacing(l -> 1);
    protected RenderableVList leftKeyBar = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
    protected RenderableVList rightKeyBar = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
    protected boolean shiftLock = false;
    protected int lastX = 0;
    protected int lastY = 0;
    protected int xDiff = 0;
    protected int yDiff = 0;

    public KeyboardScreen(Supplier<GuiEventListener> listener, Screen parent) {
        this(60, listener, parent);
    }

    public KeyboardScreen(int yOffset, Supplier<GuiEventListener> listener, Screen parent) {
        this((Screen s, Panel p) -> p.centeredLeftPos((Screen)s), (s, p) -> Math.min(p.centeredTopPos((Screen)s) + yOffset, s.height - p.height), listener, parent);
    }

    public KeyboardScreen(BiFunction<Screen, Panel, Integer> leftPosGetter, BiFunction<Screen, Panel, Integer> topPosGetter, Supplier<GuiEventListener> listener, Screen parent) {
        this((Screen s) -> Panel.createPanel(s, p -> p.appearance(LegacySprites.PANEL, 385, 154), p -> p.pos((Integer)leftPosGetter.apply((Screen)s, (Panel)((Object)p)), (Integer)topPosGetter.apply((Screen)s, (Panel)((Object)p)))), listener, parent);
    }

    public KeyboardScreen(Function<Screen, Panel> panelConstructor, Supplier<GuiEventListener> listener, Screen parent) {
        super(parent, panelConstructor, CommonComponents.EMPTY);
        this.listenerSupplier = listener;
        this.renderableVList.forceWidth = false;
        this.darkBackground = false;
        LegacyResourceManager.keyboardButtonBuilders.forEach(b -> this.renderableVList.addRenderable((Renderable)b.build(this)));
        this.leftButton = new KeyButton(263, this.listenerSupplier, ControllerBinding.LEFT_BUMPER, LegacySprites.SCROLL_LEFT);
        this.leftKeyBar.addRenderable((Renderable)this.leftButton);
        this.rightButton = new KeyButton(262, this.listenerSupplier, ControllerBinding.RIGHT_BUMPER, LegacySprites.SCROLL_RIGHT);
        this.rightKeyBar.addRenderable((Renderable)this.rightButton);
        this.upButton = new KeyButton(265, 20, this.listenerSupplier, null, LegacySprites.SCROLL_UP);
        this.leftKeyBar.addRenderable((Renderable)this.upButton);
        this.downButton = new KeyButton(264, 20, this.listenerSupplier, null, LegacySprites.SCROLL_DOWN);
        this.leftKeyBar.addRenderable((Renderable)this.downButton);
        this.shiftButton = new KeyButton(340, this.listenerSupplier, LegacyResourceManager.shiftBinding, LegacySprites.SHIFT){
            long lastRelease;

            @Override
            public boolean playSoundOnClick() {
                return this.pressTime == 0 && !KeyboardScreen.this.shiftLock;
            }

            @Override
            public void onRelease() {
                long millis = Util.getMillis();
                if (!KeyboardScreen.this.shiftLock) {
                    if (this.pressTime >= 6 || millis - this.lastRelease <= 300L) {
                        LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SHIFT_LOCK.get(), 1.0f);
                        KeyboardScreen.this.shiftLock = true;
                    }
                    KeyboardScreen.this.shift = !KeyboardScreen.this.shift || KeyboardScreen.this.shiftLock;
                } else {
                    KeyboardScreen.this.shiftLock = false;
                    LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SHIFT_UNLOCK.get(), 1.0f);
                }
                this.lastRelease = millis;
                super.onRelease();
            }

            @Override
            public ResourceLocation getSprite() {
                return KeyboardScreen.this.shiftLock ? LegacySprites.BUTTON_SLOT_SELECTED : super.getSprite();
            }
        };
        this.leftKeyBar.addRenderable((Renderable)this.shiftButton);
        this.backspaceButton = new KeyButton(this, 259, this.listenerSupplier, ControllerBinding.LEFT_BUTTON, LegacySprites.BACK){

            @Override
            public SoundEvent getDownSoundEvent() {
                return (SoundEvent)LegacyRegistries.BACKSPACE.get();
            }
        };
        this.rightKeyBar.addRenderable((Renderable)this.backspaceButton);
        this.confirmButton = new KeyButton(257, this.listenerSupplier, ControllerBinding.START, LegacySprites.TICK){

            @Override
            public void onPress(InputWithModifiers input) {
                KeyboardScreen.this.onClose();
            }
        };
        this.rightKeyBar.addRenderable((Renderable)this.confirmButton);
    }

    public static boolean isOpenKey(int i) {
        return i == 335 && !Legacy4JClient.controllerManager.isControllerTheLastInput() || i == 257 && Legacy4JClient.controllerManager.isControllerTheLastInput();
    }

    public static KeyboardScreen fromStaticListener(GuiEventListener listener, Screen parent) {
        KeyboardScreen keyboardScreen;
        if (listener instanceof LayoutElement) {
            LayoutElement e = (LayoutElement)listener;
            keyboardScreen = new KeyboardScreen((s, p) -> Math.max(0, Math.min(e.getX() + (e.getWidth() - p.width) / 2, s.width - p.width)), (s, p) -> Math.max(0, Math.min(s.height - (e.getY() + e.getHeight()) >= p.height ? e.getY() + e.getHeight() + 4 : e.getY() - p.getHeight() - 4, s.height - p.height)), () -> listener, parent);
        } else {
            keyboardScreen = new KeyboardScreen(() -> listener, parent);
        }
        return keyboardScreen;
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(0) : ControllerBinding.RIGHT_STICK.getIcon(), () -> LegacyComponents.MOVE_KEYBOARD);
    }

    @Override
    protected void init() {
        Renderable renderable;
        this.panel.init();
        this.lastX = this.panel.getX();
        this.lastY = this.panel.getY();
        this.panel.setPosition(this.lastX + this.xDiff, this.lastY + this.yDiff);
        this.renderableVList.init(this.panel.getX() + (this.panel.getWidth() - 259) / 2, this.panel.getY() + 28, 268, 124);
        this.leftKeyBar.init(this.panel.getX() + 6, this.panel.getY() + 27, 50, 0);
        this.rightKeyBar.init(this.panel.getX() + this.panel.getWidth() - 56, this.panel.getY() + 27, 50, 0);
        if (this.getFocused() == null && !this.renderableVList.renderables.isEmpty() && (renderable = this.renderableVList.renderables.get(0)) instanceof GuiEventListener) {
            GuiEventListener l = (GuiEventListener)renderable;
            this.setFocused(l);
        }
    }

    public void resize(Minecraft minecraft, int i, int j) {
        this.onClose();
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof CharButton) {
            CharButton c = (CharButton)guiEventListener;
            c.renderTooltip(guiGraphics, i, j, f);
        }
    }

    public boolean charTyped(CharacterEvent characterEvent) {
        for (Renderable renderable : this.renderableVList.renderables) {
            CharButton b;
            if (!(renderable instanceof CharButton) || !(b = (CharButton)renderable).matches(characterEvent)) continue;
            if (b.isFocused()) {
                b.onRelease();
                break;
            }
            this.setFocused((GuiEventListener)b);
            break;
        }
        return super.charTyped(characterEvent);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.key() == 259) {
            if (this.backspaceButton.isFocused()) {
                this.backspaceButton.onPress((InputWithModifiers)keyEvent);
            } else {
                this.setFocused((GuiEventListener)this.backspaceButton);
            }
            return true;
        }
        if (this.renderableVList.keyPressed(keyEvent.key())) {
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double d, double e) {
        if ((d != 0.0 || e != 0.0) && mouseButtonEvent.button() == 0 && LegacyRenderUtil.isMouseOver(mouseButtonEvent.x(), mouseButtonEvent.y(), this.panel.getX(), this.panel.getY(), this.panel.getWidth(), this.panel.getHeight())) {
            this.xDiff = Math.max(0, Math.min(this.panel.getX() + Math.round((float)d), this.width - this.panel.getWidth())) - this.lastX;
            this.yDiff = Math.max(0, Math.min(this.panel.getY() + Math.round((float)e), this.height - this.panel.getHeight())) - this.lastY;
            this.repositionElements();
        }
        return super.mouseDragged(mouseButtonEvent, d, e);
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderDefaultBackground(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, 0.8f);
        this.panel.render(guiGraphics, i, j, f);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.panel.getX() + 4.5f, (float)this.panel.getY() + 25.4f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, 0, 0, 53, 123);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.panel.getWidth() - 62, 0, 53, 123);
        guiGraphics.pose().translate(-4.5f, 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, (this.panel.getWidth() - 267) / 2, -1, 267, 125);
        guiGraphics.pose().popMatrix();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearBlitColor();
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.panel.getX() + ((float)this.panel.getWidth() - (float)this.font.width((FormattedText)KEYBOARD) * 1.5f) / 2.0f, (float)(this.panel.getY() + 8));
        guiGraphics.pose().scale(1.5f, 1.5f);
        guiGraphics.drawString(this.font, KEYBOARD, 0, 0, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.pose().popMatrix();
    }

    @Override
    public void bindingStateTick(BindingState state) {
        this.children().forEach(r -> {
            if (r instanceof ActionButton) {
                ActionButton a = (ActionButton)((Object)r);
                if (state.is(a.binding)) {
                    if (state.canClick()) {
                        a.playDownSound(this.minecraft.getSoundManager());
                        a.onPress((InputWithModifiers)new KeyEvent(257, 0, 0));
                    } else if (state.released) {
                        a.onRelease();
                    }
                }
            }
        });
        if (state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
            BindingState.Axis a = (BindingState.Axis)state;
            if (state.canClick(20)) {
                if (state.canClick()) {
                    LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SCROLL.get(), 1.0f);
                }
                this.xDiff = Math.max(0, Math.min(this.panel.getX() + Math.round(a.x * 4.0f), this.width - this.panel.getWidth())) - this.lastX;
                this.yDiff = Math.max(0, Math.min(this.panel.getY() + Math.round(a.y * 4.0f), this.height - this.panel.getHeight())) - this.lastY;
                this.repositionElements();
            }
        }
    }

    @Override
    public boolean onceClickBindings(BindingState b) {
        return false;
    }

    public static class KeyButton
    extends ActionButton {
        public final int key;
        private final Supplier<GuiEventListener> keyListener;

        public KeyButton(int key, Supplier<GuiEventListener> keyListener, ControllerBinding binding, ResourceLocation iconSprite) {
            this(key, 40, keyListener, binding, iconSprite);
        }

        public KeyButton(int key, int height, Supplier<GuiEventListener> keyListener, ControllerBinding binding, ResourceLocation iconSprite) {
            super(50, height, CommonComponents.EMPTY, binding, iconSprite);
            this.key = key;
            this.keyListener = keyListener;
        }

        @Override
        public boolean playSoundOnClick() {
            return true;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.getSprite(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            FactoryScreenUtil.enableBlend();
            this.renderString(guiGraphics, Minecraft.getInstance().font, LegacyRenderUtil.getDefaultTextColor(!this.isHoveredOrFocused()));
            FactoryScreenUtil.disableBlend();
        }

        public ResourceLocation getSprite() {
            return this.isHoveredOrFocused() ? LegacySprites.BUTTON_SLOT_HIGHLIGHTED : LegacySprites.BUTTON_SLOT;
        }

        @Override
        public void onPress(InputWithModifiers input) {
            super.onPress(input);
            GuiEventListener l = this.keyListener.get();
            if (l != null) {
                l.setFocused(true);
                l.keyPressed(new KeyEvent(this.key, 0, 0));
            }
        }
    }

    public class CharButton
    extends ActionButton {
        private final String chars;
        private final String shiftChars;
        private final SoundEvent downSound;
        private int selectedChar;

        public CharButton(int width, String chars, String shiftChars, ControllerBinding binding, ResourceLocation iconSprite, SoundEvent downSound) {
            super(width, 20, CommonComponents.EMPTY, binding, iconSprite);
            this.selectedChar = 0;
            this.chars = chars;
            this.shiftChars = shiftChars;
            this.downSound = downSound;
        }

        public static boolean hasShiftDown() {
            return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)340) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)344);
        }

        public boolean matches(CharacterEvent characterEvent) {
            return this.chars.contains(characterEvent.codepointAsString()) || this.shiftChars != null && this.shiftChars.contains(characterEvent.codepointAsString());
        }

        public void renderTooltip(GuiGraphics guiGraphics, int i, int j, float f) {
            if (this.pressTime >= 6 && this.getSelectedChars().length() > 1) {
                int width = 18;
                char[] chars = this.getSelectedChars().toCharArray();
                for (int i1 = 0; i1 < chars.length; ++i1) {
                    String s = String.valueOf(chars[i1]);
                    width += KeyboardScreen.this.font.width(s) + (i1 == 0 ? 0 : 2);
                }
                int diffX = 0;
                LegacyRenderUtil.renderPointerPanel(guiGraphics, this.getX() + (this.getWidth() - width) / 2, this.getY() - 17, width, 15);
                for (char c : chars) {
                    String s = String.valueOf(c);
                    guiGraphics.drawString(KeyboardScreen.this.font, s, this.getX() + (this.getWidth() - width) / 2 + diffX + 9, this.getY() - 14, c == this.getSelectedChar() ? -256 : -1);
                    diffX += KeyboardScreen.this.font.width(s) + 2;
                }
                KeyboardScreen.this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.getX() + (this.getWidth() - width) / 2 + 2, this.getY() - 15);
                KeyboardScreen.this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.getX() + (this.getWidth() - width) / 2 + width - 9, this.getY() - 15);
            }
        }

        @Override
        public SoundEvent getDownSoundEvent() {
            return this.downSound == null ? super.getDownSoundEvent() : this.downSound;
        }

        public boolean keyPressed(KeyEvent keyEvent) {
            if ((keyEvent.isLeft() || keyEvent.isRight()) && this.pressTime >= 6) {
                this.selectedChar = Stocker.cyclic((int)0, (int)(this.selectedChar + (keyEvent.isRight() ? 1 : -1)), (int)this.getSelectedChars().length());
                return true;
            }
            return super.keyPressed(keyEvent);
        }

        public void setFocused(boolean bl) {
            super.setFocused(bl);
            if (!bl && this.pressTime > 0) {
                this.onRelease();
            }
        }

        @Override
        public void onRelease() {
            GuiEventListener l = KeyboardScreen.this.listenerSupplier.get();
            if (l != null) {
                KeyboardScreen.this.parent.setFocused(l);
                l.charTyped(new CharacterEvent((int)this.getSelectedChar(), 0));
            }
            if (this.shiftChars != null && KeyboardScreen.this.shift && !KeyboardScreen.this.shiftLock) {
                KeyboardScreen.this.shift = false;
            }
            this.selectedChar = 0;
            super.onRelease();
        }

        public char getSelectedChar() {
            String characters;
            return characters.charAt((characters = this.getSelectedChars()).length() > this.selectedChar ? this.selectedChar : 0);
        }

        public String getSelectedChars() {
            return this.shiftChars != null && (CharButton.hasShiftDown() || KeyboardScreen.this.shift) ? this.shiftChars : this.chars;
        }

        public Component getMessage() {
            return Component.literal((String)String.valueOf(this.getSelectedChar()));
        }
    }

    public static abstract class ActionButton
    extends AbstractButton {
        public final ControllerBinding binding;
        private final ResourceLocation iconSprite;
        public int pressTime = 0;

        public ActionButton(int k, int l, Component component, ControllerBinding binding, ResourceLocation iconSprite) {
            super(0, 0, k, l, component);
            this.binding = binding;
            this.iconSprite = iconSprite;
        }

        public void onRelease() {
            this.pressTime = 0;
        }

        public void onPress(InputWithModifiers input) {
            ++this.pressTime;
        }

        public void playDownSound(SoundManager soundManager) {
            if (this.playSoundOnClick()) {
                LegacySoundUtil.playSimpleUISound(this.getDownSoundEvent(), 1.0f);
            }
        }

        public boolean playSoundOnClick() {
            return this.pressTime == 0;
        }

        public SoundEvent getDownSoundEvent() {
            return (SoundEvent)LegacyRegistries.ACTION.get();
        }

        public void onRelease(MouseButtonEvent event) {
            if (this.pressTime > 0) {
                this.onRelease();
            }
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
            return super.nextFocusPath(focusNavigationEvent);
        }

        public boolean keyReleased(KeyEvent keyEvent) {
            if (this.active && this.visible && keyEvent.isSelection() && this.pressTime > 0) {
                this.onRelease();
                return true;
            }
            return false;
        }

        protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
            int bindingOffset = 0;
            if (this.binding != null && Legacy4JClient.controllerManager.connectedController != null) {
                bindingOffset = this.binding.getIcon().render(guiGraphics, this.getX() + i, this.getY() + (this.getHeight() - 9) / 2 + 1, true);
            }
            if (this.iconSprite == null) {
                ActionButton.renderScrollingString((GuiGraphics)guiGraphics, (Font)font, (Component)this.getMessage(), (int)(this.getX() + i + bindingOffset), (int)this.getY(), (int)(this.getX() + this.getWidth() - i), (int)(this.getY() + this.getHeight()), (int)j);
            } else {
                TextureAtlasSprite sprite = FactoryGuiGraphics.getSprites().texturesByName.getOrDefault(this.iconSprite, null);
                if (sprite == null) {
                    return;
                }
                try (SpriteContents contents = sprite.contents();){
                    FactoryScreenUtil.enableBlend();
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.iconSprite, this.getX() + (this.getWidth() - contents.width()) / 2 + Math.max(0, i + bindingOffset - (this.getWidth() - contents.width()) / 2), this.getY() + (this.getHeight() - contents.height()) / 2, contents.width(), contents.height());
                    FactoryScreenUtil.disableBlend();
                }
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }

    public record CharButtonBuilder(int width, String chars, String shiftChars, ControllerBinding binding, ResourceLocation iconSprite, SoundEvent downSound) {
        public CharButton build(KeyboardScreen screen) {
            KeyboardScreen keyboardScreen = screen;
            Objects.requireNonNull(keyboardScreen);
            return keyboardScreen.new CharButton(this.width, this.chars, this.shiftChars, this.binding, this.iconSprite, this.downSound);
        }
    }
}

