/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.NoticeWithLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.validation.ContentValidationException;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.SaveOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.client.LegacyRenderUtil;

public class SaveRenderableList
extends RenderableVList {
    static final ResourceLocation ERROR_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/error_highlighted");
    static final ResourceLocation ERROR = FactoryAPI.createVanillaLocation((String)"world_list/error");
    static final ResourceLocation MARKED_JOIN_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/marked_join_highlighted");
    static final ResourceLocation MARKED_JOIN = FactoryAPI.createVanillaLocation((String)"world_list/marked_join");
    static final ResourceLocation WARNING_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/warning_highlighted");
    static final ResourceLocation WARNING = FactoryAPI.createVanillaLocation((String)"world_list/warning");
    static final ResourceLocation JOIN_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/join_highlighted");
    static final ResourceLocation JOIN = FactoryAPI.createVanillaLocation((String)"world_list/join");
    static final Logger LOGGER = LogUtils.getLogger();
    static final Component FROM_NEWER_TOOLTIP_1 = Component.translatable((String)"selectWorld.tooltip.fromNewerVersion1").withStyle(ChatFormatting.RED);
    static final Component FROM_NEWER_TOOLTIP_2 = Component.translatable((String)"selectWorld.tooltip.fromNewerVersion2").withStyle(ChatFormatting.RED);
    static final Component SNAPSHOT_TOOLTIP_1 = Component.translatable((String)"selectWorld.tooltip.snapshot1").withStyle(ChatFormatting.GOLD);
    static final Component SNAPSHOT_TOOLTIP_2 = Component.translatable((String)"selectWorld.tooltip.snapshot2").withStyle(ChatFormatting.GOLD);
    static final Component WORLD_LOCKED_TOOLTIP = Component.translatable((String)"selectWorld.locked").withStyle(ChatFormatting.RED);
    static final Component WORLD_REQUIRES_CONVERSION = Component.translatable((String)"selectWorld.conversion.tooltip").withStyle(ChatFormatting.RED);
    static final Component WORLD_EXPERIMENTAL = Component.translatable((String)"selectWorld.experimental");
    static final Component INCOMPATIBLE_VERSION_TOOLTIP = Component.translatable((String)"selectWorld.incompatible.tooltip").withStyle(ChatFormatting.RED);
    public static LoadingCache<LevelSummary, Long> sizeCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<LevelSummary, Long>(){

        public Long load(LevelSummary key) {
            return FileUtils.sizeOfDirectory((File)Minecraft.getInstance().getLevelSource().getBaseDir().resolve(key.getLevelId()).toFile());
        }
    });
    public static LoadingCache<LevelSummary, FaviconTexture> iconCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<LevelSummary, FaviconTexture>(){

        public FaviconTexture load(LevelSummary key) {
            boolean bl;
            Path iconFile = key.getIcon();
            try {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(iconFile, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                if (basicFileAttributes.isSymbolicLink()) {
                    List list = Minecraft.getInstance().directoryValidator().validateSymlink(iconFile);
                    if (!list.isEmpty()) {
                        Legacy4J.LOGGER.warn("{}", (Object)ContentValidationException.getMessage((Path)iconFile, (List)list));
                        iconFile = null;
                    } else {
                        basicFileAttributes = Files.readAttributes(iconFile, BasicFileAttributes.class, new LinkOption[0]);
                    }
                }
                if (!basicFileAttributes.isRegularFile()) {
                    iconFile = null;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                iconFile = null;
            }
            catch (IOException iOException) {
                Legacy4J.LOGGER.error("could not validate symlink", (Throwable)iOException);
                iconFile = null;
            }
            FaviconTexture icon = FaviconTexture.forWorld((TextureManager)Minecraft.getInstance().getTextureManager(), (String)key.getLevelId());
            boolean bl2 = bl = iconFile != null && Files.isRegularFile(iconFile, new LinkOption[0]);
            if (bl) {
                try (InputStream inputStream = Files.newInputStream(iconFile, new OpenOption[0]);){
                    icon.upload(NativeImage.read((InputStream)inputStream));
                }
                catch (Throwable throwable) {
                    Legacy4J.LOGGER.error("Invalid icon for world {}", (Object)key.getLevelId(), (Object)throwable);
                }
            } else {
                icon.clear();
            }
            return icon;
        }
    });
    @Nullable
    public List<LevelSummary> currentlyDisplayedLevels;
    public boolean firstLoad = true;
    protected Minecraft minecraft;
    private CompletableFuture<List<LevelSummary>> pendingLevels;
    private String filter;

    public SaveRenderableList(UIAccessor accessor) {
        super(accessor);
        this.layoutSpacing(l -> 0);
        this.minecraft = Minecraft.getInstance();
        this.filter = "";
        this.reloadSaveList();
    }

    public static void resetIconCache() {
        iconCache.asMap().forEach((s, i) -> i.close());
        iconCache.invalidateAll();
    }

    public static void handleLevelLoadFailure(Minecraft minecraft, Component component) {
        minecraft.setScreen((Screen)new ConfirmationScreen((Screen)new TitleScreen(), (Component)Component.translatable((String)"selectWorld.futureworld.error.title"), component, b -> {}){

            @Override
            protected void addButtons() {
                this.okButton = Button.builder((Component)Component.translatable((String)"gui.ok"), b -> this.onClose()).bounds(this.panel.x + 15, this.panel.y + this.panel.height - 30, 200, 20).build();
                this.renderableVList.addRenderable((Renderable)this.okButton);
            }
        });
    }

    @Nullable
    public List<LevelSummary> pollLevelsIgnoreErrors() {
        try {
            return this.pendingLevels.getNow(null);
        }
        catch (CancellationException | CompletionException runtimeException) {
            return null;
        }
    }

    void reloadSaveList() {
        this.pendingLevels = this.loadLevels();
    }

    public void updateFilter(String string) {
        if (this.currentlyDisplayedLevels != null && !string.equals(this.filter)) {
            this.fillLevels(string, this.currentlyDisplayedLevels);
        }
        this.filter = string;
    }

    private CompletableFuture<List<LevelSummary>> loadLevels() {
        LevelStorageSource.LevelCandidates levelCandidates;
        try {
            levelCandidates = this.minecraft.getLevelSource().findLevelCandidates();
        }
        catch (LevelStorageException levelStorageException) {
            Legacy4J.LOGGER.error("Couldn't load level list", (Throwable)levelStorageException);
            SaveRenderableList.handleLevelLoadFailure(this.minecraft, levelStorageException.getMessageComponent());
            return CompletableFuture.completedFuture(List.of());
        }
        if (levelCandidates.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (this.currentlyDisplayedLevels == null || this.currentlyDisplayedLevels.isEmpty()) {
            this.getScreen(PlayGameScreen.class).isLoading = true;
        }
        CompletableFuture completableFuture = this.minecraft.getLevelSource().loadLevelSummaries(levelCandidates);
        completableFuture.thenAcceptAsync(l -> l.forEach(s -> sizeCache.refresh(s)));
        return completableFuture.exceptionally(throwable -> {
            this.minecraft.delayCrash(CrashReport.forThrowable((Throwable)throwable, (String)"Couldn't load level list"));
            return List.of();
        });
    }

    public void addCreationButtons() {
        if (!this.accessor.getBoolean("hasTabList", Boolean.valueOf(true)).booleanValue()) {
            this.getScreen(PlayGameScreen.class).creationList.renderables.forEach(this::addRenderable);
        }
    }

    public void fillLevels(String filter, List<LevelSummary> list) {
        this.getScreen(PlayGameScreen.class).isLoading = false;
        this.renderables.clear();
        this.addCreationButtons();
        if (list != null) {
            filter = filter.toLowerCase(Locale.ROOT);
            for (LevelSummary summary : list) {
                if (!this.filterAccepts(filter, summary)) continue;
                this.addRenderable((Renderable)new SaveButton(0, 0, 270, 30, summary));
            }
        }
        this.currentlyDisplayedLevels = list;
        this.getScreen().triggerImmediateNarration(true);
    }

    @Override
    public void init(String name, int leftPos, int topPos, int listWidth, int listHeight) {
        if (this.firstLoad) {
            this.addCreationButtons();
            this.firstLoad = false;
        }
        super.init(name, leftPos, topPos, listWidth, listHeight);
    }

    private boolean filterAccepts(String string, LevelSummary levelSummary) {
        return levelSummary.getLevelName().toLowerCase(Locale.ROOT).contains(string) || levelSummary.getLevelId().toLowerCase(Locale.ROOT).contains(string);
    }

    public LevelSummary getLevelSummary(int saveButtonIndex) {
        if (this.currentlyDisplayedLevels != null && this.renderables.get(saveButtonIndex) instanceof AbstractButton && saveButtonIndex < this.currentlyDisplayedLevels.size()) {
            return this.currentlyDisplayedLevels.get(saveButtonIndex);
        }
        return null;
    }

    public void joinWorld(LevelSummary summary) {
        if (summary.primaryActionActive()) {
            if (summary instanceof LevelSummary.SymlinkLevelSummary) {
                this.minecraft.setScreen(NoticeWithLinkScreen.createWorldSymlinkWarningScreen(() -> this.minecraft.setScreen(this.getScreen())));
            } else {
                this.loadWorld(summary);
            }
        }
    }

    public void loadWorld(LevelSummary summary) {
        this.reloadSaveList();
        if (((Boolean)LegacyOptions.directSaveLoad.get()).booleanValue()) {
            LegacySaveCache.copySaveBtwSources(LoadSaveScreen.getSummaryAccess(Minecraft.getInstance().getLevelSource(), summary), LegacySaveCache.getLevelStorageSource());
            LoadSaveScreen.loadWorld(this.getScreen(), this.minecraft, LegacySaveCache.getLevelStorageSource(), summary);
        } else {
            this.minecraft.setScreen((Screen)new LoadSaveScreen(this, this.getScreen(), summary, LegacySaveCache.getLevelStorageSource()){

                @Override
                public void completeLoad() {
                    if (((Boolean)LegacyOptions.saveCache.get()).booleanValue()) {
                        LegacySaveCache.copySaveBtwSources(LoadSaveScreen.getSummaryAccess(Minecraft.getInstance().getLevelSource(), this.summary), LegacySaveCache.currentWorldSource);
                    }
                    super.completeLoad();
                }
            });
        }
    }

    public void deleteSave(LevelSummary summary) {
        LevelStorageSource levelStorageSource = this.minecraft.getLevelSource();
        String string = summary.getLevelId();
        try (LevelStorageSource.LevelStorageAccess levelStorageAccess = levelStorageSource.createAccess(string);){
            levelStorageAccess.deleteLevel();
        }
        catch (IOException iOException) {
            SystemToast.onWorldDeleteFailure((Minecraft)this.minecraft, (String)string);
            LOGGER.error("Failed to delete world {}", (Object)string, (Object)iOException);
        }
        this.reloadSaveList();
        this.minecraft.setScreen(this.getScreen());
    }

    public class SaveButton
    extends CreationList.ContentButton
    implements ControlTooltip.ActionHolder {
        public final LevelSummary summary;

        public SaveButton(int i, int j, int k, int l, LevelSummary summary) {
            super(SaveRenderableList.this, i, j, k, l, (Component)Component.literal((String)summary.getLevelName()));
            this.summary = summary;
        }

        public void onPress(InputWithModifiers input) {
            SaveRenderableList.this.joinWorld(this.summary);
        }

        public void onClick(MouseButtonEvent event, boolean bl) {
            if (this.summary.isDisabled()) {
                return;
            }
            boolean hoverIcon = LegacyRenderUtil.isMouseOver(event.x(), event.y(), this.getX() + 5, this.getY() + 5, 20, this.height);
            if (hoverIcon || this.isFocused()) {
                this.onPress((InputWithModifiers)event);
            }
        }

        public boolean keyPressed(KeyEvent keyEvent) {
            if (keyEvent.key() == 79) {
                SaveRenderableList.this.minecraft.setScreen((Screen)new SaveOptionsScreen(SaveRenderableList.this.getScreen(PlayGameScreen.class), this.summary));
                SaveRenderableList.this.getScreen().setFocused((GuiEventListener)this);
                return true;
            }
            return super.keyPressed(keyEvent);
        }

        protected MutableComponent createNarrationMessage() {
            MutableComponent component = Component.translatable((String)"narrator.select.world_info", (Object[])new Object[]{this.summary.getLevelName(), new Date(this.summary.getLastPlayed()).toString(), this.summary.getInfo()});
            if (this.summary.isLocked()) {
                component = CommonComponents.joinForNarration((Component[])new Component[]{component, WORLD_LOCKED_TOOLTIP});
            }
            if (this.summary.isExperimental()) {
                component = CommonComponents.joinForNarration((Component[])new Component[]{component, WORLD_EXPERIMENTAL});
            }
            return Component.translatable((String)"narrator.select", (Object[])new Object[]{component});
        }

        @Override
        public void renderIcon(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(((FaviconTexture)iconCache.getUnchecked((Object)this.summary)).textureLocation(), this.getX() + x, this.getY() + y, 0.0f, 0.0f, width, height, width, height);
        }

        @Override
        public void renderIconHighlight(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
            ResourceLocation resourceLocation4;
            super.renderIconHighlight(guiGraphics, mouseX, mouseY, x, y, width, height);
            boolean hoverIcon = LegacyRenderUtil.isMouseOver(mouseX, mouseY, this.getX() + x, this.getY() + y, width, height);
            ResourceLocation resourceLocation = hoverIcon ? JOIN_HIGHLIGHTED : JOIN;
            ResourceLocation resourceLocation2 = hoverIcon ? WARNING_HIGHLIGHTED : WARNING;
            ResourceLocation resourceLocation3 = hoverIcon ? ERROR_HIGHLIGHTED : ERROR;
            ResourceLocation resourceLocation5 = resourceLocation4 = hoverIcon ? MARKED_JOIN_HIGHLIGHTED : MARKED_JOIN;
            if (this.summary instanceof LevelSummary.SymlinkLevelSummary || this.summary instanceof LevelSummary.CorruptedLevelSummary) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation3, this.getX() + x, this.getY() + y, width, height);
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation4, this.getX() + x, this.getY() + y, width, height);
                return;
            }
            if (this.summary.isLocked()) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation3, this.getX() + x, this.getY() + y, width, height);
                if (hoverIcon) {
                    guiGraphics.setTooltipForNextFrame(SaveRenderableList.this.minecraft.font, SaveRenderableList.this.minecraft.font.split((FormattedText)WORLD_LOCKED_TOOLTIP, 175), mouseX, mouseY);
                }
            } else if (this.summary.requiresManualConversion()) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation3, this.getX() + x, this.getY() + y, width, height);
                if (hoverIcon) {
                    guiGraphics.setTooltipForNextFrame(SaveRenderableList.this.minecraft.font, SaveRenderableList.this.minecraft.font.split((FormattedText)WORLD_REQUIRES_CONVERSION, 175), mouseX, mouseY);
                }
            } else if (!this.summary.isCompatible()) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation3, this.getX() + x, this.getY() + y, width, height);
                if (hoverIcon) {
                    guiGraphics.setTooltipForNextFrame(SaveRenderableList.this.minecraft.font, SaveRenderableList.this.minecraft.font.split((FormattedText)INCOMPATIBLE_VERSION_TOOLTIP, 175), mouseX, mouseY);
                }
            } else if (this.summary.shouldBackup()) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation4, this.getX() + x, this.getY() + y, width, height);
                if (this.summary.isDowngrade()) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation3, this.getX() + x, this.getY() + y, width, height);
                    if (hoverIcon) {
                        guiGraphics.setTooltipForNextFrame(SaveRenderableList.this.minecraft.font, (List)ImmutableList.of((Object)FROM_NEWER_TOOLTIP_1.getVisualOrderText(), (Object)FROM_NEWER_TOOLTIP_2.getVisualOrderText()), mouseX, mouseY);
                    }
                } else if (!SharedConstants.getCurrentVersion().stable()) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation2, this.getX() + x, this.getY() + y, width, height);
                    if (hoverIcon) {
                        guiGraphics.setTooltipForNextFrame(SaveRenderableList.this.minecraft.font, (List)ImmutableList.of((Object)SNAPSHOT_TOOLTIP_1.getVisualOrderText(), (Object)SNAPSHOT_TOOLTIP_2.getVisualOrderText()), mouseX, mouseY);
                    }
                }
            } else {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation, this.getX() + x, this.getY() + y, width, height);
            }
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 79 && this.isFocused() ? LegacyComponents.SAVE_OPTIONS : ControlTooltip.getSelectAction((GuiEventListener)this, c));
        }
    }
}

