/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import wily.legacy.inventory.LegacyMerchantOffer;

@Mixin(value={MerchantContainer.class})
public class MerchantContainerMixin {
    @Shadow
    @Final
    private Merchant merchant;

    private int getActualMerchantLevel() {
        int n;
        if (this.merchant.isClientSide()) {
            AbstractContainerMenu abstractContainerMenu = this.merchant.getTradingPlayer().containerMenu;
            if (abstractContainerMenu instanceof MerchantMenu) {
                MerchantMenu menu = (MerchantMenu)abstractContainerMenu;
                n = menu.getTraderLevel();
            } else {
                n = 0;
            }
        } else {
            Merchant merchant = this.merchant;
            if (merchant instanceof VillagerDataHolder) {
                VillagerDataHolder data = (VillagerDataHolder)merchant;
                n = data.getVillagerData().level();
            } else {
                n = 0;
            }
        }
        return n;
    }

    @Redirect(method={"updateSellItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/trading/MerchantOffers;getRecipeFor(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;I)Lnet/minecraft/world/item/trading/MerchantOffer;"))
    public MerchantOffer updateSellItem(MerchantOffers instance, ItemStack itemStack, ItemStack itemStack2, int i) {
        MerchantOffer offer = instance.getRecipeFor(itemStack, itemStack2, i);
        if (offer instanceof LegacyMerchantOffer) {
            LegacyMerchantOffer o = (LegacyMerchantOffer)offer;
            if (this.getActualMerchantLevel() > 0 && o.getRequiredLevel() > this.getActualMerchantLevel()) {
                offer = null;
            }
        }
        return offer;
    }
}

