/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.inventory.LegacyMerchantOffer;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    public VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract VillagerData getVillagerData();

    @Redirect(method={"increaseMerchantCareer"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;updateTrades()V"))
    private void increaseMerchantCareer(Villager instance) {
        if (this.getLevel() < 5) {
            this.updateTrades(this.getLevel() + 1);
        }
    }

    @Unique
    private int getLevel() {
        return this.getVillagerData().level();
    }

    public Villager self() {
        return (Villager)this;
    }

    public MerchantOffers getOffers() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
            this.updateTrades(this.getLevel() + 1);
        }
        return this.offers;
    }

    @Inject(method={"updateTrades"}, at={@At(value="HEAD")}, cancellable=true)
    public void updateTrades(CallbackInfo ci) {
        ci.cancel();
        this.updateTrades(this.getLevel());
    }

    protected void updateTrades(int level) {
        Object[] itemListings;
        Int2ObjectMap int2ObjectMap;
        Int2ObjectMap int2ObjectMap2;
        VillagerData villagerData = this.getVillagerData();
        ResourceKey profession = villagerData.profession().unwrapKey().orElse(null);
        Int2ObjectMap int2ObjectMap3 = int2ObjectMap2 = this.level().enabledFeatures().contains(FeatureFlags.TRADE_REBALANCE) ? (int2ObjectMap = (Int2ObjectMap)VillagerTrades.EXPERIMENTAL_TRADES.get(profession)) : (Int2ObjectMap)VillagerTrades.TRADES.get(profession);
        if (int2ObjectMap2 == null || int2ObjectMap2.isEmpty() || (itemListings = (VillagerTrades.ItemListing[])int2ObjectMap2.get(level)) == null) {
            return;
        }
        ArrayList arrayList = Lists.newArrayList((Object[])itemListings);
        int j = 0;
        while (j < 2 && !arrayList.isEmpty()) {
            MerchantOffer merchantOffer = ((VillagerTrades.ItemListing)arrayList.remove(this.self().getRandom().nextInt(arrayList.size()))).getOffer((Entity)this.self(), this.self().getRandom());
            if (merchantOffer == null) continue;
            ((LegacyMerchantOffer)merchantOffer).setRequiredLevel(level);
            this.self().getOffers().add((Object)merchantOffer);
            ++j;
        }
    }
}

