/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.cauldron;

import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyTags;

@Mixin(value={LayeredCauldronBlock.class})
public abstract class LayeredCauldronBlockMixin
extends AbstractCauldronBlock
implements EntityBlock {
    public LayeredCauldronBlockMixin(BlockBehaviour.Properties properties, CauldronInteraction.InteractionMap interactionMap) {
        super(properties, interactionMap);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (!blockState.is(LegacyTags.WATER_CAULDRONS)) {
            return;
        }
        level.getBlockEntity(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get()).ifPresent(be -> {
            if (be.potion == null || be.hasWater()) {
                return;
            }
            ((Potion)be.potion.value()).getEffects().forEach(m -> {
                if (level.random.nextInt(4) == 0) {
                    level.addParticle(m.getParticleOptions(), (2.0 * level.random.nextDouble() - 1.0) / 4.0 + (double)blockPos.getX(), level.random.nextDouble() + (double)blockPos.getY(), (2.0 * level.random.nextDouble() - 1.0) / 4.0 + (double)blockPos.getZ(), 1.0, 1.0, 1.0);
                }
            });
        });
    }

    @Inject(method={"handlePrecipitation"}, at={@At(value="HEAD")}, cancellable=true)
    public void handlePrecipitation(BlockState blockState, Level level, BlockPos blockPos, Biome.Precipitation precipitation, CallbackInfo ci) {
        if (LegacyRegistries.isInvalidCauldron(blockState, level, blockPos)) {
            ci.cancel();
        }
    }

    @Inject(method={"receiveStalactiteDrip"}, at={@At(value="HEAD")}, cancellable=true)
    public void receiveStalactiteDrip(BlockState blockState, Level level, BlockPos blockPos, Fluid fluid, CallbackInfo ci) {
        if (LegacyRegistries.isInvalidCauldron(blockState, level, blockPos)) {
            ci.cancel();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return blockState.is(LegacyTags.WATER_CAULDRONS) ? new WaterCauldronBlockEntity(blockPos, blockState) : null;
    }
}

