/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArrowModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.FireworkEntityRenderer;
import net.minecraft.client.renderer.entity.state.ArrowRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.FireworkRocketRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryRenderStateExtension;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyFireworkRenderState;
import wily.legacy.client.LegacyOptions;

@Mixin(value={FireworkEntityRenderer.class})
public abstract class FireworkEntityRendererMixin
extends EntityRenderer<FireworkRocketEntity, FireworkRocketRenderState> {
    private static final ResourceLocation FIREWORK_LOCATION = Legacy4J.createModLocation("textures/entity/projectiles/firework.png");
    @Unique
    private ArrowModel model;

    protected FireworkEntityRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(EntityRendererProvider.Context context, CallbackInfo ci) {
        this.model = new ArrowModel(context.bakeLayer(ModelLayers.ARROW));
    }

    @Inject(method={"submit(Lnet/minecraft/client/renderer/entity/state/FireworkRocketRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void submit(FireworkRocketRenderState fireworkRocketRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, CallbackInfo ci) {
        if (((Boolean)LegacyOptions.legacyFireworks.get()).booleanValue()) {
            ci.cancel();
            LegacyFireworkRenderState renderState = (LegacyFireworkRenderState)FactoryRenderStateExtension.Accessor.of((EntityRenderState)fireworkRocketRenderState).getExtension(LegacyFireworkRenderState.class);
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot - 90.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(renderState.xRot));
            submitNodeCollector.submitModel((Model)this.model, (Object)new ArrowRenderState(), poseStack, RenderType.entityCutout((ResourceLocation)FIREWORK_LOCATION), fireworkRocketRenderState.lightCoords, OverlayTexture.NO_OVERLAY, fireworkRocketRenderState.outlineColor, null);
            poseStack.popPose();
            super.submit((EntityRenderState)fireworkRocketRenderState, poseStack, submitNodeCollector, cameraRenderState);
        }
    }
}

