/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.mojang.datafixers.DataFixer;
import java.net.Proxy;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;

@Mixin(value={IntegratedServer.class})
public abstract class IntegratedServerMixin
extends MinecraftServer {
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private boolean paused;

    public IntegratedServerMixin(Thread thread, LevelStorageSource.LevelStorageAccess levelStorageAccess, PackRepository packRepository, WorldStem worldStem, Proxy proxy, DataFixer dataFixer, Services services, LevelLoadListener levelLoadListener) {
        super(thread, levelStorageAccess, packRepository, worldStem, proxy, dataFixer, services, levelLoadListener);
    }

    public IntegratedServer self() {
        return (IntegratedServer)this;
    }

    @Inject(method={"tickServer"}, at={@At(value="HEAD")})
    public void tickServer(BooleanSupplier booleanSupplier, CallbackInfo ci) {
        if (LegacySaveCache.manualSave) {
            LegacySaveCache.manualSave = false;
            FactoryAPIClient.getProfiler().push("manualSave");
            LOGGER.info("Saving manually...");
            this.saveEverything(false, true, true);
            FactoryAPIClient.getProfiler().pop();
        }
    }

    @Redirect(method={"tickServer"}, at=@At(value="FIELD", target="Lnet/minecraft/client/server/IntegratedServer;paused:Z", opcode=180, ordinal=1))
    public boolean tickServer(IntegratedServer instance) {
        return this.paused && (Boolean)LegacyOptions.autoSaveWhenPaused.get() != false && ((Integer)LegacyOptions.autoSaveInterval.get() > 0 || !LegacySaveCache.isCurrentWorldSource(this.storageSource)) && !this.minecraft.isDemo();
    }

    public boolean isUnderSpawnProtection(ServerLevel serverLevel, BlockPos blockPos, Player player) {
        if (!this.isSingleplayerOwner(player.nameAndId()) && !LegacyClientWorldSettings.of(this.worldData).trustPlayers()) {
            return true;
        }
        return super.isUnderSpawnProtection(serverLevel, blockPos, player);
    }
}

