/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.LegacyLoading;
import wily.legacy.mixin.base.client.LevelLoadingScreenAccessor;
import wily.legacy.util.LegacyComponents;

@Mixin(value={LevelLoadingScreen.class, ProgressScreen.class, ConnectScreen.class})
public class LegacyLoadingScreenMixin
extends Screen
implements LegacyLoading {
    protected LegacyLoadingScreenMixin(Component component) {
        super(component);
    }

    @Unique
    private Screen self() {
        return this;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        if (((Boolean)LegacyOptions.legacyLoadingAndConnecting.get()).booleanValue()) {
            ProgressScreen p;
            ci.cancel();
            Component lastLoadingHeader = null;
            Component lastLoadingStage = null;
            boolean genericLoading = false;
            float progress = 0.0f;
            Screen screen = this.self();
            if (screen instanceof LevelLoadingScreen) {
                LevelLoadingScreen loading = (LevelLoadingScreen)screen;
                lastLoadingHeader = LegacyComponents.INITIALIZING;
                lastLoadingStage = LegacyComponents.LOADING_SPAWN_AREA;
                progress = ((LevelLoadingScreenAccessor)loading).getSmoothedProgress();
            }
            if ((screen = this.self()) instanceof ProgressScreen) {
                p = (ProgressScreen)screen;
                lastLoadingHeader = p.header;
                lastLoadingStage = p.stage;
                if (this.minecraft.level != null && this.minecraft.level.dimension() != Level.OVERWORLD) {
                    genericLoading = true;
                }
            }
            if ((screen = this.self()) instanceof ConnectScreen) {
                p = (ConnectScreen)screen;
                lastLoadingHeader = p.status;
            }
            Legacy4JClient.legacyLoadingScreen.prepareRender(this.minecraft, this.width, this.height, lastLoadingHeader, lastLoadingStage, progress, genericLoading);
            Legacy4JClient.legacyLoadingScreen.render(guiGraphics, i, j, f);
        }
    }

    @Override
    public float getProgress() {
        return Legacy4JClient.legacyLoadingScreen.getProgress();
    }

    @Override
    public void setProgress(float progress) {
        Legacy4JClient.legacyLoadingScreen.setProgress(progress);
    }

    @Override
    public Component getLoadingHeader() {
        return Legacy4JClient.legacyLoadingScreen.getLoadingHeader();
    }

    @Override
    public void setLoadingHeader(Component loadingHeader) {
        Legacy4JClient.legacyLoadingScreen.setLoadingHeader(loadingHeader);
    }

    @Override
    public Component getLoadingStage() {
        return Legacy4JClient.legacyLoadingScreen.getLoadingStage();
    }

    @Override
    public void setLoadingStage(Component loadingStage) {
        Legacy4JClient.legacyLoadingScreen.setLoadingStage(loadingStage);
    }

    @Override
    public boolean isGenericLoading() {
        return Legacy4JClient.legacyLoadingScreen.isGenericLoading();
    }

    @Override
    public void setGenericLoading(boolean genericLoading) {
        Legacy4JClient.legacyLoadingScreen.setGenericLoading(genericLoading);
    }
}

