/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.audio.Channel;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.sounds.SoundSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import wily.legacy.client.LegacyMusicFader;
import wily.legacy.client.SoundEngineAccessor;

@Mixin(value={SoundEngine.class})
public abstract class SoundEngineMixin
implements SoundEngineAccessor {
    @Shadow
    private boolean loaded;
    @Shadow
    @Final
    private Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel;
    @Shadow
    @Final
    private Map<SoundInstance, Integer> queuedSounds;
    @Shadow
    @Final
    private List<TickableSoundInstance> tickingSounds;
    @Shadow
    @Final
    private Multimap<SoundSource, SoundInstance> instanceBySource;
    @Shadow
    @Final
    private Map<SoundInstance, Integer> soundDeleteTime;
    @Shadow
    @Final
    private List<TickableSoundInstance> queuedTickableSounds;

    @Shadow
    protected abstract float calculateVolume(SoundInstance var1);

    @Override
    public void stopAllSound() {
        if (this.loaded) {
            Predicate<SoundInstance> isNotMusic = soundInstance -> soundInstance.getSource() != SoundSource.MUSIC && soundInstance.getSource() != SoundSource.RECORDS;
            this.instanceToChannel.forEach((soundInstance, channelHandle) -> {
                if (isNotMusic.test((SoundInstance)soundInstance)) {
                    channelHandle.execute(Channel::stop);
                }
            });
            this.instanceToChannel.keySet().removeIf(isNotMusic);
            this.instanceBySource.values().removeIf(isNotMusic);
            this.soundDeleteTime.keySet().removeIf(isNotMusic);
            this.queuedSounds.clear();
            this.tickingSounds.clear();
            this.queuedTickableSounds.clear();
        }
    }

    @Override
    public void setVolume(SoundInstance soundInstance, float volume) {
        ChannelAccess.ChannelHandle channelHandle = this.instanceToChannel.get(soundInstance);
        if (channelHandle != null) {
            channelHandle.execute(channel -> channel.setVolume(volume * this.calculateVolume(soundInstance)));
        }
    }

    @Override
    public void fadeAllMusic() {
        this.instanceToChannel.keySet().forEach(soundInstance -> {
            if (soundInstance.getSource() == SoundSource.MUSIC || soundInstance.getSource() == SoundSource.RECORDS) {
                LegacyMusicFader.fadeOutMusic(soundInstance, true, true);
            }
        });
    }
}

