/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.crafting;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;

@Mixin(value={CraftingScreen.class})
public abstract class CraftingScreenMixin
extends AbstractContainerScreen<CraftingMenu> {
    public CraftingScreenMixin(CraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        final boolean sd = LegacyOptions.getUIMode().isSD();
        this.imageWidth = sd ? 130 : 215;
        this.imageHeight = sd ? 140 : 202;
        this.inventoryLabelX = sd ? 7 : 14;
        this.inventoryLabelY = sd ? 66 : 90;
        LegacyFontUtil.applySDFont(b -> {
            this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        });
        this.titleLabelY = sd ? 5 : 11;
        final int slotsSize = sd ? 13 : 21;
        LegacySlotDisplay defaultDisplay = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return slotsSize;
            }
        };
        super.init();
        int slotsAmount = ((CraftingMenu)this.menu).getGridHeight() * ((CraftingMenu)this.menu).getGridWidth();
        for (int i = 0; i < ((CraftingMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((CraftingMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, sd ? 90 : 150, sd ? 28 : 39, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return sd ? 21 : 32;
                    }
                });
                continue;
            }
            if (i < slotsAmount + 1) {
                LegacySlotDisplay.override(s, (sd ? 19 : 34) + s.getContainerSlot() % 3 * slotsSize, (sd ? 18 : 23) + s.getContainerSlot() / 3 * slotsSize, defaultDisplay);
                continue;
            }
            if (i < ((CraftingMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, this.inventoryLabelX + (s.getContainerSlot() - 9) % 9 * slotsSize, (sd ? 76 : 102) + (s.getContainerSlot() - 9) / 9 * slotsSize, defaultDisplay);
                continue;
            }
            LegacySlotDisplay.override(s, this.inventoryLabelX + s.getContainerSlot() * slotsSize, sd ? 120 : 171, defaultDisplay);
        }
    }

    @Inject(method={"getRecipeBookButtonPosition"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getRecipeBookButtonPosition(CallbackInfoReturnable<ScreenPosition> cir) {
        cir.setReturnValue((Object)new ScreenPosition(this.leftPos + (LegacyOptions.getUIMode().isSD() ? 63 : 9), this.topPos + (LegacyOptions.getUIMode().isSD() ? 48 : 44)));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LegacyFontUtil.applySDFont(b -> super.renderLabels(guiGraphics, i, j));
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        boolean sd = LegacyOptions.getUIMode().isSD();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(UIAccessor.of((Screen)this).getResourceLocation("imageSprite", sd ? LegacySprites.PANEL : LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        if (sd) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_ARROW, this.leftPos + 65, this.topPos + 31, 16, 13);
        } else {
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)(this.leftPos + 105), (float)(this.topPos + 43));
            guiGraphics.pose().scale(1.5f, 1.5f);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, 0, 0, 22, 16);
            guiGraphics.pose().popMatrix();
        }
    }
}

