/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.title;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import java.io.IOException;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.SplashRenderer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ChooseUserScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.ExitConfirmationScreen;
import wily.legacy.client.screen.HelpAndOptionsScreen;
import wily.legacy.client.screen.Legacy4JSettingsScreen;
import wily.legacy.client.screen.LegacyLanguageScreen;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.ModsScreen;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.client.screen.PublishScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.compat.WorldHostFriendsScreen;

@Mixin(value={TitleScreen.class})
public abstract class TitleScreenMixin
extends Screen
implements ControlTooltip.Event,
RenderableVList.Access {
    @Shadow
    @Nullable
    private SplashRenderer splash;
    @Unique
    private final RenderableVList renderableVList = new RenderableVList(this).layoutSpacing(l -> LegacyOptions.getUIMode().isSD() ? 4 : 5);

    protected TitleScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"<init>(ZLnet/minecraft/client/gui/components/LogoRenderer;)V"}, at={@At(value="RETURN")})
    public void init(boolean bl, LogoRenderer logoRenderer, CallbackInfo ci) {
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.play_game"), button -> {
            if (this.minecraft.isDemo()) {
                try {
                    LoadSaveScreen.loadWorld((Screen)this, this.minecraft, LegacySaveCache.getLevelStorageSource(), LegacySaveCache.importSaveFile(this.minecraft.getResourceManager().getResourceOrThrow(Legacy4J.createModLocation("tutorial/tutorial.mcsave")).open(), LegacySaveCache.getLevelStorageSource(), "Tutorial"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.minecraft.setScreen(PlayGameScreen.createAndCheckNewerVersions(this));
            }
        }).build());
        Button modButton = Button.builder((Component)Component.translatable((String)"legacy.menu.mods"), b -> this.minecraft.setScreen((Screen)new ModsScreen(this))).build();
        this.renderableVList.addRenderable((Renderable)modButton);
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"options.language"), b -> this.minecraft.setScreen((Screen)new LegacyLanguageScreen((Screen)this, this.minecraft.getLanguageManager()))).build());
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"menu.options"), b -> this.minecraft.setScreen((Screen)new HelpAndOptionsScreen(this))).build());
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"menu.quit"), button -> this.minecraft.setScreen((Screen)new ExitConfirmationScreen(this))).build());
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    protected void init(CallbackInfo ci) {
        ci.cancel();
        super.init();
        this.renderableVListInit();
    }

    @Override
    public RenderableVList getRenderableVList() {
        return this.renderableVList;
    }

    @Override
    public void renderableVListInit() {
        this.initRenderableVListHeight(20);
        this.getRenderableVList().init(this.width / 2 - 112, this.height / 3 + 5, 225, 0);
    }

    @Inject(method={"added"}, at={@At(value="RETURN")})
    public void added(CallbackInfo ci) {
        ControlTooltip.Renderer.of(this).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> ChooseUserScreen.CHOOSE_USER);
        if (PublishScreen.hasWorldHost()) {
            ControlTooltip.Renderer.of(this).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon(), () -> WorldHostFriendsScreen.FRIENDS);
        }
        if (this.splash == null) {
            this.splash = Minecraft.getInstance().getSplashManager().getSplash();
        }
    }

    @Inject(method={"removed"}, at={@At(value="RETURN")})
    public void removed(CallbackInfo ci) {
        this.splash = null;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.renderableVList.keyPressed(keyEvent.key())) {
            return true;
        }
        if (keyEvent.key() == 88) {
            this.minecraft.setScreen((Screen)new ChooseUserScreen(this));
            return true;
        }
        if (keyEvent.key() == 79 && PublishScreen.hasWorldHost()) {
            this.minecraft.setScreen((Screen)new WorldHostFriendsScreen(this));
            return true;
        }
        if (Legacy4JClient.keyLegacy4JSettings.matches(keyEvent)) {
            this.minecraft.setScreen((Screen)new Legacy4JSettingsScreen(this));
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/internal/BrandingControl;forEachLine(ZZLjava/util/function/BiConsumer;)V", remap=false)})
    public boolean wrapVersionText(boolean includeMC, boolean reverse, BiConsumer<Integer, String> lineConsumerr) {
        return (Boolean)LegacyOptions.titleScreenVersionText.get();
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/internal/BrandingControl;forEachAboveCopyrightLine(Ljava/util/function/BiConsumer;)V", remap=false)})
    public boolean wrapBrandingOverCopyright(BiConsumer<Integer, String> lineConsumer) {
        return (Boolean)LegacyOptions.titleScreenVersionText.get();
    }

    @ModifyReturnValue(method={"realmsNotificationsEnabled"}, at={@At(value="RETURN")})
    public boolean realmsNotificationsEnabled(boolean original) {
        return false;
    }
}

