/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;
import wily.legacy.inventory.LegacyCraftingMenu;

public record ServerOpenClientMenuPayload(ClientMenu menu) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<ServerOpenClientMenuPayload> ID = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("server_open_client_menu_payload"), ServerOpenClientMenuPayload::new);

    public ServerOpenClientMenuPayload(CommonNetwork.PlayBuf buf) {
        this((ClientMenu)((RegistryFriendlyByteBuf)buf.get()).readEnum(ClientMenu.class));
    }

    public static ServerOpenClientMenuPayload playerCrafting() {
        return new ServerOpenClientMenuPayload(ClientMenu.PLAYER_CRAFTING);
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((RegistryFriendlyByteBuf)buf.get()).writeEnum((Enum)this.menu);
    }

    public void apply(CommonNetwork.Payload.Context context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.openMenu(this.menu.menuProviderSupplier.get());
        }
    }

    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }

    public static enum ClientMenu {
        PLAYER_CRAFTING(() -> LegacyCraftingMenu.getMenuProvider(BlockPos.ZERO, true));

        public final Supplier<MenuProvider> menuProviderSupplier;

        private ClientMenu(Supplier<MenuProvider> menuProviderSupplier) {
            this.menuProviderSupplier = menuProviderSupplier;
        }
    }
}

