/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5369;
import net.minecraft.class_5375;
import net.minecraft.class_5489;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8028;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.CommonColor;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public record GlobalPacks(List<String> list, boolean applyOnTop) {
    public static final GlobalPacks EMPTY = new GlobalPacks(Collections.emptyList(), true);
    public static final Codec<GlobalPacks> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.listOf().fieldOf("packs").forGetter(GlobalPacks::list), (App)Codec.BOOL.fieldOf("applyOnTop").forGetter(GlobalPacks::applyOnTop)).apply((Applicative)i, GlobalPacks::new));
    public static final FactoryConfig.StorageHandler STORAGE = new FactoryConfig.StorageHandler().withFile("legacy/global_packs.json");
    public static final FactoryConfig<GlobalPacks> globalResources = STORAGE.register(FactoryConfig.create((String)"globalResources", null, () -> CODEC, (Object)EMPTY.withPacks(List.of("legacy:legacy_resources")), v -> {}, (FactoryConfig.StorageAccess)STORAGE));

    public void applyPacks(class_3283 repository, List<String> additional) {
        ArrayList<String> packs = new ArrayList<String>(this.list());
        packs.removeIf(additional::contains);
        packs.addAll(this.applyOnTop ? 0 : packs.size(), additional);
        repository.method_14447(packs);
    }

    public GlobalPacks withPacks(List<String> packs) {
        return new GlobalPacks(packs, this.applyOnTop);
    }

    public GlobalPacks withApplyOnTop(boolean applyOnTop) {
        return new GlobalPacks(this.list, applyOnTop);
    }

    public static class Selector
    extends class_339
    implements ControlTooltip.ActionHolder {
        public final FactoryConfig<GlobalPacks> globalPacks;
        public final Stocker.Sizeable scrolledList;
        public final BiFunction<class_2561, Integer, class_5489> labelsCache = class_156.method_34865((c, i) -> class_5489.method_30890((class_327)class_310.method_1551().field_1772, (class_2561)c, (int)i));
        protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
        public final ScrollableRenderer scrollableRenderer = new ScrollableRenderer(this.scrollRenderer);
        private final class_2561 screenComponent;
        private final Path packPath;
        private final boolean hasTooltip;
        private final class_3283 packRepository;
        private final class_310 minecraft;
        public class_5369 model;
        public int selectedIndex = -1;
        public class_3288 selectedPack;

        public Selector(int i2, int j, int k, int l, class_2561 component, class_2561 screenComponent, class_3283 packRepository, Path packPath, FactoryConfig<GlobalPacks> globalPacks, boolean hasTooltip) {
            super(i2, j, k, l, component);
            this.screenComponent = screenComponent;
            this.globalPacks = globalPacks;
            this.packPath = packPath;
            this.hasTooltip = hasTooltip;
            this.minecraft = class_310.method_1551();
            this.packRepository = packRepository;
            Collection packs = packRepository.method_29210();
            packRepository.method_14447(((GlobalPacks)globalPacks.get()).list());
            this.updateModel();
            packRepository.method_14447(packs);
            this.scrolledList = new Stocker.Sizeable(Integer.valueOf(0));
            List<class_3288> displayPacks = this.getDisplayPacks();
            if (displayPacks.size() > this.getMaxPacks()) {
                this.scrolledList.max = displayPacks.size() - this.getMaxPacks();
            }
            this.setSelectedPack(0);
            this.updateTooltip();
        }

        public void method_25358(int i) {
            super.method_25358(i);
            List<class_3288> displayPacks = this.getDisplayPacks();
            if (displayPacks.size() > this.getMaxPacks()) {
                this.scrolledList.max = displayPacks.size() - this.getMaxPacks();
            }
        }

        public static Selector resources(int i, int j, int k, int l, boolean hasTooltip) {
            return new Selector(i, j, k, l, LegacyComponents.GLOBAL_RESOURCE_PACKS, LegacyComponents.SHOW_RESOURCE_PACKS, class_310.method_1551().method_1520(), class_310.method_1551().method_1479(), globalResources, hasTooltip);
        }

        public List<class_3288> getDisplayPacks() {
            return Stream.concat(this.model.field_25455.stream(), this.model.field_25456.stream()).toList();
        }

        public void updateTooltip() {
            if (this.hasTooltip) {
                this.method_47400(class_7919.method_47408((class_2561)this.selectedPack.method_14459(), (class_2561)this.selectedPack.method_14457()));
            }
        }

        public void renderTooltipBox(class_332 guiGraphics, class_8021 panel) {
            this.renderTooltipBox(guiGraphics, panel, 0);
        }

        public void renderTooltipBox(class_332 guiGraphics, class_8021 panel, int xOffset) {
            this.renderTooltipBox(guiGraphics, panel.method_46426() + panel.method_25368() - 2 + xOffset, panel.method_46427() + 5, 161, panel.method_25364() - 10);
        }

        public void renderTooltipBox(class_332 graphics, int x, int y, int width, int height) {
            if (this.hasTooltip) {
                return;
            }
            LegacyRenderUtil.renderPointerPanel(graphics, x, y, width, height);
            if (this.selectedPack != null) {
                FactoryGuiGraphics.of((class_332)graphics).blit(PackAlbum.Selector.getPackIcon(this.selectedPack), x + 7, y + 5, 0.0f, 0.0f, 32, 32, 32, 32);
                FactoryGuiGraphics.of((class_332)graphics).enableScissor(x + 40, y + 4, x + 148, y + 44);
                this.labelsCache.apply(this.selectedPack.method_14457(), 108).method_73212(graphics, class_5489.class_11735.field_62009, x + 43, y + 8, 12, true, -1);
                graphics.method_44380();
                class_2960 background = PackAlbum.Selector.getPackBackground(this.selectedPack);
                class_5489 label = this.labelsCache.apply(this.selectedPack.method_14459(), 145);
                int visibleLines = (height - 50 - (background == null ? 0 : 78)) / 12;
                this.scrollableRenderer.scrolled.max = org.joml.Math.max((int)0, (int)(label.method_30887() - visibleLines));
                this.scrollableRenderer.render(graphics, x + 8, y + 40, 146, visibleLines * 12, () -> label.method_73212(graphics, class_5489.class_11735.field_62009, x + 8, y + 40, 12, true, -1));
                if (background != null) {
                    FactoryGuiGraphics.of((class_332)graphics).blit(background, x + 8, y + height - 78, 0.0f, 0.0f, 145, 72, 145, 72);
                }
            }
        }

        public boolean method_25404(class_11908 keyEvent) {
            if (this.method_25367() && this.field_22763) {
                if (keyEvent.comp_4795() == 88) {
                    this.openPackSelectionScreen();
                    return true;
                }
                if (keyEvent.method_74229()) {
                    this.tryChangePackState(this.selectedIndex);
                    this.method_25354(class_310.method_1551().method_1483());
                    return true;
                }
                if (keyEvent.method_74232()) {
                    if (this.selectedIndex == (Integer)this.scrolledList.get()) {
                        this.updateScroll(-1, true);
                    }
                    this.setSelectedPack(this.selectedIndex - 1);
                    LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.SCROLL.get(), 1.0f);
                } else if (keyEvent.method_74233()) {
                    if (this.selectedIndex == (Integer)this.scrolledList.get() + this.getMaxPacks() - 1) {
                        this.updateScroll(1, true);
                    }
                    this.setSelectedPack(this.selectedIndex + 1);
                    LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.SCROLL.get(), 1.0f);
                }
            }
            return super.method_25404(keyEvent);
        }

        public void setSelectedPack(int index) {
            if (this.selectedIndex == index) {
                return;
            }
            List<class_3288> displayPacks = this.getDisplayPacks();
            this.selectedIndex = Stocker.cyclic((int)0, (int)index, (int)displayPacks.size());
            this.selectedPack = displayPacks.get(this.selectedIndex);
            this.scrollableRenderer.resetScrolled();
            this.updateTooltip();
        }

        public void tryChangePackState(int index) {
            class_3288 p = this.getDisplayPacks().get(index);
            if (p.method_14464()) {
                return;
            }
            if (this.model.field_25455.contains(p)) {
                this.model.field_25455.remove(p);
                this.model.field_25456.add(p);
            } else {
                this.model.field_25456.remove(p);
                this.model.field_25455.add(0, p);
            }
        }

        public List<String> getSelectedIds() {
            return this.model.field_25455.stream().filter(p -> !FactoryAPIPlatform.isPackHidden((class_3288)p) && !p.method_14464()).map(class_3288::method_14463).collect(Collectors.collectingAndThen(Collectors.toList(), l -> {
                Collections.reverse(l);
                return l;
            }));
        }

        public boolean hasChanged() {
            return !this.getSelectedIds().equals(this.globalPacks.get());
        }

        public void applyChanges() {
            if (!this.hasChanged()) {
                return;
            }
            this.globalPacks.set((Object)((GlobalPacks)this.globalPacks.get()).withPacks(this.getSelectedIds()));
            this.globalPacks.save();
        }

        public void updateModel() {
            this.model = new class_5369(e -> {}, PackAlbum.Selector::getPackIcon, this.packRepository, r -> {});
        }

        public void openPackSelectionScreen() {
            if (this.minecraft.field_1755 != null) {
                class_437 screen = this.minecraft.field_1755;
                Collection packs = this.packRepository.method_29210();
                this.packRepository.method_14447(this.getSelectedIds());
                this.minecraft.method_1507((class_437)new class_5375(this.packRepository, p -> {
                    this.updateModel();
                    this.packRepository.method_14447(packs);
                    this.minecraft.method_1507(screen);
                }, this.packPath, this.method_25369()));
            }
        }

        public void method_25348(class_11909 event, boolean bl) {
            if (event.method_74239()) {
                this.openPackSelectionScreen();
                return;
            }
            int visibleCount = 0;
            for (int index = 0; index < this.getDisplayPacks().size() && visibleCount < this.getMaxPacks(); ++visibleCount, ++index) {
                if (!(event.comp_4798() >= (double)(this.method_46426() + 20 + 30 * index))) continue;
                double d = event.comp_4799();
                int n = this.method_46427();
                Objects.requireNonNull(this.minecraft.field_1772);
                if (!(d >= (double)(n + 9 + 3))) continue;
                double d2 = event.comp_4798();
                int n2 = this.method_46426();
                Objects.requireNonNull(this.minecraft.field_1772);
                if (!(d2 < (double)(n2 + 9 + 49 + 30 * index))) continue;
                double d3 = event.comp_4799();
                int n3 = this.method_46427();
                Objects.requireNonNull(this.minecraft.field_1772);
                if (!(d3 < (double)(n3 + 9 + 32))) continue;
                if (this.selectedIndex == index + (Integer)this.scrolledList.get()) {
                    this.tryChangePackState(index + (Integer)this.scrolledList.get());
                }
                this.setSelectedPack(index + (Integer)this.scrolledList.get());
            }
            super.method_25348(event, bl);
        }

        public boolean method_25401(double d, double e, double f, double g) {
            if (this.updateScroll((int)Math.signum(g), false)) {
                return true;
            }
            return super.method_25401(d, e, f, g);
        }

        public boolean updateScroll(int i, boolean cyclic) {
            if (this.scrolledList.max > 0 && ((Integer)this.scrolledList.get() <= this.scrolledList.max && i > 0 || (Integer)this.scrolledList.get() >= 0 && i < 0)) {
                return this.scrolledList.add(i, cyclic) != 0;
            }
            return false;
        }

        protected int getMaxPacks() {
            return (this.field_22758 - 40) / 30;
        }

        protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
            class_327 font = this.minecraft.field_1772;
            FactoryGuiGraphics factoryGuiGraphics = FactoryGuiGraphics.of((class_332)guiGraphics);
            int n = this.method_46426() - 1;
            int n2 = this.method_46427();
            Objects.requireNonNull(font);
            int n3 = n2 + 9 - 1;
            Objects.requireNonNull(this.minecraft.field_1772);
            factoryGuiGraphics.blitSprite(LegacySprites.PANEL_RECESS, n, n3, this.field_22758 + 2, this.field_22759 + 2 - 9);
            List<class_3288> displayPacks = this.getDisplayPacks();
            int visibleCount = 0;
            FactoryScreenUtil.enableBlend();
            for (int index = 0; index < displayPacks.size() && visibleCount < this.getMaxPacks(); ++visibleCount, ++index) {
                FactoryGuiGraphics factoryGuiGraphics2 = FactoryGuiGraphics.of((class_332)guiGraphics);
                class_2960 class_29602 = PackAlbum.Selector.getPackIcon(displayPacks.get((Integer)this.scrolledList.get() + index));
                int n4 = this.method_46426() + 21 + 30 * index;
                int n5 = this.method_46427();
                Objects.requireNonNull(font);
                factoryGuiGraphics2.blit(class_29602, n4, n5 + 9 + 4, 0.0f, 0.0f, 28, 28, 28, 28);
                if (this.model.field_25455.contains(displayPacks.get((Integer)this.scrolledList.get() + index))) {
                    FactoryGuiGraphics factoryGuiGraphics3 = FactoryGuiGraphics.of((class_332)guiGraphics);
                    int n6 = this.method_46426() + 20 + 30 * index;
                    int n7 = this.method_46427();
                    Objects.requireNonNull(font);
                    factoryGuiGraphics3.blitSprite(LegacySprites.PACK_SELECTED, n6, n7 + 9 + 3, 30, 30);
                }
                if ((Integer)this.scrolledList.get() + index != this.selectedIndex) continue;
                FactoryGuiGraphics factoryGuiGraphics4 = FactoryGuiGraphics.of((class_332)guiGraphics);
                int n8 = this.method_46426() + 20 + 30 * index;
                int n9 = this.method_46427();
                Objects.requireNonNull(font);
                factoryGuiGraphics4.blitSprite(LegacySprites.PACK_HIGHLIGHTED, n8, n9 + 9 + 3, 30, 30);
            }
            FactoryScreenUtil.disableBlend();
            guiGraphics.method_51448().pushMatrix();
            if (!this.method_25367()) {
                guiGraphics.method_51448().translate(0.4f, 0.4f);
            }
            guiGraphics.method_51439(font, this.method_25369(), this.method_46426() + 2, this.method_46427(), this.method_25367() ? LegacyRenderUtil.getDefaultTextColor() : (Integer)CommonColor.INVENTORY_GRAY_TEXT.get(), this.method_25367());
            guiGraphics.method_51448().popMatrix();
            if (this.scrolledList.max > 0) {
                if ((Integer)this.scrolledList.get() < this.scrolledList.max) {
                    int n10 = this.method_46426() + this.field_22758 - 12;
                    int n11 = this.method_46427();
                    Objects.requireNonNull(font);
                    int n12 = n11 + 9;
                    Objects.requireNonNull(font);
                    this.scrollRenderer.renderScroll(guiGraphics, class_8028.field_41829, n10, n12 + (this.field_22759 - 9 - 11) / 2);
                }
                if ((Integer)this.scrolledList.get() > 0) {
                    int n13 = this.method_46426() + 8;
                    int n14 = this.method_46427();
                    Objects.requireNonNull(font);
                    int n15 = n14 + 9;
                    Objects.requireNonNull(font);
                    this.scrollRenderer.renderScroll(guiGraphics, class_8028.field_41828, n13, n15 + (this.field_22759 - 9 - 11) / 2);
                }
            }
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            this.method_37021(narrationElementOutput);
        }

        @Override
        @Nullable
        public class_2561 getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, k -> k.key() == 88 && this.method_25370() || k.key() == 0 && this.method_49606() ? this.screenComponent : ControlTooltip.getSelectAction((class_364)this, context));
        }
    }
}

