/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_32;
import org.apache.commons.io.FileUtils;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;

public class LegacySaveCache {
    public static class_32 currentWorldSource;
    public static boolean manualSave;
    public static boolean saveExit;
    public static boolean retakeWorldIcon;

    public static void setup(class_310 m) {
        currentWorldSource = class_32.method_26999((Path)m.field_1697.toPath().resolve("current-world"));
    }

    public static class_32 getLevelStorageSource() {
        return (Boolean)LegacyOptions.saveCache.get() != false ? currentWorldSource : class_310.method_1551().method_1586();
    }

    public static boolean hasSaveSystem(class_310 minecraft) {
        return minecraft.method_1496() && !minecraft.method_1530() && !minecraft.method_1576().method_3754() && LegacySaveCache.isCurrentWorldSource(minecraft.method_1576().field_23784);
    }

    public static boolean isCurrentWorldSource(class_32.class_5143 storageSource) {
        return storageSource.method_27424(class_1937.field_25179).getParent().equals(currentWorldSource.method_19636());
    }

    public static void saveLevel(class_32.class_5143 storageSource) {
        if (LegacySaveCache.isCurrentWorldSource(storageSource)) {
            LegacySaveCache.copySaveBtwSources(storageSource, class_310.method_1551().method_1586(), false);
        }
    }

    public static String importSaveFile(InputStream saveInputStream, Predicate<String> exists, class_32 source, String saveDirName) {
        return Legacy4JClient.manageAvailableSaveDirName(f -> Legacy4J.copySaveToDirectory(saveInputStream, f), exists, source, saveDirName);
    }

    public static String importSaveFile(InputStream saveInputStream, class_32 source, String saveDirName) {
        return LegacySaveCache.importSaveFile(saveInputStream, arg_0 -> ((class_32)source).method_230(arg_0), source, saveDirName);
    }

    public static String copySaveFile(Path savePath, class_32 source, String saveDirName) {
        return Legacy4JClient.manageAvailableSaveDirName(f -> {
            try {
                FileUtils.copyDirectory((File)savePath.toFile(), (File)f);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, arg_0 -> ((class_32)source).method_230(arg_0), source, saveDirName);
    }

    public static void copySaveBtwSources(class_32.class_5143 sendSource, class_32 destSource) {
        LegacySaveCache.copySaveBtwSources(sendSource, destSource, true);
    }

    public static void copySaveBtwSources(class_32.class_5143 sendSource, class_32 destSource, boolean deleteOldDest) {
        try {
            File destLevelDirectory = destSource.method_19636().resolve(sendSource.method_27005()).toFile();
            if (deleteOldDest && destLevelDirectory.exists()) {
                FileUtils.deleteQuietly((File)destLevelDirectory);
            }
            FileUtils.copyDirectory((File)sendSource.method_27424(class_1937.field_25179).toFile(), (File)destLevelDirectory, p -> {
                if (p.getName().equals("session.lock")) {
                    return false;
                }
                if (deleteOldDest) {
                    return true;
                }
                File destFile = p.toPath().relativize(destLevelDirectory.toPath()).toFile();
                return !destFile.exists() || FileUtils.isFileNewer((File)p, (File)destFile);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        manualSave = false;
        saveExit = false;
        retakeWorldIcon = false;
    }
}

