/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.apache.logging.log4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.Legacy4J;
import wily.legacy.util.IOUtil;

public record LegacyWorldTemplate(class_2561 buttonMessage, class_2960 icon, String worldTemplate, String folderName, boolean directJoin, boolean isLocked, boolean isGamePath, boolean preDownload, Optional<String> albumId, Optional<URI> downloadURI, Optional<String> checkSum) {
    public static final Codec<LegacyWorldTemplate> CODEC = RecordCodecBuilder.create(i -> i.group((App)DynamicUtil.getComponentCodec().fieldOf("buttonMessage").forGetter(LegacyWorldTemplate::buttonMessage), (App)class_2960.field_25139.fieldOf("icon").forGetter(LegacyWorldTemplate::icon), (App)Codec.STRING.fieldOf("templateLocation").forGetter(LegacyWorldTemplate::worldTemplate), (App)Codec.STRING.fieldOf("folderName").forGetter(LegacyWorldTemplate::folderName), (App)Codec.BOOL.optionalFieldOf("directJoin", (Object)false).forGetter(LegacyWorldTemplate::directJoin), (App)Codec.BOOL.optionalFieldOf("isLocked", (Object)false).forGetter(LegacyWorldTemplate::isLocked), (App)Codec.BOOL.optionalFieldOf("isGamePath", (Object)false).forGetter(LegacyWorldTemplate::isGamePath), (App)Codec.BOOL.optionalFieldOf("preDownload", (Object)false).forGetter(LegacyWorldTemplate::preDownload), (App)Codec.STRING.optionalFieldOf("resourceAlbum").forGetter(LegacyWorldTemplate::albumId), (App)Codec.STRING.xmap(URI::create, URI::toString).optionalFieldOf("downloadURI").forGetter(LegacyWorldTemplate::downloadURI)).apply((Applicative)i, LegacyWorldTemplate::create));
    public static final Codec<List<LegacyWorldTemplate>> LIST_CODEC = CODEC.listOf();
    public static final List<LegacyWorldTemplate> list = new ArrayList<LegacyWorldTemplate>();
    private static final String TEMPLATES = "world_templates.json";

    public static LegacyWorldTemplate create(class_2561 buttonMessage, class_2960 icon, String worldTemplate, String folderName, boolean directJoin, boolean isLocked, boolean isGamePath, boolean delayDownload, Optional<String> albumId, Optional<URI> compoundDownloadURI) {
        Optional<String[]> splitURI = compoundDownloadURI.map(u -> u.toString().split("\\?checksum="));
        return new LegacyWorldTemplate(buttonMessage, icon, worldTemplate, folderName, directJoin, isLocked, isGamePath, delayDownload, albumId, splitURI.map(s -> URI.create(s[0])), splitURI.map(s -> ((String[])s).length < 2 ? null : s[1]));
    }

    public Path getPath() {
        return class_310.method_1551().field_1697.toPath().resolve(this.worldTemplate);
    }

    public InputStream open() {
        try {
            return this.isGamePath ? new FileInputStream(this.getPath().toString()) : class_310.method_1551().method_1478().open(FactoryAPI.createLocation((String)this.worldTemplate));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getValidPath() {
        String checksum;
        if (!this.isGamePath || this.downloadURI.isEmpty()) {
            return null;
        }
        Path path = this.getPath();
        boolean exists = Files.exists(path, new LinkOption[0]);
        if (exists && this.checkSum().isEmpty() || exists && this.checkSum().get().equals(this.readFileCheckSum(path)) || (checksum = this.readCheckSum(path)) == null || !this.checkSum().get().equals(checksum)) {
            return null;
        }
        return path;
    }

    public void downloadToPathIfPossible() {
        Path path = this.getValidPath();
        if (path == null) {
            return;
        }
        try (InputStream stream = this.downloadURI.get().toURL().openStream();){
            Files.deleteIfExists(path);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(stream, path, new CopyOption[0]);
        }
        catch (IOException e) {
            Legacy4J.LOGGER.warn("Error when downloading world template to path {}: {}", (Object)path, (Object)e.getMessage());
        }
    }

    public String readCheckSum(Path path) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(URI.create(String.valueOf(this.downloadURI.get()) + ".md5").toURL().openStream()));
        try {
            string = reader.readLine().trim();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn("Error when reading checksum from world template {}: {}", (Object)path, (Object)e.getMessage());
                return null;
            }
        }
        reader.close();
        return string;
    }

    public String readFileCheckSum(Path path) {
        ByteSource byteSource = com.google.common.io.Files.asByteSource((File)path.toFile());
        try {
            return byteSource.hash(Hashing.md5()).toString();
        }
        catch (IOException e) {
            Legacy4J.LOGGER.warn("Error when reading existing checksum from world template {}: {}", (Object)path, (Object)e.getMessage());
            return null;
        }
    }

    public static class Manager
    implements class_4013 {
        public void method_14491(class_3300 resourceManager) {
            list.clear();
            IOUtil.getOrderedNamespaces(resourceManager).forEach(name -> resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)LegacyWorldTemplate.TEMPLATES)).ifPresent(r -> {
                try (BufferedReader bufferedReader = r.method_43039();){
                    LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)bufferedReader)).resultOrPartial(arg_0 -> ((Logger)Legacy4J.LOGGER).warn(arg_0)).ifPresent(templates -> templates.forEach(template -> {
                        list.add((LegacyWorldTemplate)template);
                        if (template.preDownload()) {
                            template.downloadToPathIfPossible();
                        }
                    }));
                }
                catch (IOException var8) {
                    Legacy4J.LOGGER.warn(var8.getMessage());
                }
            }));
        }

        public String method_22322() {
            return "legacy:world_template";
        }
    }
}

