/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyLoading;
import wily.legacy.client.screen.LegacyLoadingRenderer;
import wily.legacy.network.TopMessage;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.client.LegacySoundUtil;

public class LegacyLoadingScreen
extends class_437
implements LegacyLoading,
ControlTooltip.Event {
    private final LegacyLoadingRenderer renderer = new LegacyLoadingRenderer();

    public LegacyLoadingScreen() {
        super(class_333.field_18967);
    }

    public LegacyLoadingScreen(class_2561 loadingHeader, class_2561 loadingStage) {
        this();
        this.setLoadingHeader(loadingHeader);
        this.setLoadingStage(loadingStage);
    }

    public static LegacyLoadingScreen getDimensionChangeScreen(final BooleanSupplier levelReady, class_5321<class_1937> lastLevel, class_5321<class_1937> newLevel) {
        final long createdTime = class_156.method_658();
        boolean lastOd = LegacyLoadingScreen.isOtherDimension(lastLevel);
        boolean od = LegacyLoadingScreen.isOtherDimension(newLevel);
        LegacyLoadingScreen screen = new LegacyLoadingScreen((class_2561)(od || lastOd ? class_2561.method_43469((String)("legacy.menu." + (lastOd ? "leaving" : "entering")), (Object[])new Object[]{LegacyComponents.getDimensionName(lastOd ? lastLevel : newLevel)}) : class_2561.method_43473()), (class_2561)class_2561.method_43473()){

            public void method_25393() {
                if (levelReady.getAsBoolean() || class_156.method_658() - createdTime >= 30000L) {
                    this.field_22787.method_1507(null);
                }
            }

            public boolean method_25421() {
                return false;
            }
        };
        if (od || lastOd) {
            screen.setGenericLoading(true);
        }
        return screen;
    }

    public static boolean isOtherDimension(class_5321<class_1937> level) {
        return level != null && level != class_1937.field_25179;
    }

    public static LegacyLoadingScreen getRespawningScreen(final BooleanSupplier levelReady) {
        final long createdTime = class_156.method_658();
        LegacyLoadingScreen screen = new LegacyLoadingScreen(LegacyComponents.RESPAWNING, (class_2561)class_2561.method_43473()){

            public void method_25393() {
                if (levelReady.getAsBoolean() || class_156.method_658() - createdTime >= 30000L) {
                    this.field_22787.method_1507(null);
                }
            }

            public boolean method_25421() {
                return false;
            }
        };
        screen.setGenericLoading(true);
        return screen;
    }

    public static void startFakeAutoSave() {
        if (!((Boolean)LegacyOptions.fakeAutosaveScreen.get()).booleanValue()) {
            return;
        }
        class_310.method_1551().field_1705.field_35428 = 0.0f;
        TopMessage.setMedium(null);
        class_310.method_1551().method_1507((class_437)LegacyLoadingScreen.getFakeAutoSaveScreen());
    }

    public static LegacyLoadingScreen getFakeAutoSaveScreen() {
        return new LegacyLoadingScreen(LegacyComponents.PREPARING_AUTOSAVE, LegacyComponents.PREPARING_CHUNKS){
            int finalizingTicks = -1;

            public void method_25393() {
                this.field_22787.field_1705.field_35428 = 0.0f;
                super.method_25393();
                if (this.finalizingTicks < 0) {
                    this.setProgress(this.getProgress() + 0.02f);
                    if ((double)this.getProgress() >= 1.0) {
                        this.finalizingTicks = 80;
                        this.setProgress(0.0f);
                        this.setLoadingStage(LegacyComponents.FINALIZING);
                    }
                } else if (this.finalizingTicks > 0) {
                    --this.finalizingTicks;
                } else {
                    this.method_25419();
                    LegacySoundUtil.playBackSound();
                    this.field_22787.field_1705.field_35428 = 1.0f;
                }
            }
        };
    }

    public static LegacyLoadingScreen createWithExecutor(class_2561 header, final Runnable onClose, final ExecutorService executor) {
        return new LegacyLoadingScreen(header, (class_2561)class_2561.method_43473()){

            public void method_25419() {
                onClose.run();
                4.closeExecutor(executor);
            }

            @Override
            public boolean method_25422() {
                return true;
            }
        };
    }

    public static void closeExecutor(ExecutorService executor) {
        boolean bl;
        executor.shutdown();
        try {
            bl = executor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException var3) {
            bl = false;
        }
        if (!bl) {
            executor.shutdownNow();
        }
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        this.renderer.prepareRender(this.field_22787);
        this.renderer.renderBackground(guiGraphics, i, j, f);
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        this.renderer.renderForeground(guiGraphics, i, j, f);
    }

    @Override
    public LegacyLoadingRenderer getLoadingRenderer() {
        return this.renderer;
    }
}

