/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_11719;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.ModInfo;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class ModsScreen
extends PanelVListScreen {
    public static final Function<ModInfo, SizedLocation> modLogosCache = class_156.method_34866(mod -> {
        Optional opt = mod.getLogoFile(100);
        if (opt.isPresent() && mod.containsResource((String)opt.get())) {
            try {
                class_1011 image = class_1011.method_4309((InputStream)mod.openResource((String)opt.get()));
                class_2960 location = FactoryAPI.createLocation((String)mod.getId(), (String)((String)opt.get()).toLowerCase(Locale.ENGLISH));
                class_310.method_1551().method_1531().method_4616(location, (class_1044)new class_1043(() -> ((class_2960)location).toString(), image));
                if (location != null) {
                    return new SizedLocation(location, image.method_4307(), image.method_4323());
                }
            }
            catch (IOException image) {
                // empty catch block
            }
        }
        class_2960 defaultLogo = PackAlbum.Selector.DEFAULT_ICON;
        if (mod.getId().equals("minecraft")) {
            defaultLogo = PackAlbum.Selector.getPackIcon(class_310.method_1551().method_1520().method_14449("vanilla"));
        }
        return new SizedLocation(defaultLogo, 1, 1);
    });
    protected final Panel panelRecess;
    protected final Panel tooltipBox;
    protected final Stocker.Sizeable sorting;
    protected ScrollableRenderer scrollableRenderer;
    protected ModInfo focusedMod;
    protected final LoadingCache<ModInfo, AdvancedTextWidget> modLabelsCache;

    public ModsScreen(class_437 parent) {
        super(parent, 282, 243, (class_2561)class_2561.method_43473());
        this.tooltipBox = Panel.tooltipBoxOf(this.panel, 192);
        this.sorting = new Stocker.Sizeable(Integer.valueOf(1), 1);
        this.scrollableRenderer = new ScrollableRenderer(new LegacyScrollRenderer());
        this.modLabelsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ModInfo, AdvancedTextWidget>(){

            public AdvancedTextWidget load(ModInfo key) {
                ArrayList<class_2561> components = new ArrayList<class_2561>();
                SizedLocation logo = modLogosCache.apply(key);
                if (logo != null && logo.getScaledWidth(28) >= 120) {
                    components.add((class_2561)class_2561.method_43470((String)ModsScreen.this.focusedMod.getName()));
                    components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.id", (Object[])new Object[]{ModsScreen.this.focusedMod.getId()}));
                }
                if (!key.getAuthors().isEmpty()) {
                    components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.authors", (Object[])new Object[]{String.join((CharSequence)", ", key.getAuthors())}));
                }
                if (!key.getCredits().isEmpty()) {
                    components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.credits", (Object[])new Object[]{String.join((CharSequence)", ", key.getCredits())}));
                }
                key.getHomepage().ifPresent(s -> components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.homepage", (Object[])new Object[]{s}).method_27696(ModsScreen.urlClickStyle(s))));
                key.getIssues().ifPresent(s -> components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.issues", (Object[])new Object[]{s}).method_27696(ModsScreen.urlClickStyle(s))));
                key.getSources().ifPresent(s -> components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.sources", (Object[])new Object[]{s}).method_27696(ModsScreen.urlClickStyle(s))));
                if (key.getLicense() != null && !key.getLicense().isEmpty()) {
                    components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.license", (Object[])new Object[]{String.join((CharSequence)", ", key.getLicense())}));
                }
                components.add((class_2561)class_2561.method_43470((String)key.getDescription()));
                MultilineTooltip tooltip = new MultilineTooltip(components, ModsScreen.this.tooltipBox.method_25368() - 16);
                return new AdvancedTextWidget(ModsScreen.this.accessor).withWidth(ModsScreen.this.tooltipBox.method_25368() - 16).withLines(tooltip.method_47405(ModsScreen.this.field_22787));
            }
        });
        this.renderableVList.layoutSpacing(l -> 0);
        this.fillMods();
        this.panelRecess = Panel.createPanel(this, p -> p.appearance(LegacySprites.PANEL_RECESS, this.panel.width - 14, this.panel.height - 14), p -> p.pos(this.panel.x + 7, this.panel.y + 7));
    }

    public static class_2583 urlClickStyle(String url) {
        class_2583 style = class_2583.field_24360;
        if (class_310.method_1551().field_1724 == null) {
            return style;
        }
        try {
            style = style.method_10958((class_2558)new class_2558.class_10608(URI.create(url)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return style;
    }

    public void fillMods() {
        List<ModInfo> mods = FactoryAPIPlatform.getMods();
        if ((Integer)this.sorting.get() != 0) {
            mods = mods.stream().sorted(Comparator.comparing(ModInfo::getName)).toList();
        }
        mods.forEach(mod -> {
            if (mod.isHidden()) {
                return;
            }
            this.renderableVList.addRenderable((class_4068)new class_4264(0, 0, 260, 30, (class_2561)class_2561.method_43470((String)mod.getName()), (ModInfo)mod){
                final /* synthetic */ ModInfo val$mod;
                {
                    this.val$mod = modInfo;
                    super(i, j, k, l, component);
                }

                public void method_25306(class_11907 input) {
                    class_437 config;
                    if (this.method_25370() && (config = FactoryAPIClient.getConfigScreen((ModInfo)this.val$mod, (class_437)ModsScreen.this)) != null) {
                        ModsScreen.this.field_22787.method_1507(config);
                    }
                }

                protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
                    super.method_48579(guiGraphics, i, j, f);
                    if (this.method_25370()) {
                        ModsScreen.this.focusedMod = this.val$mod;
                    }
                    FactoryScreenUtil.enableBlend();
                    SizedLocation logo = modLogosCache.apply(this.val$mod);
                    if (logo != null) {
                        int iconHeight = ModsScreen.this.accessor.getInteger(ModsScreen.this.getRenderableVList().name + ".buttonIcon.size", 20);
                        int iconPos = (this.field_22759 - iconHeight) / 2;
                        FactoryGuiGraphics.of((class_332)guiGraphics).blit(logo.location, this.method_46426() + iconPos, this.method_46427() + iconPos, 0.0f, 0.0f, logo.getScaledWidth(iconHeight), iconHeight, logo.getScaledWidth(iconHeight), iconHeight);
                    }
                    FactoryScreenUtil.disableBlend();
                }

                protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
                    SizedLocation logo = modLogosCache.apply(this.val$mod);
                    int iconHeight = ModsScreen.this.accessor.getInteger(ModsScreen.this.getRenderableVList().name + ".buttonIcon.size", 20);
                    int iconPos = (this.field_22759 - iconHeight) / 2;
                    int x = this.method_46426() + iconPos + ModsScreen.this.accessor.getInteger(ModsScreen.this.getRenderableVList().name + ".buttonMessage.xOffset", 10) + (logo == null ? iconHeight : logo.getScaledWidth(iconHeight));
                    LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.method_25369(), x, this.method_46427(), x + this.method_25368(), this.method_46427() + this.method_25364(), j, true);
                }

                protected void method_47399(class_6382 narrationElementOutput) {
                    this.method_37021(narrationElementOutput);
                }
            });
        });
    }

    @Override
    public void renderDefaultBackground(class_332 guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        this.tooltipBox.method_25394(guiGraphics, i, j, f);
        if (this.focusedMod != null) {
            AdvancedTextWidget label = ((AdvancedTextWidget)this.modLabelsCache.getUnchecked((Object)this.focusedMod)).withPos(this.panel.x + this.panel.width + 5, this.panel.y + 41);
            this.scrollableRenderer.scrolled.max = Math.max(0, class_3532.method_15386((float)((float)(label.method_25364() - (this.tooltipBox.method_25364() - 50)) / 12.0f)));
            SizedLocation logo = modLogosCache.apply(this.focusedMod);
            int x = this.panel.x + this.panel.width + (logo == null ? 5 : logo.getScaledWidth(28) + 10);
            if (logo != null) {
                FactoryGuiGraphics.of((class_332)guiGraphics).blit(logo.location, this.panel.x + this.panel.width + 5, this.panel.y + 10, 0.0f, 0.0f, logo.getScaledWidth(28), 28, logo.getScaledWidth(28), 28);
            }
            if (logo == null || logo.getScaledWidth(28) < 120) {
                LegacyRenderUtil.renderScrollingString(guiGraphics, this.field_22793, (class_2561)class_2561.method_43469((String)"legacy.menu.mods.id", (Object[])new Object[]{this.focusedMod.getId()}), x, this.panel.y + 12, this.panel.x + this.panel.width + 185, this.panel.y + 24, -1, true);
                LegacyRenderUtil.renderScrollingString(guiGraphics, this.field_22793, (class_2561)class_2561.method_43469((String)"legacy.menu.mods.version", (Object[])new Object[]{this.focusedMod.getVersion()}), x, this.panel.y + 24, this.panel.x + this.panel.width + 185, this.panel.y + 36, -1, true);
            }
            this.scrollableRenderer.render(guiGraphics, this.panel.x + this.panel.width + 5, this.panel.y + 38, this.tooltipBox.method_25368() - 16, this.tooltipBox.method_25364() - 50, () -> label.method_25394(guiGraphics, i, j + Math.round(this.scrollableRenderer.getYOffset()), f));
        }
    }

    public boolean method_25402(class_11909 event, boolean bl) {
        AdvancedTextWidget label;
        if (this.focusedMod != null && LegacyRenderUtil.isMouseOver(event.comp_4798(), event.comp_4799(), this.panel.x + this.panel.width + 5, this.panel.y + 38, this.tooltipBox.method_25368() - 16, this.tooltipBox.method_25364() - 50) && (label = (AdvancedTextWidget)this.modLabelsCache.getUnchecked((Object)this.focusedMod)).method_25402(new class_11909(event.comp_4798(), event.comp_4799() + (double)this.scrollableRenderer.getYOffset(), event.comp_4800()), bl)) {
            return true;
        }
        return super.method_25402(event, bl);
    }

    @Override
    public boolean method_25401(double d, double e, double f, double g) {
        if ((this.tooltipBox.isHovered(d, e) || !ControlType.getActiveType().isKbm()) && this.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        return super.method_25401(d, e, f, g);
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.tooltipBox.init();
        this.panelRecess.init("panelRecess");
        this.method_37060((class_4068)this.panelRecess);
    }

    @Override
    public void renderableVListInit() {
        int buttonsHeight = this.accessor.getInteger("buttonsHeight", 30);
        for (class_4068 renderable : this.getRenderableVList().renderables) {
            if (!(renderable instanceof class_339)) continue;
            class_339 w = (class_339)renderable;
            w.method_53533(buttonsHeight);
            w.method_25355((class_2561)w.method_25369().method_27661().method_27696(w.method_25369().method_10866().method_27704((class_11719)(LegacyOptions.getUIMode().isSD() ? LegacyFontUtil.MOJANGLES_11_FONT : class_11719.field_61972))));
        }
        this.getRenderableVList().init(this.panel.x + 11, this.panel.y + 11, this.panel.width - 22, this.panel.height - 21);
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.comp_4795() == 88 && this.sorting.add(1, true) != 0) {
            this.renderableVList.renderables.clear();
            this.fillMods();
            this.method_48640();
            return true;
        }
        return super.method_25404(keyEvent);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> class_2561.method_43469((String)"legacy.menu.sorting", (Object[])new Object[]{(Integer)this.sorting.get() == 0 ? LegacyComponents.NONE : LegacyComponents.ALPHABETICAL}));
    }

    public record SizedLocation(class_2960 location, int width, int height) {
        public int getScaledWidth(int height) {
            return (int)((float)height * ((float)this.width() / (float)this.height()));
        }

        public int getScaledHeight(int width) {
            return (int)((float)width * ((float)this.height() / (float)this.width()));
        }
    }
}

