/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util.client;

import com.google.common.collect.Ordering;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_10017;
import net.minecraft.class_1074;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_368;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_490;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import net.minecraft.class_7532;
import net.minecraft.class_8000;
import net.minecraft.class_8020;
import net.minecraft.class_8028;
import net.minecraft.class_8685;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import oshi.SystemInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.GuiAccessor;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryGuiElement;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.network.TopMessage;
import wily.legacy.util.LegacyItemUtil;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyGuiElements;
import wily.legacy.util.client.MCAccount;

public class LegacyRenderUtil {
    public static final boolean isNvidia;
    public static final LegacyIconHolder iconHolderRenderer;
    public static final class_2960 MINECRAFT;
    public static final class_2960 PANORAMA_DAY;
    public static final class_2960 PANORAMA_NIGHT;
    public static final class_2960 MENU_BACKGROUND;
    public static final class_2960 LOADING_BACKGROUND;
    protected static final class_8020 logoRenderer;
    private static final class_310 mc;

    public static void renderPointerPanel(class_332 graphics, int x, int y, int width, int height) {
        LegacyRenderUtil.blitTranslucentOverlaySprite(graphics, LegacySprites.POINTER_PANEL, x, y, width, height);
    }

    public static void blitTranslucentOverlaySprite(class_332 graphics, class_2960 sprite, int x, int y, int width, int height) {
        LegacyRenderUtil.blitTranslucentSprite(graphics, sprite, x, y, width, height);
    }

    public static void blitTranslucentSprite(class_332 graphics, class_2960 sprite, int x, int y, int width, int height) {
        FactoryGuiGraphics.of((class_332)graphics).blitSprite(sprite, x, y, width, height);
    }

    public static void renderPanelTranslucentRecess(class_332 graphics, int x, int y, int width, int height) {
        LegacyRenderUtil.blitTranslucentSprite(graphics, LegacySprites.PANEL_TRANSLUCENT_RECESS, x, y, width, height);
    }

    public static void drawAutoSavingIcon(class_332 graphics, int x, int y) {
        FactoryGuiGraphics.of((class_332)graphics).blitSprite(LegacySprites.SAVE_CHEST, x, y, 24, 24);
        graphics.method_51448().pushMatrix();
        float heightAnim = (float)class_156.method_658() / 50.0f % 11.0f;
        graphics.method_51448().translate((float)x + 5.5f, (float)(y - 8) - (heightAnim > 5.0f ? 10.0f - heightAnim : heightAnim));
        FactoryGuiGraphics.of((class_332)graphics).blitSprite(LegacySprites.SAVE_ARROW, 0, 0, 13, 16);
        graphics.method_51448().popMatrix();
    }

    public static void renderDefaultBackground(UIAccessor accessor, class_332 guiGraphics) {
        LegacyRenderUtil.renderDefaultBackground(accessor, guiGraphics, true);
    }

    public static void renderDefaultBackground(UIAccessor accessor, class_332 guiGraphics, boolean title) {
        LegacyRenderUtil.renderDefaultBackground(accessor, guiGraphics, false, title, true);
    }

    public static boolean isVisualNight() {
        return LegacyRenderUtil.mc.field_1687 != null && LegacyRenderUtil.mc.field_1687.method_23886();
    }

    public static void renderDefaultBackground(UIAccessor accessor, class_332 guiGraphics, boolean forcePanorama, boolean title, boolean username) {
        if (LegacyRenderUtil.mc.field_1687 == null || accessor.getBoolean("forcePanorama", Boolean.valueOf(forcePanorama)).booleanValue()) {
            LegacyRenderUtil.renderPanorama(guiGraphics);
        } else {
            accessor.getScreen().method_52752(guiGraphics);
        }
        if (accessor.getBoolean("hasTitle", Boolean.valueOf(title)).booleanValue()) {
            LegacyRenderUtil.renderLogo(guiGraphics);
        }
        if (accessor.getBoolean("hasUsername", Boolean.valueOf(username)).booleanValue()) {
            LegacyRenderUtil.renderUsername(guiGraphics);
        }
    }

    public static void renderLogo(class_332 guiGraphics) {
        logoRenderer.method_48209(guiGraphics, guiGraphics.method_51421(), 1.0f);
    }

    public static float getLogoScale() {
        return LegacyOptions.getUIMode().isSD() ? 0.56217164f : 1.0f;
    }

    public static boolean hasLegacyLogo() {
        return ControlType.getActiveType().minecraftLogo().flatMap(arg_0 -> ((class_3300)mc.method_1478()).method_14486(arg_0)).isPresent() || mc.method_1478().method_14486(MINECRAFT).isPresent();
    }

    public static void renderLegacyLogo(class_332 guiGraphics, int y) {
        FactoryScreenUtil.enableBlend();
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate(((float)guiGraphics.method_51421() - 285.5f * LegacyRenderUtil.getLogoScale()) / 2.0f, (float)y);
        guiGraphics.method_51448().scale(0.5f * LegacyRenderUtil.getLogoScale(), 0.5f * LegacyRenderUtil.getLogoScale());
        FactoryGuiGraphics.of((class_332)guiGraphics).blit(mc.method_1478().method_14486(MINECRAFT).isPresent() ? MINECRAFT : ControlType.getActiveType().minecraftLogo().get(), 0, 0, 0.0f, 0.0f, 571, 138, 571, 138);
        guiGraphics.method_51448().popMatrix();
        FactoryScreenUtil.disableBlend();
    }

    public static void renderTransparentBackground(class_332 graphics) {
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((class_332)graphics).blit(MENU_BACKGROUND, 0, 0, 0.0f, 0.0f, graphics.method_51421(), graphics.method_51443(), graphics.method_51421(), graphics.method_51443());
        FactoryScreenUtil.disableBlend();
    }

    public static void renderUsername(class_332 graphics) {
        if (LegacyRenderUtil.mc.field_1687 != null) {
            return;
        }
        String username = MCAccount.isOfflineUser() ? class_1074.method_4662((String)"legacy.menu.offline_user", (Object[])new Object[]{mc.method_1548().method_1676()}) : mc.method_1548().method_1676();
        graphics.method_25303(LegacyRenderUtil.mc.field_1772, username, graphics.method_51421() - 33 - LegacyRenderUtil.mc.field_1772.method_1727(username), graphics.method_51443() - 27, -1);
    }

    public static void renderPanorama(class_332 guiGraphics) {
        LegacyRenderUtil.mc.field_1773.method_71649().method_3317(guiGraphics, guiGraphics.method_51421(), guiGraphics.method_51443(), true);
    }

    public static void renderLegacyPanorama(class_332 guiGraphics) {
        LegacyRenderUtil.renderLegacyPanorama(guiGraphics, LegacyRenderUtil.isVisualNight());
    }

    public static void renderLegacyPanorama(class_332 guiGraphics, boolean isNight) {
        FactoryGuiGraphics.of((class_332)guiGraphics).blit(isNight ? PANORAMA_NIGHT : PANORAMA_DAY, 0, 0, ((Double)LegacyRenderUtil.mc.field_1690.method_45581().method_41753()).floatValue() * (float)class_156.method_658() * (float)guiGraphics.method_51443() / 360.0f / 66.32f, 1.0f, guiGraphics.method_51421(), guiGraphics.method_51443() + 2, guiGraphics.method_51443() * 820 / 144, guiGraphics.method_51443() + 2);
    }

    public static void drawOutlinedString(class_332 graphics, class_327 font, class_2561 component, int x, int y, int color, int outlineColor, float outline) {
        LegacyRenderUtil.drawOutlinedString(graphics, font, component.method_30937(), x, y, color, outlineColor, outline);
    }

    public static void drawOutlinedString(class_332 graphics, class_327 font, class_5481 formattedCharSequence, int x, int y, int color, int outlineColor, float outline) {
        LegacyRenderUtil.drawStringOutline(graphics, font, formattedCharSequence, x, y, outlineColor, outline);
        graphics.method_51430(font, formattedCharSequence, x, y, color, false);
    }

    public static void drawStringOutline(class_332 graphics, class_327 font, class_5481 formattedCharSequence, int x, int y, int outlineColor, float outline) {
        float[] translations;
        for (float t : translations = new float[]{0.0f, outline, -outline}) {
            for (float t1 : translations) {
                if (t == 0.0f && t1 == 0.0f) continue;
                graphics.method_51448().pushMatrix();
                graphics.method_51448().translate(t, t1);
                graphics.method_51430(font, formattedCharSequence, x, y, outlineColor, false);
                graphics.method_51448().popMatrix();
            }
        }
    }

    public static boolean isMouseOver(double mouseX, double mouseY, double x, double y, int width, int height) {
        return mouseX >= x && mouseX < x + (double)width && mouseY >= y && mouseY < y + (double)height;
    }

    public static void applyHUDScale(class_332 graphics) {
        graphics.method_51448().scale(3.0f / LegacyRenderUtil.getHUDScale(), 3.0f / LegacyRenderUtil.getHUDScale());
    }

    public static void prepareHUDRender(class_332 graphics) {
        graphics.method_51448().pushMatrix();
        FactoryGuiGraphics.of((class_332)graphics).setBlitColor(1.0f, 1.0f, 1.0f, LegacyRenderUtil.getHUDOpacity());
        graphics.method_51448().translate(0.0f, LegacyRenderUtil.getHUDDistance());
        FactoryScreenUtil.enableBlend();
    }

    public static void finalizeHUDRender(class_332 graphics) {
        graphics.method_51448().popMatrix();
        FactoryGuiGraphics.of((class_332)graphics).setBlitColor(1.0f, 1.0f, 1.0f, 1.0f);
        FactoryScreenUtil.disableBlend();
    }

    public static float getHUDScale() {
        return switch ((Integer)LegacyOptions.hudSize.get()) {
            case 2 -> {
                if (LegacyOptions.getUIMode().isFHD()) {
                    yield 1.474f;
                }
                if (LegacyOptions.getUIMode().isSD()) {
                    yield 1.0f;
                }
                yield 1.5f;
            }
            case 3 -> {
                if (LegacyOptions.getUIMode().isSD()) {
                    yield 1.324f;
                }
                yield 2.0f;
            }
            default -> LegacyOptions.getUIMode().isSD() ? 0.8f : 1.0f;
        };
    }

    public static float getHUDSize() {
        return 6.0f + LegacyRenderUtil.getHUDScale() * (float)(35 + (LegacyRenderUtil.mc.field_1761.method_2908() ? Math.max(2, class_3532.method_15384((double)((Math.max(LegacyRenderUtil.mc.field_1724.method_45325(class_5134.field_23716), (double)Math.max((float)LegacyRenderUtil.mc.field_1705.field_2033, LegacyRenderUtil.mc.field_1724.method_6032())) + (double)LegacyRenderUtil.mc.field_1724.method_6067()) / 20.0)) + (LegacyRenderUtil.mc.field_1724.method_6096() > 0 ? 1 : 0)) * 10 : 0));
    }

    public static float getHUDDistance() {
        return -((Double)LegacyOptions.hudDistance.get()).floatValue() * (22.4f + ((Boolean)LegacyOptions.inGameTooltips.get() != false ? 17.6f : 0.0f));
    }

    public static float getHUDOpacity() {
        float f = (float)(class_156.method_658() - LegacyGuiElements.lastHotbarSelectionChange) / 1200.0f;
        return LegacyRenderUtil.getInterfaceOpacity() <= 0.8f ? Math.min(0.8f, LegacyRenderUtil.getInterfaceOpacity() + (1.0f - LegacyRenderUtil.getInterfaceOpacity()) * (f >= 3.0f ? Math.max(4.0f - f, 0.0f) : 1.0f)) : LegacyRenderUtil.getInterfaceOpacity();
    }

    public static boolean hasTooltipBoxes() {
        return (Boolean)LegacyOptions.tooltipBoxes.get();
    }

    public static boolean hasTooltipBoxes(UIAccessor accessor) {
        return LegacyRenderUtil.hasTooltipBoxes() && accessor.getBoolean("hasTooltipBox", Boolean.valueOf(true)) != false;
    }

    public static float getInterfaceOpacity() {
        return ((Double)LegacyOptions.hudOpacity.get()).floatValue();
    }

    public static int getDefaultTextColor(boolean forceWhite) {
        return !forceWhite ? (Integer)CommonColor.HIGHLIGHTED_WIDGET_TEXT.get() : (Integer)CommonColor.WIDGET_TEXT.get();
    }

    public static int getDefaultTextColor() {
        return LegacyRenderUtil.getDefaultTextColor(false);
    }

    public static boolean hasProgrammerArt() {
        return mc.method_1520().method_14444().stream().anyMatch(p -> p.method_14463().equals("programmer_art"));
    }

    public static void drawGenericLoading(class_332 graphics, int x, int y) {
        LegacyRenderUtil.drawGenericLoading(graphics, x, y, 21, 6);
    }

    public static void drawGenericLoading(class_332 graphics, int x, int y, int blockSize, int blockDistance) {
        int blockD = blockSize + blockDistance;
        for (int i = 0; i < 8; ++i) {
            float alpha;
            int v = (i + 1) * 100;
            int n = (i + 3) * 100;
            float l = (float)class_156.method_658() / 4.0f % 1000.0f;
            float f = l >= (float)(v - 100) ? (l <= (float)v ? l / (float)v : ((float)n - l) / 200.0f) : (alpha = 0.0f);
            if (!(alpha > 0.0f)) continue;
            FactoryGuiGraphics.of((class_332)graphics).setBlitColor(1.0f, 1.0f, 1.0f, alpha);
            FactoryGuiGraphics.of((class_332)graphics).blitSprite(LegacySprites.LOADING_BLOCK, x + (i <= 2 ? i : (i >= 4 ? (i == 7 ? 0 : 6 - i) : 2)) * blockD, y + (i <= 2 ? 0 : (i == 3 || i == 7 ? 1 : 2)) * blockD, blockSize, blockSize);
        }
        FactoryGuiGraphics.of((class_332)graphics).clearBlitColor();
    }

    public static void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 component, int j, int k, int l, int m, int n, boolean shadow) {
        LegacyRenderUtil.renderScrollingString(guiGraphics, font, component.method_30937(), j, k, l, m, n, shadow);
    }

    public static void renderScrollingString(class_332 guiGraphics, class_327 font, class_5481 charSequence, int j, int k, int l, int m, int n, boolean shadow) {
        LegacyRenderUtil.renderScrollingString(guiGraphics, font, charSequence, j, k, l, m, n, shadow, font.method_30880(charSequence));
    }

    public static void renderScrollingString(class_332 guiGraphics, class_327 font, class_5481 charSequence, int j, int k, int l, int m, int n, boolean shadow, int stringWidth) {
        Objects.requireNonNull(font);
        int p = (k + m - 9) / 2 + 1;
        int q = l - j;
        if (stringWidth > q) {
            int r = stringWidth - q;
            double d = (double)class_156.method_658() / 1000.0;
            double e = Math.max((double)r * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = class_3532.method_16436((double)f, (double)0.0, (double)r);
            FactoryGuiGraphics.of((class_332)guiGraphics).enableScissor(j, k, l, m);
            guiGraphics.method_51430(font, charSequence, j - (int)g, p, n, shadow && (Boolean)CommonValue.WIDGET_TEXT_SHADOW.get() != false);
            guiGraphics.method_44380();
        } else {
            guiGraphics.method_51430(font, charSequence, j, p, n, shadow && (Boolean)CommonValue.WIDGET_TEXT_SHADOW.get() != false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHovering(class_1735 slot, int leftPos, int topPos, double d, double e) {
        double d2;
        double d3;
        LegacyIconHolder holder = iconHolderRenderer.slotBounds(slot);
        int width = holder.method_25368();
        int height = holder.method_25364();
        double xCorner = holder.getXCorner() + holder.offset.field_1343;
        double yCorner = holder.getYCorner() + holder.offset.field_1342;
        d -= (double)leftPos;
        if (!(d3 >= xCorner)) return false;
        if (!(d < xCorner + (double)width)) return false;
        e -= (double)topPos;
        if (!(d2 >= yCorner)) return false;
        if (!(e < yCorner + (double)height)) return false;
        return true;
    }

    public static void renderEntityInInventoryFollowsMouse(class_332 guiGraphics, int i, int j, int k, int l, int m, float f, float g, float h, class_1309 livingEntity) {
        guiGraphics.method_44379(i, j, k, l);
        float n = (float)(i + k) / 2.0f;
        float o = (float)(j + l) / 2.0f;
        float p = (float)Math.atan((n - g) / 40.0f);
        float q = (float)Math.atan((o - h) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(q * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float r = livingEntity.field_6283;
        float s = livingEntity.method_36454();
        float t = livingEntity.method_36455();
        float u = livingEntity.field_6259;
        float v = livingEntity.field_6241;
        livingEntity.field_6283 = 180.0f + p * 20.0f;
        livingEntity.method_36456(180.0f + p * 40.0f);
        livingEntity.method_36457(-q * 20.0f);
        livingEntity.field_6241 = livingEntity.method_36454();
        livingEntity.field_6259 = livingEntity.method_36454();
        float w = livingEntity.method_55693();
        Vector3f vector3f = new Vector3f(0.0f, livingEntity.method_17682() / 2.0f + f * w, 0.0f);
        float x = (float)m / w;
        class_490.method_48472((class_332)guiGraphics, (int)(i - guiGraphics.method_51421()), (int)(j - guiGraphics.method_51443()), (int)(k + guiGraphics.method_51421()), (int)(l + guiGraphics.method_51443()), (float)x, (Vector3f)vector3f, (Quaternionf)quaternionf, (Quaternionf)quaternionf2, (class_1309)livingEntity);
        livingEntity.field_6283 = r;
        livingEntity.method_36456(s);
        livingEntity.method_36457(t);
        livingEntity.field_6259 = u;
        livingEntity.field_6241 = v;
        guiGraphics.method_44380();
    }

    public static void renderEntity(class_332 guiGraphics, int x, int y, int x0, int y0, int size, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, class_1297 entity) {
        LegacyRenderUtil.renderEntity(guiGraphics, x, y, x0, y0, size, vector3f, quaternionf, quaternionf2, entity, false);
    }

    public static void renderEntity(class_332 guiGraphics, int x, int y, int x0, int y0, int size, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, class_1297 entity, boolean forceSize) {
        float h;
        float f = h = forceSize ? (float)size / Math.max(1.0f, Math.max(entity.method_17681(), entity.method_17682())) : (float)size;
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            h /= living.method_55693();
        }
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        class_897 entityRenderer = entityRenderDispatcher.method_3953(entity);
        class_10017 entityRenderState = entityRenderer.method_62425(entity, 1.0f);
        entityRenderState.field_61820 = 0xF000F0;
        entityRenderState.field_58169 = null;
        entityRenderState.field_61823.clear();
        entityRenderState.field_61821 = 0;
        guiGraphics.method_70856(entityRenderState, h, vector3f, quaternionf, quaternionf2, x, y, x0, y0);
    }

    public static void renderLocalPlayerHead(class_332 guiGraphics, int x, int y, int size) {
        if (LegacyRenderUtil.mc.field_1724 == null) {
            return;
        }
        class_7532.method_52722((class_332)guiGraphics, (class_8685)LegacyRenderUtil.mc.field_1724.method_52814(), (int)x, (int)y, (int)size);
    }

    public static float getAutoGuiScale() {
        return (float)LegacyRenderUtil.getStandardHeight() / (LegacyOptions.getUIMode().isSD() ? 240.0f : 360.0f);
    }

    public static int getStandardHeight() {
        return Math.round((float)mc.method_22683().method_4506() / 180.0f) * 180;
    }

    public static boolean is720p() {
        return LegacyRenderUtil.getStandardHeight() <= 720;
    }

    public static float getTooltipScale() {
        return (Boolean)LegacyOptions.legacyItemTooltipScaling.get() != false && LegacyOptions.getUIMode().isFHD() ? 0.6666667f : 1.0f;
    }

    public static float getChatSafeZone() {
        return 29.0f * ((Double)LegacyOptions.hudDistance.get()).floatValue();
    }

    public static int getSelectedItemTooltipLines() {
        return (Integer)LegacyOptions.selectedItemTooltipLines.get() == 0 ? 0 : (Integer)LegacyOptions.selectedItemTooltipLines.get() + ((Boolean)LegacyOptions.itemTooltipEllipsis.get() != false ? 1 : 0);
    }

    public static boolean canDisplayHUD() {
        int hudDelay = (Integer)LegacyOptions.hudDelay.get();
        return LegacyRenderUtil.mc.field_1755 == null && (hudDelay == 0 || class_156.method_658() - LegacyGuiElements.lastGui > (long)hudDelay);
    }

    public static void renderContainerEffects(class_332 guiGraphics, int leftPos, int topPos, int imageWidth, int imageHeight, int mouseX, int mouseY) {
        int x = leftPos + imageWidth + 3;
        int l = guiGraphics.method_51421() - x;
        Collection collection = LegacyRenderUtil.mc.field_1724.method_6026();
        if (collection.isEmpty() || l < 32) {
            return;
        }
        boolean bl = l >= 129;
        int m = 31;
        if (imageHeight < collection.size() * 28) {
            m = imageHeight / collection.size();
        }
        List iterable = Ordering.natural().sortedCopy((Iterable)collection);
        int y = topPos + imageHeight - 28;
        for (class_1293 mobEffectInstance : iterable) {
            LegacyRenderUtil.renderPointerPanel(guiGraphics, x, y, bl ? 129 : 28, 28);
            if (bl) {
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().translate((float)(x + 25), (float)(y + 7));
                LegacyFontUtil.applySmallerFont(LegacyFontUtil.MOJANGLES_11_FONT, b -> {
                    class_2561 effect = LegacyRenderUtil.getEffectName(mobEffectInstance);
                    if (!b.booleanValue()) {
                        guiGraphics.method_51448().scale(0.6666667f, 0.6666667f);
                    }
                    guiGraphics.method_27535(LegacyRenderUtil.mc.field_1772, effect, 0, 0, -1);
                    guiGraphics.method_51448().translate(0.0f, 10.0f * (b != false ? 1.0f : 1.5f));
                    guiGraphics.method_27535(LegacyRenderUtil.mc.field_1772, class_1292.method_5577((class_1293)mobEffectInstance, (float)1.0f, (float)LegacyRenderUtil.mc.field_1687.method_54719().method_54748()), 0, 0, -8421505);
                });
                guiGraphics.method_51448().popMatrix();
            }
            FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(class_329.method_71644((class_6880)mobEffectInstance.method_5579()), x + (bl ? 3 : 5), y + 5, 18, 18);
            y -= m;
        }
        if (!bl && mouseX >= x && mouseX <= x + 28) {
            class_1293 mobEffectInstance;
            int n = topPos + imageHeight - 28;
            mobEffectInstance = null;
            for (class_1293 mobEffectInstance2 : iterable) {
                if (mouseY >= n && mouseY <= n + m) {
                    mobEffectInstance = mobEffectInstance2;
                }
                n -= m;
            }
            if (mobEffectInstance != null) {
                List<class_2561> list = List.of(LegacyRenderUtil.getEffectName(mobEffectInstance), class_1292.method_5577((class_1293)mobEffectInstance, (float)1.0f, (float)LegacyRenderUtil.mc.field_1687.method_54719().method_54748()));
                guiGraphics.method_64038(LegacyRenderUtil.mc.field_1772, list, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    public static class_2561 getEffectName(class_1293 mobEffectInstance) {
        class_5250 mutableComponent = ((class_1291)mobEffectInstance.method_5579().comp_349()).method_5560().method_27661();
        if (mobEffectInstance.method_5578() >= 1 && mobEffectInstance.method_5578() <= 9) {
            mutableComponent.method_10852(class_5244.field_41874).method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + (mobEffectInstance.method_5578() + 1))));
        }
        return mutableComponent;
    }

    public static List<class_2561> getTooltip(class_1799 stack) {
        return stack.method_7950(class_1792.class_9635.method_59528((class_1937)LegacyRenderUtil.mc.field_1687), (class_1657)LegacyRenderUtil.mc.field_1724, (class_1836)((Boolean)LegacyOptions.advancedHeldItemTooltip.get() != false ? class_1836.field_41071 : class_1836.field_41070));
    }

    public static List<class_5481> getTooltip(class_1799 stack, int width) {
        return new MultilineTooltip(LegacyRenderUtil.getTooltip(stack), width).method_47405(mc);
    }

    public static void renderHUDTooltip(class_332 guiGraphics, int shift) {
        if (!FactoryGuiElement.SELECTED_ITEM_NAME.isVisible(FactoryScreenUtil.getGuiAccessor()) || LegacyRenderUtil.getSelectedItemTooltipLines() == 0) {
            return;
        }
        LegacyRenderUtil.prepareHUDRender(guiGraphics);
        guiGraphics.method_51448().translate(0.0f, (float)guiGraphics.method_51443() - Math.max((float)shift, LegacyRenderUtil.getHUDSize()));
        FactoryAPIClient.getProfiler().method_15396("selectedItemName");
        LegacyFontUtil.applySDFont(sd -> {
            if (GuiAccessor.getInstance().getToolHighlightTimer() > 0 && !GuiAccessor.getInstance().getLastToolHighlight().method_7960()) {
                class_327 font = LegacyRenderUtil.mc.field_1772;
                List<class_2561> tooltip = LegacyRenderUtil.getTooltip(GuiAccessor.getInstance().getLastToolHighlight());
                tooltip.removeIf(c -> c.getString().isBlank());
                Object2IntMap tooltipLines = (Object2IntMap)tooltip.stream().limit(LegacyRenderUtil.getSelectedItemTooltipLines()).map(c -> tooltip.indexOf(c) == LegacyRenderUtil.getSelectedItemTooltipLines() - 1 && (Boolean)LegacyOptions.itemTooltipEllipsis.get() != false ? ControlTooltip.MORE : c).collect(Collectors.toMap(Function.identity(), arg_0 -> ((class_327)font).method_27525(arg_0), (a, b) -> b, Object2IntLinkedOpenHashMap::new));
                int l = Math.min((int)((float)GuiAccessor.getInstance().getToolHighlightTimer() * 256.0f / 10.0f), 255);
                if (l > 0) {
                    int color = -1 + (Math.round((float)l * LegacyRenderUtil.getHUDOpacity()) << 24);
                    int height = (Integer)LegacyOptions.selectedItemTooltipSpacing.get() * (tooltipLines.size() - 1);
                    guiGraphics.method_51448().translate(0.0f, (float)(-height));
                    if (!((Boolean)LegacyRenderUtil.mc.field_1690.method_42445().method_41753()).booleanValue()) {
                        int backgroundWidth = tooltipLines.values().intStream().max().orElse(0) + 4;
                        int backgroundX = (guiGraphics.method_51421() - backgroundWidth) / 2;
                        FactoryGuiGraphics.of((class_332)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, (float)l / 255.0f);
                        LegacyRenderUtil.renderPointerPanel(guiGraphics, backgroundX, -4, backgroundWidth, height + 15);
                        FactoryGuiGraphics.of((class_332)guiGraphics).clearBlitColor();
                    }
                    tooltipLines.forEach((mutableComponent, width) -> {
                        int x = (guiGraphics.method_51421() - width) / 2;
                        guiGraphics.method_27535(font, mutableComponent, x, 0, color);
                        guiGraphics.method_51448().translate(0.0f, (float)((Integer)LegacyOptions.selectedItemTooltipSpacing.get()).intValue());
                    });
                }
            }
        });
        FactoryAPIClient.getProfiler().method_15407();
        LegacyRenderUtil.finalizeHUDRender(guiGraphics);
    }

    public static void renderGuiEffects(class_332 guiGraphics) {
        Collection collection = LegacyRenderUtil.mc.field_1724.method_6026();
        if (!FactoryGuiElement.EFFECTS.isVisible(FactoryScreenUtil.getGuiAccessor()) || collection.isEmpty()) {
            return;
        }
        int i = 0;
        int j = 0;
        float backAlpha = LegacyRenderUtil.getHUDOpacity();
        for (class_1293 mobEffectInstance : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
            class_6880 mobEffect = mobEffectInstance.method_5579();
            if (!mobEffectInstance.method_5592()) continue;
            int k = guiGraphics.method_51421() - 55;
            int l = 18;
            if (mc.method_1530()) {
                l += 15;
            }
            if (((class_1291)mobEffect.comp_349()).method_5573()) {
                k -= 24 * ++i;
            } else {
                k -= 24 * ++j;
                l += 24;
            }
            float f = 1.0f;
            FactoryGuiGraphics.of((class_332)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, backAlpha);
            LegacyRenderUtil.renderPointerPanel(guiGraphics, k, l, 24, 24);
            if (mobEffectInstance.method_48557(200)) {
                int m = mobEffectInstance.method_5584();
                f = class_3532.method_15363((float)((float)m / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + class_3532.method_15362((float)((float)m * (float)Math.PI / 5.0f)) * class_3532.method_15363((float)((float)(10 - m / 20) / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
            }
            FactoryScreenUtil.enableBlend();
            FactoryGuiGraphics.of((class_332)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, f * backAlpha);
            FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(class_329.method_71644((class_6880)mobEffect), k + 3, l + 3, 18, 18);
            FactoryScreenUtil.disableBlend();
        }
        FactoryGuiGraphics.of((class_332)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderTooltipInternal(class_332 graphics, class_327 font, List<class_5684> list, int i, int j, class_8000 clientTooltipPositioner) {
        class_5684 tooltipComponent;
        int t;
        if (list.isEmpty()) {
            return;
        }
        int k = 0;
        int l = 0;
        for (class_5684 tooltipComponent2 : list) {
            k = Math.max(tooltipComponent2.method_32664(font), k);
            l += tooltipComponent2.method_32661(font);
        }
        Vector2ic vector2ic = clientTooltipPositioner.method_47944(graphics.method_51421(), graphics.method_51443(), i, j, (int)((float)k * LegacyRenderUtil.getTooltipScale()), (int)((float)l * LegacyRenderUtil.getTooltipScale()));
        int p = vector2ic.x();
        int q = vector2ic.y();
        graphics.method_51448().pushMatrix();
        if (p == (int)Legacy4JClient.controllerManager.getPointerX() && q == (int)Legacy4JClient.controllerManager.getPointerY()) {
            graphics.method_51448().translate((float)(Legacy4JClient.controllerManager.getPointerX() - (double)i), (float)(Legacy4JClient.controllerManager.getPointerY() - (double)j));
        }
        int scaledWidth = Math.round(LegacyRenderUtil.getTooltipScale() * (float)k);
        int scaledHeight = Math.round(LegacyRenderUtil.getTooltipScale() * (float)l);
        switch (LegacyOptions.getUIMode()) {
            case FHD: {
                LegacyRenderUtil.renderPointerPanel(graphics, p - 3, q - 6, scaledWidth + 7, scaledHeight + 9);
                break;
            }
            case SD: {
                LegacyRenderUtil.renderPointerPanel(graphics, p - 3, q - 4, scaledWidth + 7, scaledHeight + 6);
                break;
            }
            default: {
                LegacyRenderUtil.renderPointerPanel(graphics, p - 5, q - 9, scaledWidth + 11, scaledHeight + 13);
            }
        }
        graphics.method_51448().translate((float)p, (float)q);
        FactoryScreenUtil.disableDepthTest();
        graphics.method_51448().scale(LegacyRenderUtil.getTooltipScale(), LegacyRenderUtil.getTooltipScale());
        int s = 0;
        for (t = 0; t < list.size(); ++t) {
            tooltipComponent = list.get(t);
            tooltipComponent.method_32665(graphics, font, 0, s);
            s += tooltipComponent.method_32661(font);
        }
        s = 0;
        for (t = 0; t < list.size(); ++t) {
            tooltipComponent = list.get(t);
            tooltipComponent.method_32666(font, 0, s, k, l, graphics);
            s += tooltipComponent.method_32661(font);
        }
        FactoryScreenUtil.enableDepthTest();
        graphics.method_51448().popMatrix();
    }

    public static void renderTopText(class_332 guiGraphics, TopMessage topMessage, int y, float scale, int ticks) {
        if (topMessage != null && ticks < topMessage.ticksOnScreen()) {
            FactoryScreenUtil.disableDepthTest();
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate((float)guiGraphics.method_51421() / 2.0f, (float)y);
            guiGraphics.method_51448().scale(scale, scale);
            if (topMessage.pulse()) {
                float pulse = (float)class_156.method_658() / 400.0f % 1.0f;
                pulse = 1.0f + (pulse > 0.5f ? 1.0f - pulse : pulse) / 10.0f;
                guiGraphics.method_51448().scale(pulse, pulse);
            }
            guiGraphics.method_51448().translate((float)(-LegacyRenderUtil.mc.field_1772.method_27525((class_5348)topMessage.message())) / 2.0f, 0.0f);
            float maxFade = Math.min(topMessage.ticksOnScreen(), 20);
            float fade = topMessage.fade() ? Math.min(1.0f, ((float)topMessage.ticksOnScreen() - ((float)ticks + FactoryAPIClient.getPartialTick())) / maxFade) : 1.0f;
            guiGraphics.method_51439(LegacyRenderUtil.mc.field_1772, topMessage.message(), 0, 0, fade < 1.0f ? ColorUtil.withAlpha((int)topMessage.baseColor(), (float)fade) : topMessage.baseColor(), topMessage.shadow());
            guiGraphics.method_51448().popMatrix();
            FactoryScreenUtil.enableDepthTest();
        }
    }

    public static float getFlyingViewRollingRotation(float original) {
        if (((Boolean)LegacyOptions.flyingViewRolling.get()).booleanValue() && LegacyRenderUtil.mc.field_1724 != null && LegacyRenderUtil.mc.field_1724.method_6128()) {
            float f = FactoryAPIClient.getGamePartialTick((boolean)false);
            class_243 vec3 = LegacyRenderUtil.mc.field_1724.method_5828(f);
            class_243 vec32 = LegacyRenderUtil.mc.field_1724.method_74192().method_74195().method_35590(LegacyRenderUtil.mc.field_1724.method_18798(), (double)f);
            double d = vec32.method_37268();
            double e = vec3.method_37268();
            if (d > 0.0 && e > 0.0) {
                int dir = (int)(-Math.signum(vec32.field_1352 * vec3.field_1350 - vec32.field_1350 * vec3.field_1352));
                float z = (float)Math.min(0.39269908169872414, Math.acos((vec32.field_1352 * vec3.field_1352 + vec32.field_1350 * vec3.field_1350) / Math.sqrt(d * e)) / 2.5);
                if (z > 0.0f) {
                    return (float)dir * z;
                }
            }
        }
        return original;
    }

    public static void renderGameOverlay(class_332 graphics) {
        if (!MinecraftAccessor.getInstance().hasGameLoaded()) {
            return;
        }
        float partialTick = FactoryAPIClient.getPartialTick();
        boolean canRenderElement = LegacyRenderUtil.mc.field_1755 != null || !LegacyRenderUtil.mc.field_1690.field_1842;
        LegacyTip tip = LegacyTipManager.getActualTip();
        if ((!LegacyTipManager.tips.isEmpty() || tip != null) && canRenderElement) {
            if (tip == null) {
                tip = LegacyTipManager.updateTip();
            }
            tip.method_46421(graphics.method_51421() - tip.method_25368() - 30);
            tip.method_25394(graphics, 0, 0, partialTick);
            if (tip.visibility == class_368.class_369.field_2209) {
                LegacyTipManager.updateTip();
            }
        }
        if (((Boolean)LegacyRenderUtil.mc.field_1690.method_42452().method_41753()).booleanValue() && canRenderElement && (LegacyRenderUtil.mc.field_1705.field_35428 > 0.0f || LegacyRenderUtil.mc.field_1705.field_35429 > 0.0f) && (double)class_3532.method_15363((float)class_3532.method_16439((float)FactoryAPIClient.getPartialTick(), (float)LegacyRenderUtil.mc.field_1705.field_35429, (float)LegacyRenderUtil.mc.field_1705.field_35428), (float)0.0f, (float)1.0f) > 0.02) {
            FactoryScreenUtil.disableDepthTest();
            LegacyRenderUtil.drawAutoSavingIcon(graphics, graphics.method_51421() - 66, 44);
            FactoryScreenUtil.enableDepthTest();
        }
        if (GLFW.glfwGetInputMode((long)mc.method_22683().method_4490(), (int)208897) == 212994 && !Legacy4JClient.controllerManager.isCursorDisabled && !LegacyOptions.hasSystemCursor()) {
            graphics.method_51448().pushMatrix();
            graphics.method_51448().translate(Legacy4JClient.controllerManager.getVisualPointerX() + LegacyTipManager.getTipXDiff(), Legacy4JClient.controllerManager.getVisualPointerY());
            FactoryGuiGraphics.of((class_332)graphics).blitSprite(LegacyOptions.getUIMode().isFHD() ? LegacySprites.POINTER : LegacySprites.SMALL_POINTER, -8, -8, 16, 16);
            graphics.method_51448().popMatrix();
        }
    }

    public static void renderPotionLevel(class_332 graphics, int i, int j, class_1799 itemStack) {
        if (!((Boolean)LegacyOptions.legacyPotionsBar.get()).booleanValue()) {
            return;
        }
        int potionLevel = LegacyItemUtil.getPotionLevel(itemStack);
        if (potionLevel > 0) {
            int x = i + 3;
            int y = j + 13;
            graphics.method_25294(x, y, x + 11, y + 2, -16777216);
            for (int k = 0; k < potionLevel; ++k) {
                graphics.method_25294(x + k * 3, y, x + k * 3 + 2, y + 2, -16720411);
            }
        }
    }

    public static class_437 getInitialScreen() {
        class_442 titleScreen = new class_442(((Boolean)LegacyOptions.titleScreenFade.get()).booleanValue());
        if (((Boolean)LegacyOptions.skipInitialSaveWarning.get()).booleanValue()) {
            return titleScreen;
        }
        return ConfirmationScreen.createSaveInfoScreen((class_437)titleScreen);
    }

    public static class_8028 getScreenDirection(double x, double y) {
        if (Math.abs(x) > Math.abs(y)) {
            if (x > 0.0) {
                return class_8028.field_41829;
            }
            if (x < 0.0) {
                return class_8028.field_41828;
            }
        }
        if (y > 0.0) {
            return class_8028.field_41827;
        }
        if (y < 0.0) {
            return class_8028.field_41826;
        }
        return null;
    }

    public static boolean hasHorizontalArtifacts() {
        return isNvidia;
    }

    static {
        iconHolderRenderer = new LegacyIconHolder();
        MINECRAFT = Legacy4J.createModLocation("textures/gui/title/minecraft.png");
        PANORAMA_DAY = Legacy4J.createModLocation("textures/gui/title/panorama_day.png");
        PANORAMA_NIGHT = Legacy4J.createModLocation("textures/gui/title/panorama_night.png");
        MENU_BACKGROUND = Legacy4J.createModLocation("textures/gui/menu_background.png");
        LOADING_BACKGROUND = Legacy4J.createModLocation("textures/gui/loading_background.png");
        logoRenderer = new class_8020(false);
        mc = class_310.method_1551();
        isNvidia = new SystemInfo().getHardware().getGraphicsCards().stream().anyMatch(s -> s.getVendor().contains("nvidia") || s.getVendor().contains("NVIDIA"));
    }
}

