/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelBackgroundScreen;
import wily.legacy.client.screen.RenderableVList;

public class PanelVListScreen
extends PanelBackgroundScreen
implements RenderableVList.Access {
    protected final RenderableVList renderableVList;
    public final List<RenderableVList> renderableVLists;
    public Consumer<PanelVListScreen> onClose;

    public PanelVListScreen(Function<Screen, Panel> panelConstructor, Component component) {
        super(panelConstructor, component);
        this.renderableVList = new RenderableVList(this.accessor);
        this.renderableVLists = new ArrayList<RenderableVList>(Collections.singleton(this.renderableVList));
        this.onClose = s -> {};
    }

    public PanelVListScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component component) {
        super(parent, panelConstructor, component);
        this.renderableVList = new RenderableVList(this.accessor);
        this.renderableVLists = new ArrayList<RenderableVList>(Collections.singleton(this.renderableVList));
        this.onClose = s -> {};
    }

    public PanelVListScreen(Screen parent, int imageWidth, int imageHeight, Component component) {
        super(parent, imageWidth, imageHeight, component);
        this.renderableVList = new RenderableVList(this.accessor);
        this.renderableVLists = new ArrayList<RenderableVList>(Collections.singleton(this.renderableVList));
        this.onClose = s -> {};
    }

    @Override
    protected void init() {
        super.init();
        if (!this.getRenderableVLists().isEmpty()) {
            this.renderableVListInit();
        }
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 10, this.panel.y + 10, this.panel.width - 20, this.panel.height - 20);
    }

    @Override
    public void onClose() {
        super.onClose();
        this.onClose.accept(this);
    }

    @Override
    public List<RenderableVList> getRenderableVLists() {
        return this.renderableVLists;
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        RenderableVList vList = this.getRenderableVListAt(d, e);
        if (vList != null) {
            if (vList.renderables.stream().anyMatch(this.children::contains)) {
                vList.mouseScrolled(g);
            }
        }
        return super.mouseScrolled(d, e, f, g);
    }

    public boolean keyPressed(int i, int j, int k) {
        for (RenderableVList vList : this.getRenderableVLists()) {
            if (!vList.keyPressed(i)) continue;
            return true;
        }
        return super.keyPressed(i, j, k);
    }
}

