/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.worldselection.PresetEditor;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.FireworkRocketRenderState;
import net.minecraft.client.renderer.entity.state.GhastRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.ThrownTridentRenderState;
import net.minecraft.client.renderer.entity.state.VillagerRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RegisterPresetEditorsEvent;
import org.apache.commons.io.FileUtils;
import org.joml.Quaternionfc;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.client.FactoryRenderStateExtension;
import wily.factoryapi.base.client.GuiAccessor;
import wily.factoryapi.base.client.SpectatorGuiAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.config.FactoryMixinToggle;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryGuiElement;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.ModInfo;
import wily.legacy.Legacy4J;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.client.BackupConfirmScreenAccessor;
import wily.legacy.client.BufferSourceWrapper;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.DisconnectedScreenAccessor;
import wily.legacy.client.KnownListing;
import wily.legacy.client.LegacyBiomeOverride;
import wily.legacy.client.LegacyCraftingTabListing;
import wily.legacy.client.LegacyCreativeTabListing;
import wily.legacy.client.LegacyFireworkRenderState;
import wily.legacy.client.LegacyLivingEntityRenderState;
import wily.legacy.client.LegacyMixinOptions;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyResourceManager;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.LegacyTipOverride;
import wily.legacy.client.LegacyVillagerRenderState;
import wily.legacy.client.LegacyWorldTemplate;
import wily.legacy.client.LevelRendererAccessor;
import wily.legacy.client.LoomTabListing;
import wily.legacy.client.LoyaltyLinesRenderState;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.client.StoneCuttingGroupManager;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.ControllerManager;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreativeModeScreen;
import wily.legacy.client.screen.HostOptionsScreen;
import wily.legacy.client.screen.HowToPlayScreen;
import wily.legacy.client.screen.LeaderboardsScreen;
import wily.legacy.client.screen.Legacy4JSettingsScreen;
import wily.legacy.client.screen.LegacyBuffetWorldScreen;
import wily.legacy.client.screen.LegacyCraftingScreen;
import wily.legacy.client.screen.LegacyFlatWorldScreen;
import wily.legacy.client.screen.LegacyLoadingScreen;
import wily.legacy.client.screen.LegacyLoomScreen;
import wily.legacy.client.screen.LegacyMerchantScreen;
import wily.legacy.client.screen.LegacyScreen;
import wily.legacy.client.screen.LegacyStonecutterScreen;
import wily.legacy.client.screen.MixedCraftingScreen;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.client.screen.ReplaceableScreen;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.compat.IrisCompat;
import wily.legacy.client.screen.compat.SodiumCompat;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.init.LegacyUIElementTypes;
import wily.legacy.inventory.LegacyPistonMovingBlockEntity;
import wily.legacy.network.ServerOpenClientMenuPayload;
import wily.legacy.network.TopMessage;
import wily.legacy.util.MCAccount;
import wily.legacy.util.ScreenUtil;

public class Legacy4JClient {
    public static boolean isNewerVersion = false;
    public static boolean isNewerMinecraftVersion = false;
    public static final List<Runnable> whenResetOptions = new ArrayList<Runnable>();
    public static LevelStorageSource currentWorldSource;
    public static boolean legacyFont;
    public static boolean forceVanillaFontShadowColor;
    public static ResourceLocation defaultFontOverride;
    public static ControlType lastControlType;
    public static boolean manualSave;
    public static boolean saveExit;
    public static boolean retakeWorldIcon;
    public static LegacyLoadingScreen legacyLoadingScreen;
    public static Renderable itemActivationRenderReplacement;
    public static final LegacyTipManager legacyTipManager;
    public static final LegacyCreativeTabListing.Manager legacyCreativeListingManager;
    public static final LegacyCraftingTabListing.Manager legacyCraftingListingManager;
    public static final LegacyBiomeOverride.Manager legacyBiomeOverrides;
    public static final LegacyWorldTemplate.Manager legacyWorldTemplateManager;
    public static final LegacyTipOverride.Manager legacyTipOverridesManager;
    public static final LegacyResourceManager legacyResourceManager;
    public static final StoneCuttingGroupManager stoneCuttingGroupManager;
    public static final LoomTabListing.Manager loomListingManager;
    public static final ControlTooltip.GuiManager controlTooltipGuiManager;
    public static final LeaderboardsScreen.Manager leaderBoardListingManager;
    public static final HowToPlayScreen.Manager howToPlaySectionManager;
    public static final ControllerManager controllerManager;
    public static final Map<Block, ResourceLocation> fastLeavesModels;
    public static KnownListing<Block> knownBlocks;
    public static KnownListing<EntityType<?>> knownEntities;
    public static GameType defaultServerGameType;
    public static GameRules gameRules;
    public static Consumer<ServerPlayer> serverPlayerJoinConsumer;
    public static final FactoryConfig.StorageHandler MIXIN_CONFIGS_STORAGE;
    public static final RenderType GHAST_SHOOTING_GLOW;
    public static final RenderType DROWNED_GLOW;
    public static final Map<Optional<ResourceKey<WorldPreset>>, PresetEditor> VANILLA_PRESET_EDITORS;
    public static final KeyMapping keyCrafting;
    public static final KeyMapping keyCycleHeldLeft;
    public static final KeyMapping keyCycleHeldRight;
    public static final KeyMapping keyToggleCursor;
    public static KeyMapping keyHostOptions;
    public static KeyMapping keyLegacy4JSettings;
    public static KeyMapping keyFlyUp;
    public static KeyMapping keyFlyDown;
    public static KeyMapping keyFlyLeft;
    public static KeyMapping keyFlyRight;

    public static float[] getVisualPlayerColor(LegacyPlayerInfo info) {
        return Legacy4JClient.getVisualPlayerColor(info.getIdentifierIndex() >= 0 ? info.getIdentifierIndex() : info.legacyMinecraft$getProfile().getId().hashCode());
    }

    public static PostChain getGammaEffect() {
        return Minecraft.getInstance().getShaderManager().getPostChain(LegacyResourceManager.GAMMA_LOCATION, LevelTargetBundle.MAIN_TARGETS);
    }

    public static float[] getVisualPlayerColor(int i) {
        PlayerIdentifier playerIdentifier = PlayerIdentifier.of(i);
        if (PlayerIdentifier.list.containsKey(i)) {
            return new float[]{(float)(playerIdentifier.color() >> 16 & 0xFF) / 255.0f, (float)(playerIdentifier.color() >> 8 & 0xFF) / 255.0f, (float)(playerIdentifier.color() & 0xFF) / 255.0f};
        }
        float r = (float)(playerIdentifier.color() >> 16 & 0xFF) * (0.8f + (float)(i % 15) / 30.0f) / 255.0f;
        float g = (float)(playerIdentifier.color() >> 8 & 0xFF) * (1.2f - (float)(i % 16) / 32.0f) / 255.0f;
        float b = (float)(playerIdentifier.color() & 0xFF) * (0.8f + (float)(i % 17) / 34.0f) / 255.0f;
        return new float[]{r, g, b};
    }

    public static void updateLegacyPlayerInfos(Map<UUID, LegacyPlayerInfo> map) {
        Minecraft minecraft = Minecraft.getInstance();
        map.forEach((s, i) -> {
            PlayerInfo patt0$temp;
            if (minecraft.getConnection() != null && (patt0$temp = minecraft.getConnection().getPlayerInfo(s)) instanceof LegacyPlayerInfo) {
                LegacyPlayerInfo info = (LegacyPlayerInfo)patt0$temp;
                info.copyFrom((LegacyPlayerInfo)i);
            }
        });
        LeaderboardsScreen.refreshStatsBoards(minecraft);
        Screen screen = minecraft.screen;
        if (screen instanceof LeaderboardsScreen) {
            LeaderboardsScreen s2 = (LeaderboardsScreen)screen;
            if (LeaderboardsScreen.statsBoards.get((int)s2.selectedStatBoard).statsList.isEmpty()) {
                minecraft.executeIfPossible(() -> s2.changeStatBoard(false));
            }
        }
        if (minecraft.player != null) {
            LegacyOptions.classicCrafting.set((Object)((Boolean)LegacyOptions.classicCrafting.get()));
            LegacyOptions.classicTrading.set((Object)((Boolean)LegacyOptions.classicTrading.get()));
            LegacyOptions.classicStonecutting.set((Object)((Boolean)LegacyOptions.classicStonecutting.get()));
            LegacyOptions.classicLoom.set((Object)((Boolean)LegacyOptions.classicLoom.get()));
        }
    }

    public static void displayActivationAnimation(Renderable renderable) {
        itemActivationRenderReplacement = renderable;
        Minecraft.getInstance().gameRenderer.displayItemActivation(ItemStack.EMPTY);
    }

    public static void applyFontOverrideIf(boolean b, ResourceLocation override, Consumer<Boolean> fontRender) {
        if (b) {
            defaultFontOverride = override;
        }
        fontRender.accept(b);
        if (b) {
            defaultFontOverride = null;
        }
    }

    public static LevelStorageSource getLevelStorageSource() {
        return (Boolean)LegacyOptions.saveCache.get() != false ? currentWorldSource : Minecraft.getInstance().getLevelSource();
    }

    public static boolean hasSaveSystem(Minecraft minecraft) {
        return minecraft.hasSingleplayerServer() && !minecraft.isDemo() && !minecraft.getSingleplayerServer().isHardcore() && Legacy4JClient.isCurrentWorldSource(minecraft.getSingleplayerServer().storageSource);
    }

    public static boolean isCurrentWorldSource(LevelStorageSource.LevelStorageAccess storageSource) {
        return storageSource.getDimensionPath(Level.OVERWORLD).getParent().equals(currentWorldSource.getBaseDir());
    }

    public static boolean playerHasInfiniteMaterials() {
        return Minecraft.getInstance().player.hasInfiniteMaterials();
    }

    public static void saveLevel(LevelStorageSource.LevelStorageAccess storageSource) {
        if (Legacy4JClient.isCurrentWorldSource(storageSource)) {
            Legacy4JClient.copySaveBtwSources(storageSource, Minecraft.getInstance().getLevelSource());
        }
    }

    public static void displayEffectActivationAnimation(Holder<MobEffect> effect) {
        Legacy4JClient.displayActivationAnimation((guiGraphics, i, j, f) -> {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(0, 1, 0, 1, -1, Minecraft.getInstance().getMobEffectTextures().get(effect));
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.5f, 0.5f, 0.0f);
            guiGraphics.pose().mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            guiGraphics.pose().translate(-0.5f, -0.5f, 0.0f);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(0, 0, 0, 1, 1, Minecraft.getInstance().getMobEffectTextures().get(effect));
            guiGraphics.pose().popPose();
            guiGraphics.pose().popPose();
        });
    }

    public static Screen getReplacementScreen(Screen screen) {
        if (!((Boolean)LegacyMixinOptions.legacyTitleScreen.get()).booleanValue()) {
            return screen;
        }
        if (screen instanceof JoinMultiplayerScreen) {
            return new PlayGameScreen((Screen)new TitleScreen(), 2);
        }
        if (screen instanceof DisconnectedScreen) {
            DisconnectedScreen s = (DisconnectedScreen)screen;
            return ConfirmationScreen.createInfoScreen(Legacy4JClient.getReplacementScreen(DisconnectedScreenAccessor.of(s).getParent()), s.getTitle(), DisconnectedScreenAccessor.of(s).getReason());
        }
        if (screen instanceof AlertScreen) {
            final AlertScreen s = (AlertScreen)screen;
            return new ConfirmationScreen(Minecraft.getInstance().screen, 230, 97, s.getTitle(), s.messageText, LegacyScreen::onClose){

                @Override
                protected void addButtons() {
                    this.okButton = Button.builder((Component)Component.translatable((String)"gui.ok"), b -> s2.callback.run()).bounds(this.panel.x + 15, this.panel.y + this.panel.height - 30, 200, 20).build();
                    this.renderableVList.addRenderable((Renderable)this.okButton);
                }

                public boolean shouldCloseOnEsc() {
                    return s.shouldCloseOnEsc();
                }
            };
        }
        if (screen instanceof BackupConfirmScreen) {
            final BackupConfirmScreen s = (BackupConfirmScreen)screen;
            return new ConfirmationScreen(Minecraft.getInstance().screen, 230, 141 + (BackupConfirmScreenAccessor.of(s).hasCacheErase() ? 14 : 0), s.getTitle(), BackupConfirmScreenAccessor.of(s).getDescription(), LegacyScreen::onClose){
                boolean eraseCache;
                {
                    super(parent, imageWidth, baseHeight, title, message, okAction);
                    this.eraseCache = false;
                }

                @Override
                protected void addButtons() {
                    if (BackupConfirmScreenAccessor.of(s).hasCacheErase()) {
                        this.renderableVList.addRenderable((Renderable)new TickBox(this.panel.x + 15, this.panel.y + this.panel.height - 88, this.eraseCache, b -> Component.translatable((String)"selectWorld.backupEraseCache"), b -> null, b -> {
                            this.eraseCache = b.selected;
                        }));
                    }
                    this.okButton = Button.builder((Component)Component.translatable((String)"selectWorld.backupJoinConfirmButton"), b -> BackupConfirmScreenAccessor.of(s).proceed(true, this.eraseCache)).build();
                    this.renderableVList.addRenderable((Renderable)this.okButton);
                    this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"selectWorld.backupJoinSkipButton"), b -> BackupConfirmScreenAccessor.of(s).proceed(false, this.eraseCache)).build());
                    this.renderableVList.addRenderable((Renderable)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> this.onClose()).build());
                }

                @Override
                public void onClose() {
                    BackupConfirmScreenAccessor.of(s).cancel();
                }
            };
        }
        return screen;
    }

    public static void preTick(Minecraft minecraft) {
        boolean left;
        ReplaceableScreen r;
        Screen screen;
        ControlType activeControlType = ControlType.getActiveType();
        if (lastControlType != activeControlType) {
            if (lastControlType != null) {
                ((ControlType.UpdateEvent)ControlType.UpdateEvent.EVENT.invoker).change(lastControlType, activeControlType);
            }
            lastControlType = activeControlType;
        }
        if ((screen = minecraft.screen) instanceof ReplaceableScreen && (r = (ReplaceableScreen)screen).canReplace()) {
            minecraft.setScreen(r.getReplacement());
        }
        if (((Boolean)LegacyOptions.unfocusedInputs.get()).booleanValue()) {
            minecraft.setWindowActive(true);
        }
        while (keyCrafting.consumeClick()) {
            if (minecraft.player != null && (minecraft.player.isCreative() || minecraft.player.isSpectator())) {
                if (minecraft.player.isSpectator()) {
                    minecraft.gui.getSpectatorGui().onMouseMiddleClick();
                    continue;
                }
                minecraft.setScreen(CreativeModeScreen.getActualCreativeScreenInstance(minecraft));
                continue;
            }
            if (ScreenUtil.hasClassicCrafting()) {
                minecraft.getTutorial().onOpenInventory();
                minecraft.setScreen((Screen)new InventoryScreen((Player)minecraft.player));
                continue;
            }
            screen = minecraft.hitResult;
            if (screen instanceof BlockHitResult && minecraft.level.getBlockState((r = (BlockHitResult)screen).getBlockPos()).getBlock() instanceof CraftingTableBlock) {
                minecraft.gameMode.useItemOn(minecraft.player, InteractionHand.MAIN_HAND, (BlockHitResult)r);
                continue;
            }
            if (ScreenUtil.hasMixedCrafting()) {
                minecraft.setScreen(MixedCraftingScreen.playerCraftingScreen((Player)minecraft.player));
                continue;
            }
            CommonNetwork.sendToServer((CommonNetwork.Payload)ServerOpenClientMenuPayload.playerCrafting());
        }
        while (keyHostOptions.consumeClick()) {
            minecraft.setScreen((Screen)new HostOptionsScreen());
        }
        while (keyLegacy4JSettings.consumeClick()) {
            minecraft.setScreen((Screen)new Legacy4JSettingsScreen(Minecraft.getInstance().screen));
        }
        while ((left = keyCycleHeldLeft.consumeClick()) || keyCycleHeldRight.consumeClick()) {
            if (minecraft.player == null) continue;
            if (minecraft.player.isSpectator()) {
                if (!minecraft.gui.getSpectatorGui().isMenuActive()) continue;
                minecraft.gui.getSpectatorGui().onMouseScrolled(left ? -1 : 1);
                continue;
            }
            minecraft.player.getInventory().setSelectedSlot(Stocker.cyclic((int)0, (int)(minecraft.player.getInventory().getSelectedSlot() + (left ? -1 : 1)), (int)9));
        }
        if (!Minecraft.getInstance().isPaused()) {
            TopMessage.tick();
        }
    }

    public static void postTick(Minecraft minecraft) {
        if (minecraft.level != null && minecraft.screen == null && ((Boolean)LegacyOptions.hints.get()).booleanValue() && LegacyTipManager.getActualTip() == null) {
            EntityHitResult r;
            Entity e;
            HitResult hit = minecraft.hitResult;
            if (hit instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hit;
                BlockState state = minecraft.level.getBlockState(blockHitResult.getBlockPos());
                if (!state.isAir() && !(state.getBlock() instanceof LiquidBlock) && state.getBlock().asItem() instanceof BlockItem && !knownBlocks.contains(state.getBlock()) && LegacyTipManager.setTip(LegacyTipManager.getTip(state.getBlock().asItem().getDefaultInstance()))) {
                    knownBlocks.add(state.getBlock());
                }
            } else if (hit instanceof EntityHitResult && !knownEntities.contains((e = (r = (EntityHitResult)hit).getEntity()).getType()) && LegacyTipManager.setTip(LegacyTipManager.getTip(e))) {
                knownEntities.add(r.getEntity().getType());
            }
        }
    }

    public static void postScreenInit(Screen screen) {
        if (screen.getFocused() != null && !screen.children().contains(screen.getFocused())) {
            screen.clearFocus();
        }
        if ((Minecraft.getInstance().getLastInputType().isKeyboard() || Legacy4JClient.controllerManager.connectedController != null || controllerManager.getCursorMode().isNever()) && !controllerManager.getCursorMode().isAlways()) {
            ComponentPath path;
            Controller.Event e = Controller.Event.of(screen);
            if (e.disableCursorOnInit() && !controllerManager.getCursorMode().isAlways()) {
                controllerManager.disableCursor();
            }
            if (Legacy4JClient.controllerManager.isCursorDisabled && (!e.disableCursorOnInit() || controllerManager.getCursorMode().isAlways())) {
                controllerManager.enableCursorAndScheduleReset();
            }
            if (!(screen.getFocused() != null && screen.getFocused().isFocused() || (path = screen.nextFocusPath((FocusNavigationEvent)new FocusNavigationEvent.ArrowNavigation(ScreenDirection.DOWN))) == null)) {
                path.applyFocus(true);
            }
        }
        controllerManager.resetCursor();
    }

    public static void clientPlayerJoin(LocalPlayer p) {
        gameRules = new GameRules(p.connection.enabledFeatures());
        LegacyCreativeTabListing.rebuildVanillaCreativeTabsItems(Minecraft.getInstance());
    }

    public static void serverPlayerJoin(ServerPlayer player) {
        if (serverPlayerJoinConsumer != null) {
            serverPlayerJoinConsumer.accept(player);
            serverPlayerJoinConsumer = null;
        }
    }

    public static void init() {
        ControlType.UpdateEvent.EVENT.register((last, actual) -> {
            UIAccessor uiAccessor = Minecraft.getInstance().screen == null ? FactoryScreenUtil.getGuiAccessor() : FactoryScreenUtil.getScreenAccessor();
            uiAccessor.reloadUI();
            LegacyTipManager.rebuildActual();
        });
        FactoryAPIClient.registerKeyMapping(registry -> {
            registry.accept(keyCrafting);
            registry.accept(keyHostOptions);
            registry.accept(keyLegacy4JSettings);
            registry.accept(keyCycleHeldLeft);
            registry.accept(keyCycleHeldRight);
            registry.accept(keyToggleCursor);
            registry.accept(keyFlyUp);
            registry.accept(keyFlyDown);
            registry.accept(keyFlyLeft);
            registry.accept(keyFlyRight);
        });
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyTipManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyCreativeListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyCraftingListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyWorldTemplateManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyTipOverridesManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyBiomeOverrides);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyResourceManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)stoneCuttingGroupManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)loomListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)controlTooltipGuiManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)leaderBoardListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)howToPlaySectionManager);
        FactoryAPIClient.setup(m -> {
            MCAccount.loadAll();
            controllerManager.setup((Minecraft)m);
            FactoryOptions.NEAREST_MIPMAP_SCALING.set((Object)true);
            FactoryOptions.RANDOM_BLOCK_ROTATIONS.set((Object)false);
            knownBlocks = new KnownListing(BuiltInRegistries.BLOCK, m.gameDirectory.toPath());
            knownEntities = new KnownListing(BuiltInRegistries.ENTITY_TYPE, m.gameDirectory.toPath());
            currentWorldSource = LevelStorageSource.createDefault((Path)m.gameDirectory.toPath().resolve("current-world"));
            ControllerBinding.setupDefaultBindings(m);
            LegacyOptions.CLIENT_STORAGE.load();
            FactoryAPIClient.registerRenderType((RenderType)RenderType.cutoutMipped(), (Block[])new Block[]{(Block)LegacyRegistries.SHRUB.get()});
            FactoryAPIClient.registerRenderType((RenderType)RenderType.translucent(), (Block[])new Block[]{Blocks.WATER});
            if (FactoryAPI.isModLoaded((String)"sodium")) {
                SodiumCompat.init();
            }
            if (FactoryAPI.isModLoaded((String)"iris")) {
                IrisCompat.init();
            }
            String[] nonScaledElements = new String[]{FactoryGuiElement.SELECTED_ITEM_NAME.name(), FactoryGuiElement.OVERLAY_MESSAGE.name(), FactoryGuiElement.SPECTATOR_TOOLTIP.name()};
            ArbitrarySupplier hudScale = () -> Float.valueOf(3.0f / ScreenUtil.getHUDScale());
            ArbitrarySupplier crosshairScale = () -> {
                float f;
                if (ScreenUtil.getStandardHeight() >= 1080) {
                    switch ((Integer)LegacyOptions.hudScale.get()) {
                        case 1: 
                        case 2: {
                            f = 0.9f;
                            break;
                        }
                        default: {
                            f = 1.0f;
                            break;
                        }
                    }
                } else {
                    f = 1.0f;
                }
                return Float.valueOf(f);
            };
            UIAccessor accessor = FactoryScreenUtil.getGuiAccessor();
            FactoryGuiElement.HOTBAR.pre().register(guiGraphics -> {
                int newSelection;
                ScreenUtil.renderAnimatedCharacter(guiGraphics);
                int n = newSelection = Minecraft.getInstance().player != null ? Minecraft.getInstance().player.getInventory().getSelectedSlot() : -1;
                if (ScreenUtil.lastHotbarSelection >= 0 && ScreenUtil.lastHotbarSelection != newSelection) {
                    ScreenUtil.lastHotbarSelectionChange = Util.getMillis();
                }
                ScreenUtil.lastHotbarSelection = newSelection;
                if ((double)ColorUtil.getAlpha((int)FactoryGuiElement.HOTBAR.getColor(accessor)) < 1.0) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).pushBufferSource((MultiBufferSource.BufferSource)BufferSourceWrapper.translucent(FactoryGuiGraphics.of((GuiGraphics)guiGraphics).getBufferSource()));
                }
            });
            FactoryGuiElement.HOTBAR.post().register(guiGraphics -> {
                if ((double)ColorUtil.getAlpha((int)FactoryGuiElement.HOTBAR.getColor(accessor)) < 1.0) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).popBufferSource();
                }
                if (Minecraft.getInstance().player != null) {
                    ControlTooltip.Renderer.of(Minecraft.getInstance().gui).render(guiGraphics, 0, 0, FactoryAPIClient.getPartialTick());
                }
                ScreenUtil.renderTopText(guiGraphics, TopMessage.small, 21, 1.0f, TopMessage.smallTicks);
                ScreenUtil.renderTopText(guiGraphics, TopMessage.medium, 37, 1.5f, TopMessage.mediumTicks);
            });
            FactoryGuiElement.SPECTATOR_HOTBAR.pre().register(guiGraphics -> {
                legacyFont = false;
                ScreenUtil.renderAnimatedCharacter(guiGraphics);
            });
            FactoryGuiElement.SPECTATOR_HOTBAR.post().register(guiGraphics -> {
                legacyFont = true;
            });
            accessor.getStaticDefinitions().add(UIDefinition.createBeforeInit(a -> {
                if (!((Boolean)LegacyMixinOptions.legacyGui.get()).booleanValue()) {
                    return;
                }
                a.getElements().put((Object)(FactoryGuiElement.VIGNETTE.name() + ".isVisible"), () -> false);
                a.getElements().put((Object)"isGuiVisible", () -> Minecraft.getInstance().screen == null);
                a.getElements().put((Object)"hud.scaleX", (Object)hudScale);
                a.getElements().put((Object)"hud.scaleY", (Object)hudScale);
                a.getElements().put((Object)"hud.scaleZ", (Object)hudScale);
                a.getElements().put((Object)"hud.translateX", () -> Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2);
                a.getElements().put((Object)"hud.scaledTranslateX", () -> -Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2);
                a.getElements().put((Object)"hud.translateY", () -> (double)Minecraft.getInstance().getWindow().getGuiScaledHeight() + ScreenUtil.getHUDDistance());
                a.getElements().put((Object)"hud.scaledTranslateY", () -> -Minecraft.getInstance().getWindow().getGuiScaledHeight());
                a.getElements().put((Object)"hud.renderColor", () -> ColorUtil.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)ScreenUtil.getHUDOpacity()));
                a.getElements().put((Object)(FactoryGuiElement.BOSSHEALTH.name() + ".renderColor"), () -> ColorUtil.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)ScreenUtil.getInterfaceOpacity()));
                a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".scaleX"), (Object)crosshairScale);
                a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".scaleY"), (Object)crosshairScale);
                a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".scaleZ"), (Object)crosshairScale);
                a.putStaticElement(FactoryGuiElement.CROSSHAIR.name() + ".hud.translateY", (Object)false);
                a.putStaticElement(FactoryGuiElement.CROSSHAIR.name() + ".hud.scaledTranslateY", (Object)false);
                a.getElements().put((Object)(FactoryGuiElement.SPECTATOR_HOTBAR.name() + ".translateY"), () -> (22.0 - ScreenUtil.getHUDDistance()) * (double)(1.0f - SpectatorGuiAccessor.getInstance().getVisibility()));
                a.getElements().put((Object)(FactoryGuiElement.SPECTATOR_TOOLTIP.name() + ".translateY"), () -> (22.0 - ScreenUtil.getHUDDistance()) * (double)(1.0f - SpectatorGuiAccessor.getInstance().getVisibility()) + 35.0 - (double)ScreenUtil.getHUDSize() + ScreenUtil.getHUDDistance());
                for (String element : nonScaledElements) {
                    a.putStaticElement(element + ".hud.translateX", (Object)false);
                    a.putStaticElement(element + ".hud.translateY", (Object)false);
                    a.putStaticElement(element + ".hud.scaledTranslateX", (Object)false);
                    a.putStaticElement(element + ".hud.scaledTranslateY", (Object)false);
                    a.putStaticElement(element + ".hud.scale", (Object)false);
                }
                a.getElements().put((Object)(FactoryGuiElement.OVERLAY_MESSAGE.name() + ".translateY"), () -> ScreenUtil.getHUDDistance() + 72.0 - (double)((Integer)LegacyOptions.selectedItemTooltipSpacing.get()).intValue() - (double)ScreenUtil.getHUDSize() - (double)(GuiAccessor.getInstance().getLastToolHighlight().isEmpty() || GuiAccessor.getInstance().getToolHighlightTimer() <= 0 || ScreenUtil.getSelectedItemTooltipLines() == 0 ? 0 : (Math.min(ScreenUtil.getSelectedItemTooltipLines() + 1, ScreenUtil.getTooltip(GuiAccessor.getInstance().getLastToolHighlight()).stream().filter(c -> !c.getString().isEmpty()).mapToInt(c -> 1).sum()) - 1) * (Integer)LegacyOptions.selectedItemTooltipSpacing.get()));
                a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".translateY"), () -> Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2);
                a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".scaledTranslateY"), () -> -Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2);
            }));
            FactoryAPIClient.uiDefinitionManager.staticList.add(UIDefinition.createBeforeInit(a -> {
                CommonValue.COMMON_VALUES.forEach((s, c) -> a.getElements().put((Object)("commonValue." + (String)(s.getNamespace().equals("minecraft") ? "" : s.getNamespace() + ".") + s.getPath()), (Object)c));
                CommonColor.COMMON_COLORS.forEach((s, c) -> a.getElements().put((Object)("commonColor." + (String)(s.getNamespace().equals("minecraft") ? "" : s.getNamespace() + ".") + s.getPath()), (Object)c));
                ControlTooltip.commonIcons.forEach((s, i) -> a.getElements().put((Object)("controlIcon." + s), (Object)i.map(ControlTooltip.ComponentIcon::getComponent)));
                for (KeyMapping keyMapping : Minecraft.getInstance().options.keyMappings) {
                    a.getElements().put((Object)("controlIcon." + keyMapping.getName()), () -> ControlTooltip.getIconComponentFromKeyMapping(LegacyKeyMapping.of(keyMapping)));
                }
                a.getElements().put((Object)"interfaceResolution", ScreenUtil::getInterfaceResolution);
                ControlType.types.forEach((s, c) -> a.getElements().put((Object)("activeControlType." + s), () -> ControlType.getActiveType().equals(c)));
            }));
        });
        FactoryAPIClient.registerBlockColor(registry -> {
            registry.accept((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter == null || blockPos == null ? GrassColor.getDefaultColor() : BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos), (Block)LegacyRegistries.SHRUB.get());
            registry.accept((blockState, blockAndTintGetter, blockPos, i) -> {
                if (blockAndTintGetter != null && blockPos != null) {
                    LegacyPistonMovingBlockEntity e;
                    BlockEntity blockEntity = blockAndTintGetter.getBlockEntity(blockPos);
                    if (blockEntity instanceof LegacyPistonMovingBlockEntity && (e = (LegacyPistonMovingBlockEntity)blockEntity).getRenderingBlockEntity() != null && ((Boolean)LegacyOptions.enhancedPistonMovingRenderer.get()).booleanValue()) {
                        blockEntity = e.getRenderingBlockEntity();
                    }
                    if (blockEntity instanceof WaterCauldronBlockEntity) {
                        WaterCauldronBlockEntity be = (WaterCauldronBlockEntity)blockEntity;
                        if (!be.hasWater()) {
                            return PotionContents.getColorOptional((Iterable)((Potion)be.potion.value()).getEffects()).orElse(-13083194);
                        }
                        if (be.waterColor != null) {
                            return be.waterColor;
                        }
                    }
                    return BiomeColors.getAverageWaterColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos);
                }
                return -1;
            }, Blocks.WATER_CAULDRON);
        });
        fastLeavesModels.put(Blocks.OAK_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_oak_leaves"));
        fastLeavesModels.put(Blocks.SPRUCE_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_spruce_leaves"));
        fastLeavesModels.put(Blocks.BIRCH_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_birch_leaves"));
        fastLeavesModels.put(Blocks.JUNGLE_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_jungle_leaves"));
        fastLeavesModels.put(Blocks.ACACIA_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_acacia_leaves"));
        fastLeavesModels.put(Blocks.CHERRY_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_cherry_leaves"));
        fastLeavesModels.put(Blocks.DARK_OAK_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_dark_oak_leaves"));
        fastLeavesModels.put(Blocks.MANGROVE_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_mangrove_leaves"));
        fastLeavesModels.put(Blocks.PALE_OAK_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_pale_oak_leaves"));
        fastLeavesModels.put(Blocks.AZALEA_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_azalea_leaves"));
        fastLeavesModels.put(Blocks.FLOWERING_AZALEA_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_flowering_azalea_leaves"));
        FactoryAPIClient.registerExtraModels(register -> fastLeavesModels.values().forEach(register));
        FactoryAPIClient.registerMenuScreen(registry -> {
            registry.register((MenuType)LegacyRegistries.CRAFTING_PANEL_MENU.get(), LegacyCraftingScreen::craftingScreen);
            registry.register((MenuType)LegacyRegistries.PLAYER_CRAFTING_PANEL_MENU.get(), LegacyCraftingScreen::playerCraftingScreen);
            registry.register((MenuType)LegacyRegistries.LOOM_PANEL_MENU.get(), LegacyLoomScreen::new);
            registry.register((MenuType)LegacyRegistries.STONECUTTER_PANEL_MENU.get(), LegacyStonecutterScreen::new);
            registry.register((MenuType)LegacyRegistries.MERCHANT_MENU.get(), LegacyMerchantScreen::new);
        });
        FactoryAPIClient.preTick(Legacy4JClient::preTick);
        FactoryAPIClient.postTick(Legacy4JClient::postTick);
        FactoryAPIClient.PlayerEvent.JOIN_EVENT.register(Legacy4JClient::clientPlayerJoin);
        FactoryAPIClient.STOPPING.register(m -> {
            knownBlocks.save();
            knownEntities.save();
            PackAlbum.applyDefaultResourceAlbum();
            LegacyOptions.lastLoadedVersion.set((Object)Legacy4J.VERSION.get());
            LegacyOptions.lastLoadedMinecraftVersion.set((Object)SharedConstants.getCurrentVersion().getName());
            LegacyOptions.CLIENT_STORAGE.save();
        });
        FactoryEvent.ServerSave.EVENT.register((server, log, flush, force) -> {
            retakeWorldIcon = true;
            knownBlocks.save();
            knownEntities.save();
        });
        FactoryEvent.registerBuiltInPacks(registry -> {
            registry.registerResourcePack(FactoryAPI.createLocation((String)"legacy", (String)"legacy_waters"), true);
            registry.registerResourcePack(FactoryAPI.createLocation((String)"legacy", (String)"console_aspects"), false);
            if (FactoryAPI.getLoader().isForgeLike()) {
                registry.register("programmer_art", FactoryAPI.createLocation((String)"legacy", (String)"programmer_art"), (Component)Component.translatable((String)"legacy.builtin.console_programmer"), Pack.Position.TOP, false);
                registry.register("high_contrast", FactoryAPI.createLocation((String)"legacy", (String)"high_contrast"), (Component)Component.translatable((String)"legacy.builtin.high_contrast"), Pack.Position.TOP, false);
            }
        });
        LegacyUIElementTypes.init();
        FactoryRenderStateExtension.types.add(new FactoryRenderStateExtension.Type(ThrownTridentRenderState.class, LoyaltyLinesRenderState::new));
        FactoryRenderStateExtension.types.add(new FactoryRenderStateExtension.Type(FireworkRocketRenderState.class, LegacyFireworkRenderState::new));
        FactoryRenderStateExtension.types.add(new FactoryRenderStateExtension.Type(LivingEntityRenderState.class, LegacyLivingEntityRenderState::new));
        FactoryRenderStateExtension.types.add(new FactoryRenderStateExtension.Type(VillagerRenderState.class, LegacyVillagerRenderState::new));
        FactoryAPIClient.registerRenderLayer(r -> {
            EntityRenderer patt1$temp;
            GhastRenderer renderer;
            EntityRenderer patt0$temp = r.getEntityRenderer(EntityType.GHAST);
            if (patt0$temp instanceof GhastRenderer) {
                renderer = (GhastRenderer)patt0$temp;
                r.register((LivingEntityRenderer)renderer, (RenderLayer)new EyesLayer<GhastRenderState, GhastModel>((RenderLayerParent)renderer){

                    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, GhastRenderState ghastRenderState, float f, float g) {
                        if (!ghastRenderState.isCharging) {
                            return;
                        }
                        super.render(poseStack, multiBufferSource, i, (EntityRenderState)ghastRenderState, f, g);
                    }

                    public RenderType renderType() {
                        return GHAST_SHOOTING_GLOW;
                    }
                });
            }
            if ((patt1$temp = r.getEntityRenderer(EntityType.DROWNED)) instanceof DrownedRenderer) {
                renderer = (DrownedRenderer)patt1$temp;
                r.register((LivingEntityRenderer)renderer, (RenderLayer)new EyesLayer<ZombieRenderState, DrownedModel>((RenderLayerParent)renderer){

                    public RenderType renderType() {
                        return DROWNED_GLOW;
                    }
                });
            }
        });
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterPresetEditorsEvent.class, e -> VANILLA_PRESET_EDITORS.forEach((o, presetEditor) -> o.ifPresent(worldPresetResourceKey -> e.register(worldPresetResourceKey, presetEditor))));
        FactoryAPIClient.PlayerEvent.DISCONNECTED_EVENT.register(p -> PackAlbum.applyDefaultResourceAlbum());
        FactoryAPIClient.registerConfigScreen((ModInfo)FactoryAPIPlatform.getModInfo((String)"legacy"), Legacy4JSettingsScreen::new);
        FactoryAPIClient.registerDefaultConfigScreen((String)"minecraft", s -> new OptionsScreen(s, Minecraft.getInstance().options));
    }

    public static void updateChunks() {
        FactoryAPIClient.SECURE_EXECUTOR.execute(() -> Minecraft.getInstance().levelRenderer.allChanged());
    }

    public static void updateSkyShape() {
        FactoryAPIClient.SECURE_EXECUTOR.execute(() -> ((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).updateSkyBuffers());
    }

    public static void buildLegacySkyDisc(VertexConsumer consumer, float f) {
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -256; l <= 384; l += 64) {
                float g = k;
                float f1 = k + 64;
                consumer.addVertex(g, f, (float)l);
                consumer.addVertex(f1, f, (float)l);
                consumer.addVertex(f1, f, (float)(l + 64));
                consumer.addVertex(g, f, (float)(l + 64));
            }
        }
    }

    public static BlockStateModel getFastLeavesModelReplacement(BlockGetter blockGetter, BlockPos pos, BlockState blockState, BlockStateModel model) {
        boolean fastGraphics;
        boolean bl = fastGraphics = Minecraft.getInstance().options.graphicsMode().get() == GraphicsStatus.FAST;
        if (((Boolean)LegacyOptions.fastLeavesCustomModels.get()).booleanValue() && blockState.getBlock() instanceof LeavesBlock && fastLeavesModels.containsKey(blockState.getBlock()) && (fastGraphics || ((Boolean)LegacyOptions.fastLeavesWhenBlocked.get()).booleanValue())) {
            if (!fastGraphics && blockGetter != null) {
                for (Direction value : Direction.values()) {
                    BlockPos relative = pos.relative(value);
                    BlockState relativeBlockState = blockGetter.getBlockState(relative);
                    if (relativeBlockState.getBlock() instanceof LeavesBlock || relativeBlockState.isSolidRender()) continue;
                    return model;
                }
            }
            return FactoryAPIClient.getExtraModel((ResourceLocation)fastLeavesModels.get(blockState.getBlock()));
        }
        return model;
    }

    public static boolean hasModOnServer() {
        return FactoryAPIClient.hasModOnServer((String)"legacy");
    }

    public static int getEffectiveRenderDistance() {
        return Minecraft.getInstance().options.getEffectiveRenderDistance();
    }

    public static void onClientPlayerInfoChange() {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (screen instanceof HostOptionsScreen) {
            HostOptionsScreen s = (HostOptionsScreen)screen;
            s.reloadPlayerButtons();
        } else {
            screen = minecraft.screen;
            if (screen instanceof LeaderboardsScreen) {
                LeaderboardsScreen s = (LeaderboardsScreen)screen;
                s.rebuildRenderableVList(minecraft);
                s.repositionElements();
            }
        }
    }

    public static void resetOptions(Minecraft minecraft) {
        whenResetOptions.forEach(Runnable::run);
        for (KeyMapping keyMapping : minecraft.options.keyMappings) {
            keyMapping.setKey(keyMapping.getDefaultKey());
            LegacyKeyMapping.of(keyMapping).setBinding(LegacyKeyMapping.of(keyMapping).getDefaultBinding());
            KeyMapping.resetMapping();
        }
        LegacyOptions.CLIENT_STORAGE.configMap.values().forEach(FactoryConfig::reset);
        LegacyOptions.CLIENT_STORAGE.save();
        LegacyCommonOptions.COMMON_STORAGE.save();
        LegacyCommonOptions.COMMON_STORAGE.configMap.values().forEach(FactoryConfig::reset);
        minecraft.options.save();
    }

    public static String manageAvailableSaveDirName(Consumer<File> copy, Predicate<String> exists, LevelStorageSource source, String levelId) {
        String destId = Legacy4JClient.manageAvailableName(exists, levelId);
        copy.accept(source.getBaseDir().resolve(destId).toFile());
        return destId;
    }

    public static String manageAvailableName(Predicate<String> exists, String saveDirName) {
        StringBuilder builder = new StringBuilder(saveDirName);
        int repeat = 0;
        while (exists.test(String.valueOf(builder) + (repeat > 0 ? String.format(" (%s)", repeat) : ""))) {
            ++repeat;
        }
        if (repeat > 0) {
            builder.append(String.format(" (%s)", repeat));
        }
        return builder.toString();
    }

    public static String importSaveFile(InputStream saveInputStream, Predicate<String> exists, LevelStorageSource source, String saveDirName) {
        return Legacy4JClient.manageAvailableSaveDirName(f -> Legacy4J.copySaveToDirectory(saveInputStream, f), exists, source, saveDirName);
    }

    public static String importSaveFile(InputStream saveInputStream, LevelStorageSource source, String saveDirName) {
        return Legacy4JClient.importSaveFile(saveInputStream, arg_0 -> ((LevelStorageSource)source).levelExists(arg_0), source, saveDirName);
    }

    public static String copySaveFile(Path savePath, LevelStorageSource source, String saveDirName) {
        return Legacy4JClient.manageAvailableSaveDirName(f -> {
            try {
                FileUtils.copyDirectory((File)savePath.toFile(), (File)f);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, arg_0 -> ((LevelStorageSource)source).levelExists(arg_0), source, saveDirName);
    }

    public static void copySaveBtwSources(LevelStorageSource.LevelStorageAccess sendSource, LevelStorageSource destSource) {
        try {
            File destLevelDirectory = destSource.getBaseDir().resolve(sendSource.getLevelId()).toFile();
            if (destLevelDirectory.exists()) {
                FileUtils.deleteQuietly((File)destLevelDirectory);
            }
            FileUtils.copyDirectory((File)sendSource.getDimensionPath(Level.OVERWORLD).toFile(), (File)destLevelDirectory, p -> !p.getName().equals("session.lock"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Pair<Integer, Component> tryParsePort(String string) {
        if (string.isBlank()) {
            return Pair.of((Object)HttpUtil.getAvailablePort(), null);
        }
        try {
            int port = Integer.parseInt(string);
            if (port < 1024 || port > 65535) {
                return Pair.of((Object)port, (Object)Component.translatable((String)"lanServer.port.invalid.new", (Object[])new Object[]{1024, 65535}));
            }
            if (!HttpUtil.isPortAvailable((int)port)) {
                return Pair.of((Object)port, (Object)Component.translatable((String)"lanServer.port.unavailable.new", (Object[])new Object[]{1024, 65535}));
            }
            return Pair.of((Object)port, null);
        }
        catch (NumberFormatException numberFormatException) {
            return Pair.of((Object)HttpUtil.getAvailablePort(), (Object)Component.translatable((String)"lanServer.port.invalid.new", (Object[])new Object[]{1024, 65535}));
        }
    }

    static {
        legacyFont = true;
        forceVanillaFontShadowColor = false;
        defaultFontOverride = null;
        manualSave = false;
        saveExit = false;
        retakeWorldIcon = false;
        legacyLoadingScreen = new LegacyLoadingScreen();
        itemActivationRenderReplacement = null;
        legacyTipManager = new LegacyTipManager();
        legacyCreativeListingManager = new LegacyCreativeTabListing.Manager();
        legacyCraftingListingManager = new LegacyCraftingTabListing.Manager();
        legacyBiomeOverrides = new LegacyBiomeOverride.Manager();
        legacyWorldTemplateManager = new LegacyWorldTemplate.Manager();
        legacyTipOverridesManager = new LegacyTipOverride.Manager();
        legacyResourceManager = new LegacyResourceManager();
        stoneCuttingGroupManager = new StoneCuttingGroupManager();
        loomListingManager = new LoomTabListing.Manager();
        controlTooltipGuiManager = new ControlTooltip.GuiManager();
        leaderBoardListingManager = new LeaderboardsScreen.Manager();
        howToPlaySectionManager = new HowToPlayScreen.Manager();
        controllerManager = new ControllerManager();
        fastLeavesModels = new HashMap<Block, ResourceLocation>();
        MIXIN_CONFIGS_STORAGE = FactoryConfig.StorageHandler.fromMixin((FactoryMixinToggle.Storage)LegacyMixinOptions.CLIENT_MIXIN_STORAGE, (boolean)false);
        GHAST_SHOOTING_GLOW = RenderType.eyes((ResourceLocation)FactoryAPI.createVanillaLocation((String)"textures/entity/ghast/ghast_shooting_glow.png"));
        DROWNED_GLOW = RenderType.eyes((ResourceLocation)FactoryAPI.createVanillaLocation((String)"textures/entity/zombie/drowned_glow.png"));
        VANILLA_PRESET_EDITORS = new HashMap<Optional<ResourceKey>, PresetEditor>(Map.of(Optional.of(WorldPresets.FLAT), (createWorldScreen, settings) -> {
            ChunkGenerator chunkGenerator = settings.selectedDimensions().overworld();
            RegistryAccess.Frozen registryAccess = settings.worldgenLoadContext();
            Registry biomeGetter = registryAccess.lookupOrThrow(Registries.BIOME);
            Registry structureGetter = registryAccess.lookupOrThrow(Registries.STRUCTURE_SET);
            Registry placeFeatureGetter = registryAccess.lookupOrThrow(Registries.PLACED_FEATURE);
            return new LegacyFlatWorldScreen((Screen)createWorldScreen, createWorldScreen.getUiState(), (HolderLookup.RegistryLookup<Biome>)biomeGetter, (HolderLookup.RegistryLookup<StructureSet>)structureGetter, flatLevelGeneratorSettings -> createWorldScreen.getUiState().updateDimensions(PresetEditor.flatWorldConfigurator((FlatLevelGeneratorSettings)flatLevelGeneratorSettings)), chunkGenerator instanceof FlatLevelSource ? ((FlatLevelSource)chunkGenerator).settings() : FlatLevelGeneratorSettings.getDefault((HolderGetter)biomeGetter, (HolderGetter)structureGetter, (HolderGetter)placeFeatureGetter));
        }, Optional.of(WorldPresets.SINGLE_BIOME_SURFACE), (createWorldScreen, settings) -> new LegacyBuffetWorldScreen(createWorldScreen, (HolderLookup.RegistryLookup<Biome>)settings.worldgenLoadContext().lookupOrThrow(Registries.BIOME), holder -> createWorldScreen.getUiState().updateDimensions(PresetEditor.fixedBiomeConfigurator((Holder)holder)))));
        keyCrafting = new KeyMapping("legacy.key.crafting", 69, "key.categories.inventory");
        keyCycleHeldLeft = new KeyMapping("legacy.key.cycleHeldLeft", 267, "key.categories.inventory");
        keyCycleHeldRight = new KeyMapping("legacy.key.cycleHeldRight", 266, "key.categories.inventory");
        keyToggleCursor = new KeyMapping("legacy.key.toggleCursor", -1, "key.categories.misc");
        keyHostOptions = new KeyMapping("legacy.key.host_options", 72, "key.categories.misc");
        keyLegacy4JSettings = new KeyMapping("legacy.key.legacy4JSettings", 89, "key.categories.misc");
        keyFlyUp = new KeyMapping("legacy.key.flyUp", 265, "key.categories.movement");
        keyFlyDown = new KeyMapping("legacy.key.flyDown", 264, "key.categories.movement");
        keyFlyLeft = new KeyMapping("legacy.key.flyLeft", 263, "key.categories.movement");
        keyFlyRight = new KeyMapping("legacy.key.flyRight", 262, "key.categories.movement");
    }
}

