/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.controller;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.ToggleKeyMapping;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ControlTooltip;

public abstract class BindingState {
    public final ControllerBinding<?> binding;
    public boolean justPressed = false;
    public int timePressed = -1;
    public int blockAmount = 0;
    public boolean pressed;
    public boolean released;

    public static BindingState create(ControllerBinding<?> component, final Predicate<Controller> update) {
        return new BindingState(component){

            @Override
            public void update(Controller controller) {
                this.update(update.test(controller));
            }
        };
    }

    protected BindingState(ControllerBinding<?> binding) {
        this.binding = binding;
    }

    public void update(boolean pressed) {
        this.released = !pressed && this.pressed;
        if (this.released) {
            this.timePressed = -1;
        }
        if (pressed) {
            ++this.timePressed;
        }
        this.justPressed = pressed && !this.pressed;
        this.pressed = pressed;
        if (this.justPressed) {
            --this.blockAmount;
        }
    }

    public ControlTooltip.LegacyIcon getIcon() {
        return this.binding.getIcon();
    }

    public boolean canClick() {
        return this.canClick(this.getDefaultDelay());
    }

    public boolean canClick(int delay) {
        return (this.timePressed == 0 || this.timePressed >= 3 * delay) && this.timePressed % delay == 0 && !this.isBlocked();
    }

    public boolean onceClick(int timeDelay) {
        int lastTimePressed = this.timePressed;
        if (this.timePressed == 0) {
            this.timePressed = timeDelay;
        }
        return lastTimePressed == 0 && !this.isBlocked();
    }

    public int getDefaultDelay() {
        return 100;
    }

    public boolean onceClick(boolean block) {
        boolean onceClick = this.onceClick(-(this.justPressed ? 3 : 1) * this.getDefaultDelay());
        if (block) {
            this.block();
        }
        return onceClick;
    }

    public abstract void update(Controller var1);

    public boolean is(ControllerBinding<?> b) {
        return this.binding == b;
    }

    public <T extends BindingState> boolean isAnd(ControllerBinding<T> binding, Predicate<T> predicate) {
        return this.is(binding) && predicate.test(this);
    }

    public void block() {
        this.block(1);
    }

    public void block(int blockAmount) {
        this.blockAmount = blockAmount;
    }

    public boolean isBlocked() {
        return this.blockAmount > 0;
    }

    public boolean canDownKeyMapping(KeyMapping mapping) {
        return !(mapping instanceof ToggleKeyMapping) && this.canClick() || this.timePressed == 0;
    }

    public boolean canReleaseKeyMapping(KeyMapping mapping) {
        return this.released;
    }

    public boolean matches(KeyMapping mapping) {
        return ((LegacyKeyMapping)mapping).getBinding() == this.binding;
    }

    public static abstract class Axis
    extends BindingState {
        public final ArbitrarySupplier<ControllerBinding.Axis> xAxis;
        public final ArbitrarySupplier<ControllerBinding.Axis> yAxis;
        public float x;
        public float y;

        protected Axis(ControllerBinding<?> component, ArbitrarySupplier<ControllerBinding.Axis> xAxis, ArbitrarySupplier<ControllerBinding.Axis> yAxis) {
            super(component);
            this.xAxis = xAxis;
            this.yAxis = yAxis;
        }

        public static Axis createStick(ControllerBinding<?> component, final Supplier<Float> deadZoneGetter, final BiConsumer<Axis, Controller> update, boolean left) {
            return new Axis(component, () -> left ? ControllerBinding.Axis.LEFT_STICK_X : ControllerBinding.Axis.RIGHT_STICK_X, () -> left ? ControllerBinding.Axis.LEFT_STICK_Y : ControllerBinding.Axis.RIGHT_STICK_Y){

                @Override
                public float getDeadZone() {
                    return ((Float)deadZoneGetter.get()).floatValue();
                }

                @Override
                public void update(Controller controller) {
                    super.update(controller);
                    update.accept(this, controller);
                }
            };
        }

        public static Axis createTrigger(ControllerBinding<?> component, final Supplier<Float> deadZoneGetter, boolean left) {
            return new Axis(component, ArbitrarySupplier.empty(), () -> left ? ControllerBinding.Axis.LEFT_TRIGGER : ControllerBinding.Axis.RIGHT_TRIGGER){

                @Override
                public float getDeadZone() {
                    return ((Float)deadZoneGetter.get()).floatValue();
                }
            };
        }

        @Override
        public void update(Controller controller) {
            this.xAxis.ifPresent(axis -> {
                this.x = controller.hasAxis((ControllerBinding.Axis)((Object)axis)) ? controller.axisValue(controller.getHandler().getAxisIndex((ControllerBinding.Axis)((Object)axis))) : 0.0f;
            });
            this.yAxis.ifPresent(axis -> {
                this.y = controller.hasAxis((ControllerBinding.Axis)((Object)axis)) ? controller.axisValue(controller.getHandler().getAxisIndex((ControllerBinding.Axis)((Object)axis))) : 0.0f;
            });
            this.update(this.getMagnitude() >= this.getDeadZone());
        }

        public abstract float getDeadZone();

        public float getMagnitude() {
            return Math.max(Math.abs(this.y), Math.abs(this.x));
        }

        public float getSmoothX() {
            return (this.x > this.getDeadZone() ? this.x - this.getDeadZone() : (this.x < -this.getDeadZone() ? this.x + this.getDeadZone() : 0.0f)) / (1.0f - this.getDeadZone());
        }

        public float getSmoothY() {
            return (this.y > this.getDeadZone() ? this.y - this.getDeadZone() : (this.y < -this.getDeadZone() ? this.y + this.getDeadZone() : 0.0f)) / (1.0f - this.getDeadZone());
        }
    }

    public static class Button
    extends BindingState {
        public final ArbitrarySupplier<ControllerBinding.Button> button;

        protected Button(ControllerBinding<?> binding, ArbitrarySupplier<ControllerBinding.Button> button) {
            super(binding);
            this.button = button;
        }

        @Override
        public void update(Controller controller) {
            this.update(controller.hasButton((ControllerBinding.Button)((Object)this.button.get())) && controller.buttonPressed(controller.getHandler().getButtonIndex((ControllerBinding.Button)((Object)this.button.get()))));
        }
    }
}

