/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.SaveRenderableList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.MCAccount;
import wily.legacy.util.ScreenUtil;

public class ChooseUserScreen
extends PanelVListScreen {
    public static final Component CHOOSE_USER = Component.translatable((String)"legacy.menu.choose_user");
    public static final Component CHOOSE_USER_MESSAGE = Component.translatable((String)"legacy.menu.choose_user_message");
    public static final Component ADD_ACCOUNT = Component.translatable((String)"legacy.menu.choose_user.add");
    public static final Component ACCOUNT_OPTIONS = Component.translatable((String)"legacy.menu.choose_user.account_options");
    public static final Component DIRECT_LOGIN = Component.translatable((String)"legacy.menu.choose_user.direct_login");
    public static final Component ACCOUNT_OPTIONS_MESSAGE = Component.translatable((String)"legacy.menu.choose_user.account_options_message");
    public static final Component EDIT_ACCOUNT = Component.translatable((String)"legacy.menu.choose_user.account_options.edit");
    public static final Component DELETE_ACCOUNT = Component.translatable((String)"legacy.menu.choose_user.account_options.delete");
    public static final Component ACCOUNT_ENCRYPTION = Component.translatable((String)"legacy.menu.choose_user.add.encryption");
    public static final Component ACCOUNT_ENCRYPTION_MESSAGE = Component.translatable((String)"legacy.menu.choose_user.add.encryption_message");
    public static final Component ADD_WITH_ENCRYPTION = Component.translatable((String)"legacy.menu.choose_user.add.encryption.present");
    public static final Component ADD_WITHOUT_ENCRYPTION = Component.translatable((String)"legacy.menu.choose_user.add.encryption.absent");
    public static final Component VISIBLE_PASSWORD = Component.translatable((String)"legacy.menu.choose_user.add.encryption.visible_password");
    public static final Pattern usernamePattern = Pattern.compile("[A-Za-z0-9_]{2,16}");

    public ChooseUserScreen(Screen parent) {
        super(parent, s -> Panel.centered(s, 260, 215, 0, 10), CHOOSE_USER);
        this.renderableVList.layoutSpacing(i -> 0);
        this.addAccountButtons();
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> this.getFocused() == null || this.renderableVList.renderables.indexOf(this.getFocused()) <= 0 ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon()), () -> ACCOUNT_OPTIONS);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> DIRECT_LOGIN);
    }

    @Override
    public boolean keyPressed(int i, int j, int k) {
        if (i == 88) {
            this.minecraft.setScreen((Screen)ChooseUserScreen.accountScreen(DIRECT_LOGIN, this, false, this::manageLogin));
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public void reloadAccountButtons() {
        int i = this.renderableVList.renderables.indexOf(this.getFocused());
        this.renderableVList.renderables.clear();
        this.addAccountButtons();
        this.repositionElements();
        if (i >= 0 && i < this.renderableVList.renderables.size()) {
            this.setFocused((GuiEventListener)this.renderableVList.renderables.get(i));
        }
    }

    @Override
    public void renderableVListInit() {
        this.addRenderableOnly((guiGraphics, i, j, f) -> {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.getX() + 10, this.panel.getY() + 13, this.panel.getWidth() - 20, this.panel.getHeight() - 26);
            guiGraphics.drawString(this.font, this.getTitle(), this.panel.getX() + (this.panel.getWidth() - this.font.width((FormattedText)this.getTitle())) / 2, this.panel.y + 20, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        });
        this.getRenderableVList().init(this.panel.x + 15, this.panel.y + 32, this.panel.width - 30, this.panel.height - 50);
    }

    public static ConfirmationScreen passwordScreen(Screen parent, Consumer<String> pass) {
        final EditBox passWordBox = new EditBox(Minecraft.getInstance().font, 0, 0, 200, 20, (Component)Component.translatable((String)"legacy.menu.choose_user.add.encryption.password"));
        final TickBox tickBox = new TickBox(0, 0, true, bol -> VISIBLE_PASSWORD, bol -> null, t -> passWordBox.setFormatter((s, i) -> FormattedCharSequence.forward((String)(t.selected ? s : "*".repeat(s.length())), (Style)Style.EMPTY)));
        tickBox.onPress();
        return new ConfirmationScreen(parent, 230, 120, passWordBox.getMessage(), (Component)Component.translatable((String)"legacy.menu.choose_user.add.encryption.password_message"), b1 -> pass.accept(passWordBox.getValue())){

            @Override
            protected void addButtons() {
                super.addButtons();
                this.okButton.active = false;
            }

            @Override
            protected void init() {
                super.init();
                tickBox.setPosition(this.panel.getX() + 15, this.panel.getY() + 68);
                this.addRenderableWidget((GuiEventListener)tickBox);
                passWordBox.setPosition(this.panel.getX() + 15, this.panel.getY() + 45);
                passWordBox.setResponder(s -> {
                    this.okButton.active = !s.isEmpty();
                });
                this.addRenderableWidget((GuiEventListener)passWordBox);
            }
        };
    }

    public static ConfirmationScreen accountScreen(Component title, Screen parent, final boolean allowEncryption, final Consumer<MCAccount> press) {
        return new ConfirmationScreen(parent, 230, 120, title, CHOOSE_USER_MESSAGE){

            @Override
            protected void addButtons() {
                this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).build());
                this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.choose_user.microsoft"), b -> {
                    if (allowEncryption) {
                        this.minecraft.setScreen((Screen)new ConfirmationScreen(this, this, ACCOUNT_ENCRYPTION, ACCOUNT_ENCRYPTION_MESSAGE){

                            @Override
                            protected void addButtons() {
                                this.renderableVList.addRenderable((Renderable)Button.builder((Component)ADD_WITH_ENCRYPTION, b -> this.minecraft.setScreen((Screen)ChooseUserScreen.passwordScreen(this, s -> MCAccount.create(() -> this.minecraft.setScreen((Screen)this), s).thenAcceptAsync(press, (Executor)this.minecraft)))).build());
                                this.renderableVList.addRenderable((Renderable)Button.builder((Component)ADD_WITHOUT_ENCRYPTION, b -> MCAccount.create(() -> this.minecraft.setScreen((Screen)this), null).thenAcceptAsync(press, (Executor)this.minecraft)).build());
                            }
                        });
                    } else {
                        MCAccount.create(() -> this.minecraft.setScreen((Screen)this), null).thenAcceptAsync(press, (Executor)this.minecraft);
                    }
                }).build());
                this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.choose_user.offline"), b -> {
                    final EditBox usernameBox = new EditBox(Minecraft.getInstance().font, 0, 0, 200, 20, (Component)Component.translatable((String)"legacy.menu.choose_user.offline.username"));
                    this.minecraft.setScreen((Screen)new ConfirmationScreen(this, this, 230, 120, usernameBox.getMessage(), (Component)Component.translatable((String)"legacy.menu.choose_user.offline.username_message"), b1 -> press.accept(MCAccount.create(new GameProfile(UUID.nameUUIDFromBytes(("offline:" + usernameBox.getValue()).getBytes()), usernameBox.getValue()), false, null, null))){

                        @Override
                        protected void addButtons() {
                            super.addButtons();
                            this.okButton.active = false;
                        }

                        @Override
                        protected void init() {
                            super.init();
                            usernameBox.setPosition(this.panel.getX() + 15, this.panel.getY() + 45);
                            usernameBox.setResponder(s -> {
                                boolean matches = usernamePattern.matcher((CharSequence)s).matches();
                                usernameBox.setTextColor(matches ? 0xFFFFFF : 0xFF5555);
                                this.okButton.active = matches;
                            });
                            this.addRenderableWidget((GuiEventListener)usernameBox);
                        }
                    });
                }).build());
            }
        };
    }

    public void manageLogin(MCAccount account) {
        if (account.isEncrypted()) {
            this.minecraft.setScreen((Screen)ChooseUserScreen.passwordScreen(this, s -> account.login(this, (String)s)));
        } else {
            account.login(this, null);
        }
    }

    protected void addAccountButtons() {
        final Minecraft minecraft = Minecraft.getInstance();
        CreationList.addIconButton(this.renderableVList, Legacy4J.createModLocation("icon/add_user"), ADD_ACCOUNT, b -> minecraft.setScreen((Screen)ChooseUserScreen.accountScreen(ADD_ACCOUNT, this, true, a -> {
            MCAccount.list.add((MCAccount)a);
            MCAccount.saveAll();
            this.reloadAccountButtons();
            minecraft.setScreen((Screen)this);
        })));
        for (final MCAccount account : MCAccount.list) {
            this.renderableVList.addRenderable((Renderable)new AbstractButton(0, 0, 230, 30, (Component)(account.getMSARefreshToken(null).isEmpty() ? Component.translatable((String)"legacy.menu.offline_user", (Object[])new Object[]{account.getProfile().getName()}) : Component.literal((String)account.getProfile().getName()))){

                protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
                    super.renderWidget(guiGraphics, i, j, f);
                    PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (PlayerSkin)minecraft.getSkinManager().getInsecureSkin(account.getProfile()), (int)(this.getX() + 5), (int)(this.getY() + 5), (int)20);
                    if (((Boolean)minecraft.options.touchscreen().get()).booleanValue() || this.isHovered()) {
                        guiGraphics.fill(this.getX() + 5, this.getY() + 5, this.getX() + 25, this.getY() + 25, -1601138544);
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(ScreenUtil.isMouseOver(i, j, this.getX() + 5, this.getY() + 5, 20, 20) ? SaveRenderableList.JOIN_HIGHLIGHTED : SaveRenderableList.JOIN, this.getX() + 5, this.getY() + 5, 20, 20);
                    }
                }

                protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
                    ScreenUtil.renderScrollingString(guiGraphics, font, this.getMessage(), this.getX() + 30, this.getY(), this.getX() + this.getWidth() - 2, this.getY() + this.getHeight(), j, true);
                }

                public boolean mouseClicked(double d, double e, int i) {
                    if (ScreenUtil.isMouseOver(d, e, this.getX() + 5, this.getY() + 5, 20, 20)) {
                        ChooseUserScreen.this.manageLogin(account);
                    }
                    return super.mouseClicked(d, e, i);
                }

                public boolean keyPressed(int i, int j, int k) {
                    if (i == 79) {
                        minecraft.setScreen((Screen)new ConfirmationScreen(ChooseUserScreen.this, 230, 120, ACCOUNT_OPTIONS, ACCOUNT_OPTIONS_MESSAGE, b -> {}){

                            @Override
                            protected void addButtons() {
                                this.renderableVList.addRenderable((Renderable)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> this.onClose()).build());
                                this.renderableVList.addRenderable((Renderable)Button.builder((Component)EDIT_ACCOUNT, b -> this.minecraft.setScreen((Screen)ChooseUserScreen.accountScreen(EDIT_ACCOUNT, this, true, a -> {
                                    MCAccount.list.set(MCAccount.list.indexOf(account), (MCAccount)a);
                                    MCAccount.saveAll();
                                    ChooseUserScreen.this.reloadAccountButtons();
                                    this.minecraft.setScreen((Screen)ChooseUserScreen.this);
                                }))).build());
                                this.renderableVList.addRenderable((Renderable)Button.builder((Component)DELETE_ACCOUNT, b -> {
                                    MCAccount.list.remove(account);
                                    MCAccount.saveAll();
                                    ChooseUserScreen.this.reloadAccountButtons();
                                    this.minecraft.setScreen((Screen)ChooseUserScreen.this);
                                }).build());
                            }
                        });
                        return true;
                    }
                    return super.keyPressed(i, j, k);
                }

                public void onPress() {
                    if (this.isFocused()) {
                        ChooseUserScreen.this.manageLogin(account);
                    }
                }

                protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                    this.defaultButtonNarrationText(narrationElementOutput);
                }
            });
        }
    }
}

